/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTWriter;
import com.hazelcast.shaded.org.locationtech.jts.math.DD;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class DDOrientationIndexAccuracyTest
extends GeometryTestCase {
    private static final boolean USE_ACCURATE_CONVERSION = false;
    static final DDConverter DD_STD = new DDConverter(){

        @Override
        public DD convert(double x) {
            return DD.valueOf((double)x);
        }
    };
    static final DDConverter DD_DEC = new DDConverter(){

        @Override
        public DD convert(double x) {
            return DD.valueOf((String)(x + ""));
        }
    };

    public static void main(String[] args) {
        TestRunner.run(DDOrientationIndexAccuracyTest.class);
    }

    public DDOrientationIndexAccuracyTest(String name) {
        super(name);
    }

    public void testRightTriangleForDeterminant() {
        this.checkLine45(1, 100, 100.0);
    }

    private void checkLine45(int width, int nPts, double precision) {
        Coordinate p1 = new Coordinate(0.0, (double)width);
        Coordinate p2 = new Coordinate((double)width, 0.0);
        for (int i = 0; i <= nPts; ++i) {
            double d = (double)width / (double)nPts;
            Coordinate q = new Coordinate(0.0 + (double)i * d, (double)width - (double)i * d);
            PrecisionModel pm = new PrecisionModel(precision);
            pm.makePrecise(q);
            this.checkPointOnSeg(p1, p2, q);
        }
    }

    private void checkPointOnSeg(Coordinate p1, Coordinate p2, Coordinate q) {
        System.out.println("  Pt: " + WKTWriter.toPoint((Coordinate)q) + "  seg: " + WKTWriter.toLineString((Coordinate)p1, (Coordinate)p2) + " --- DDstd = " + DDOrientationIndexAccuracyTest.orientationDet(p1, p2, q, DD_STD) + " --- DDdec = " + DDOrientationIndexAccuracyTest.orientationDet(p1, p2, q, DD_DEC));
    }

    public static DD orientationDet(Coordinate p1, Coordinate p2, Coordinate q, DDConverter conv) {
        DD dx1 = conv.convert(p2.x).selfAdd(conv.convert(-p1.x));
        DD dy1 = conv.convert(p2.y).selfAdd(conv.convert(-p1.y));
        DD dx2 = conv.convert(q.x).selfAdd(conv.convert(-p2.x));
        DD dy2 = conv.convert(q.y).selfAdd(conv.convert(-p2.y));
        return dx1.selfMultiply(dy2).selfSubtract(dy1.selfMultiply(dx2));
    }

    private static DD convertToDD(double x) {
        return DD.valueOf((double)x);
    }

    static interface DDConverter {
        public DD convert(double var1);
    }
}

