/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;

public class AreaPrecisionPerfTest {
    public static void main(String[] args) throws Exception {
        double originX = 1000000.0;
        double originY = 5000000.0;
        long start = System.currentTimeMillis();
        for (int nrVertices = 4; nrVertices <= 1000000; nrVertices *= 2) {
            Coordinate[] coordinates = new Coordinate[nrVertices + 1];
            for (int i = 0; i <= nrVertices; ++i) {
                Coordinate vertex;
                coordinates[i] = vertex = new Coordinate(originX + (1.0 + Math.sin((double)((float)i / (float)nrVertices * 2.0f) * Math.PI)), originY + (1.0 + Math.cos((double)((float)i / (float)nrVertices * 2.0f) * Math.PI)));
            }
            coordinates[nrVertices] = coordinates[0];
            LinearRing g1 = new GeometryFactory().createLinearRing(coordinates);
            LinearRing[] holes = new LinearRing[]{};
            Polygon polygon = new GeometryFactory().createPolygon(g1, holes);
            System.out.println(polygon);
            double area = AreaPrecisionPerfTest.originalSignedArea(coordinates);
            double area2 = AreaPrecisionPerfTest.accurateSignedArea(coordinates);
            double exactArea = 0.5 * (double)nrVertices * Math.sin(Math.PI * 2 / (double)nrVertices);
            double eps = exactArea - area;
            double eps2 = exactArea - area2;
            System.out.println(nrVertices + "   orig err: " + eps + "    acc err: " + eps2);
        }
        System.out.println("Time: " + (double)(System.currentTimeMillis() - start) / 1000.0);
    }

    public static double originalSignedArea(Coordinate[] ring) {
        if (ring.length < 3) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < ring.length - 1; ++i) {
            double bx = ring[i].x;
            double by = ring[i].y;
            double cx = ring[i + 1].x;
            double cy = ring[i + 1].y;
            sum += (bx + cx) * (cy - by);
        }
        return -sum / 2.0;
    }

    public static double accurateSignedArea(Coordinate[] ring) {
        if (ring.length < 3) {
            return 0.0;
        }
        double sum = 0.0;
        double x0 = ring[0].x;
        for (int i = 1; i < ring.length - 1; ++i) {
            double x = ring[i].x - x0;
            double y1 = ring[i + 1].y;
            double y2 = ring[i == 0 ? ring.length - 1 : i - 1].y;
            sum += x * (y2 - y1);
        }
        return sum / 2.0;
    }
}

