/*
 * Decompiled with CFR 0.152.
 */
package test.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;

public class GeometryTestFactory {
    public static Coordinate[] createBox(double minx, double miny, int nSide, double segLen) {
        double y;
        double x;
        int i;
        int ipt = 0;
        Coordinate[] pts = new Coordinate[4 * nSide + 1];
        double maxx = minx + (double)nSide * segLen;
        double maxy = miny + (double)nSide * segLen;
        for (i = 0; i < nSide; ++i) {
            x = minx + (double)i * segLen;
            y = miny;
            pts[ipt++] = new Coordinate(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            x = maxx;
            y = miny + (double)i * segLen;
            pts[ipt++] = new Coordinate(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            x = maxx - (double)i * segLen;
            y = maxy;
            pts[ipt++] = new Coordinate(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            x = minx;
            y = maxy - (double)i * segLen;
            pts[ipt++] = new Coordinate(x, y);
        }
        pts[ipt++] = new Coordinate(pts[0]);
        return pts;
    }

    public static Polygon createCircle(GeometryFactory fact, double basex, double basey, double size, int nPts) {
        Coordinate[] pts = GeometryTestFactory.createCircle(basex, basey, size, nPts);
        LinearRing ring = fact.createLinearRing(pts);
        Polygon poly = fact.createPolygon(ring, null);
        return poly;
    }

    public static Coordinate[] createCircle(double basex, double basey, double size, int nPts) {
        Coordinate[] pts = new Coordinate[nPts + 1];
        int iPt = 0;
        double len = size / 2.0;
        for (int i = 0; i < nPts; ++i) {
            double ang = (double)i * (Math.PI * 2 / (double)nPts);
            double x = len * Math.cos(ang) + basex;
            double y = len * Math.sin(ang) + basey;
            Coordinate pt = new Coordinate(x, y);
            pts[iPt++] = pt;
        }
        pts[iPt] = pts[0];
        return pts;
    }

    public static Polygon createBox(GeometryFactory fact, double minx, double miny, int nSide, double segLen) {
        Coordinate[] pts = GeometryTestFactory.createBox(minx, minx, nSide, segLen);
        LinearRing ring = fact.createLinearRing(pts);
        Polygon poly = fact.createPolygon(ring, null);
        return poly;
    }

    public static Coordinate[] createSineStar(double basex, double basey, double size, double armLen, int nArms, int nPts) {
        double armBaseLen = size / 2.0 - armLen;
        if (armBaseLen < 0.0) {
            armBaseLen = 0.5;
        }
        double angInc = Math.PI * 2 / (double)nArms;
        int nArmPt = nPts / nArms;
        if (nArmPt < 5) {
            nArmPt = 5;
        }
        int nPts2 = nArmPt * nArms;
        Coordinate[] pts = new Coordinate[nPts2 + 1];
        int iPt = 0;
        double starAng = 0.0;
        for (int iArm = 0; iArm < nArms; ++iArm) {
            for (int iArmPt = 0; iArmPt < nArmPt; ++iArmPt) {
                double ang = (double)iArmPt * (Math.PI * 2 / (double)nArmPt);
                double len = armLen * (1.0 - Math.cos(ang) / 2.0) + armBaseLen;
                double x = len * Math.cos(starAng + (double)iArmPt * angInc / (double)nArmPt) + basex;
                double y = len * Math.sin(starAng + (double)iArmPt * angInc / (double)nArmPt) + basey;
                Coordinate pt = new Coordinate(x, y);
                pts[iPt++] = pt;
            }
            starAng += angInc;
        }
        pts[iPt] = pts[0];
        return pts;
    }

    public static Polygon createSineStar(GeometryFactory fact, double basex, double basey, double size, double armLen, int nArms, int nPts) {
        Coordinate[] pts = GeometryTestFactory.createSineStar(basex, basey, size, armLen, nArms, nPts);
        LinearRing ring = fact.createLinearRing(pts);
        Polygon poly = fact.createPolygon(ring, null);
        return poly;
    }
}

