/*
 * Decompiled with CFR 0.152.
 */
package test.jts;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import com.hazelcast.shaded.org.locationtech.jts.io.WKBReader;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;

public class WKTorBReader {
    private static final int MAX_CHARS_TO_CHECK = 6;
    private GeometryFactory geomFactory;

    public static Geometry read(String geomStr, GeometryFactory geomfact) {
        WKTorBReader rdr = new WKTorBReader(geomfact);
        try {
            return rdr.read(geomStr);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static boolean isWKB(String str) {
        return WKTorBReader.isHex(str, 6);
    }

    private static boolean isHex(String str, int maxCharsToTest) {
        for (int i = 0; i < maxCharsToTest && i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (WKTorBReader.isHexDigit(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isHexDigit(char ch) {
        if (Character.isDigit(ch)) {
            return true;
        }
        char chLow = Character.toLowerCase(ch);
        return chLow >= 'a' && chLow <= 'f';
    }

    public WKTorBReader(GeometryFactory geomFact) {
        this.geomFactory = geomFact;
    }

    public Geometry read(String geomStr) throws ParseException {
        String trimStr = geomStr.trim();
        if (WKTorBReader.isWKB(trimStr)) {
            return WKTorBReader.readWKBHex(trimStr, this.geomFactory);
        }
        return WKTorBReader.readWKT(trimStr, this.geomFactory);
    }

    public static Geometry readWKT(String wkt, GeometryFactory geomFact) throws ParseException {
        WKTReader rdr = new WKTReader(geomFact);
        return rdr.read(wkt);
    }

    public static Geometry readWKBHex(String wkb, GeometryFactory geomFact) throws ParseException {
        WKBReader rdr = new WKBReader(geomFact);
        return rdr.read(WKBReader.hexToBytes((String)wkb));
    }
}

