/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.sql.impl.SqlCustomClass;
import com.hazelcast.sql.impl.expression.RowValue;
import com.hazelcast.sql.impl.schema.type.TypeKind;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import com.hazelcast.sql.impl.type.SqlDaySecondInterval;
import com.hazelcast.sql.impl.type.SqlYearMonthInterval;
import com.hazelcast.sql.impl.type.converter.BigDecimalConverter;
import com.hazelcast.sql.impl.type.converter.BigIntegerConverter;
import com.hazelcast.sql.impl.type.converter.BooleanConverter;
import com.hazelcast.sql.impl.type.converter.ByteConverter;
import com.hazelcast.sql.impl.type.converter.CalendarConverter;
import com.hazelcast.sql.impl.type.converter.CharacterConverter;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.DateConverter;
import com.hazelcast.sql.impl.type.converter.DoubleConverter;
import com.hazelcast.sql.impl.type.converter.FloatConverter;
import com.hazelcast.sql.impl.type.converter.InstantConverter;
import com.hazelcast.sql.impl.type.converter.IntegerConverter;
import com.hazelcast.sql.impl.type.converter.IntervalConverter;
import com.hazelcast.sql.impl.type.converter.JsonConverter;
import com.hazelcast.sql.impl.type.converter.LocalDateConverter;
import com.hazelcast.sql.impl.type.converter.LocalDateTimeConverter;
import com.hazelcast.sql.impl.type.converter.LocalTimeConverter;
import com.hazelcast.sql.impl.type.converter.LongConverter;
import com.hazelcast.sql.impl.type.converter.MapConverter;
import com.hazelcast.sql.impl.type.converter.NullConverter;
import com.hazelcast.sql.impl.type.converter.ObjectConverter;
import com.hazelcast.sql.impl.type.converter.OffsetDateTimeConverter;
import com.hazelcast.sql.impl.type.converter.RowConverter;
import com.hazelcast.sql.impl.type.converter.ShortConverter;
import com.hazelcast.sql.impl.type.converter.StringConverter;
import com.hazelcast.sql.impl.type.converter.ZonedDateTimeConverter;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class QueryDataTypeTest
extends HazelcastTestSupport {
    private static InternalSerializationService serializationService;

    @BeforeClass
    public static void setup() {
        serializationService = new DefaultSerializationServiceBuilder().build();
    }

    @AfterClass
    public static void tearDown() {
        serializationService.dispose();
    }

    @Test
    public void testResolutionByConverter() {
        this.checkConverter(QueryDataType.VARCHAR, (Converter)StringConverter.INSTANCE);
        this.checkConverter(QueryDataType.VARCHAR_CHARACTER, (Converter)CharacterConverter.INSTANCE);
        this.checkConverter(QueryDataType.BOOLEAN, (Converter)BooleanConverter.INSTANCE);
        this.checkConverter(QueryDataType.TINYINT, (Converter)ByteConverter.INSTANCE);
        this.checkConverter(QueryDataType.SMALLINT, (Converter)ShortConverter.INSTANCE);
        this.checkConverter(QueryDataType.INT, (Converter)IntegerConverter.INSTANCE);
        this.checkConverter(QueryDataType.BIGINT, (Converter)LongConverter.INSTANCE);
        this.checkConverter(QueryDataType.DECIMAL, (Converter)BigDecimalConverter.INSTANCE);
        this.checkConverter(QueryDataType.DECIMAL_BIG_INTEGER, (Converter)BigIntegerConverter.INSTANCE);
        this.checkConverter(QueryDataType.REAL, (Converter)FloatConverter.INSTANCE);
        this.checkConverter(QueryDataType.DOUBLE, (Converter)DoubleConverter.INSTANCE);
        this.checkConverter(QueryDataType.TIME, (Converter)LocalTimeConverter.INSTANCE);
        this.checkConverter(QueryDataType.DATE, (Converter)LocalDateConverter.INSTANCE);
        this.checkConverter(QueryDataType.TIMESTAMP, (Converter)LocalDateTimeConverter.INSTANCE);
        this.checkConverter(QueryDataType.TIMESTAMP_WITH_TZ_DATE, (Converter)DateConverter.INSTANCE);
        this.checkConverter(QueryDataType.TIMESTAMP_WITH_TZ_CALENDAR, (Converter)CalendarConverter.INSTANCE);
        this.checkConverter(QueryDataType.TIMESTAMP_WITH_TZ_INSTANT, (Converter)InstantConverter.INSTANCE);
        this.checkConverter(QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, (Converter)OffsetDateTimeConverter.INSTANCE);
        this.checkConverter(QueryDataType.TIMESTAMP_WITH_TZ_ZONED_DATE_TIME, (Converter)ZonedDateTimeConverter.INSTANCE);
        this.checkConverter(QueryDataType.OBJECT, (Converter)ObjectConverter.INSTANCE);
        this.checkConverter(new QueryDataType("CustomType"), (Converter)ObjectConverter.INSTANCE);
        this.checkConverter(QueryDataType.NULL, (Converter)NullConverter.INSTANCE);
        this.checkConverter(QueryDataType.INTERVAL_YEAR_MONTH, (Converter)IntervalConverter.YEAR_MONTH);
        this.checkConverter(QueryDataType.INTERVAL_DAY_SECOND, (Converter)IntervalConverter.DAY_SECOND);
        this.checkConverter(QueryDataType.MAP, (Converter)MapConverter.INSTANCE);
        this.checkConverter(QueryDataType.JSON, (Converter)JsonConverter.INSTANCE);
        this.checkConverter(QueryDataType.ROW, (Converter)RowConverter.INSTANCE);
    }

    @Test
    public void testResolutionByClass() {
        this.checkClasses(QueryDataType.VARCHAR, String.class);
        this.checkClasses(QueryDataType.VARCHAR_CHARACTER, Character.TYPE, Character.class);
        this.checkClasses(QueryDataType.BOOLEAN, Boolean.TYPE, Boolean.class);
        this.checkClasses(QueryDataType.TINYINT, Byte.TYPE, Byte.class);
        this.checkClasses(QueryDataType.SMALLINT, Short.TYPE, Short.class);
        this.checkClasses(QueryDataType.INT, Integer.TYPE, Integer.class);
        this.checkClasses(QueryDataType.BIGINT, Long.TYPE, Long.class);
        this.checkClasses(QueryDataType.DECIMAL, BigDecimal.class);
        this.checkClasses(QueryDataType.DECIMAL_BIG_INTEGER, BigInteger.class);
        this.checkClasses(QueryDataType.REAL, Float.TYPE, Float.class);
        this.checkClasses(QueryDataType.DOUBLE, Double.TYPE, Double.class);
        this.checkClasses(QueryDataType.TIME, LocalTime.class);
        this.checkClasses(QueryDataType.DATE, LocalDate.class);
        this.checkClasses(QueryDataType.TIMESTAMP, LocalDateTime.class);
        this.checkClasses(QueryDataType.TIMESTAMP_WITH_TZ_DATE, Date.class);
        this.checkClasses(QueryDataType.TIMESTAMP_WITH_TZ_CALENDAR, Calendar.class, GregorianCalendar.class);
        this.checkClasses(QueryDataType.TIMESTAMP_WITH_TZ_INSTANT, Instant.class);
        this.checkClasses(QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, OffsetDateTime.class);
        this.checkClasses(QueryDataType.TIMESTAMP_WITH_TZ_ZONED_DATE_TIME, ZonedDateTime.class);
        this.checkClasses(QueryDataType.OBJECT, Object.class, SqlCustomClass.class);
        this.checkClasses(QueryDataType.NULL, Void.TYPE, Void.class);
        this.checkClasses(QueryDataType.INTERVAL_YEAR_MONTH, SqlYearMonthInterval.class);
        this.checkClasses(QueryDataType.INTERVAL_DAY_SECOND, SqlDaySecondInterval.class);
        this.checkClasses(QueryDataType.MAP, Map.class, HashMap.class);
        this.checkClasses(QueryDataType.JSON, HazelcastJsonValue.class);
        this.checkClasses(QueryDataType.ROW, RowValue.class);
    }

    @Test
    public void testResolutionByName() {
        this.checkName(QueryDataType.VARCHAR, "VARCHAR");
        this.checkName(QueryDataType.VARCHAR_CHARACTER, "VARCHAR_CHARACTER");
        this.checkName(QueryDataType.BOOLEAN, "BOOLEAN");
        this.checkName(QueryDataType.TINYINT, "TINYINT");
        this.checkName(QueryDataType.SMALLINT, "SMALLINT");
        this.checkName(QueryDataType.INT, "INT");
        this.checkName(QueryDataType.BIGINT, "BIGINT");
        this.checkName(QueryDataType.DECIMAL, "DECIMAL");
        this.checkName(QueryDataType.DECIMAL_BIG_INTEGER, "DECIMAL_BIG_INTEGER");
        this.checkName(QueryDataType.REAL, "REAL");
        this.checkName(QueryDataType.DOUBLE, "DOUBLE");
        this.checkName(QueryDataType.TIME, "TIME");
        this.checkName(QueryDataType.DATE, "DATE");
        this.checkName(QueryDataType.TIMESTAMP, "TIMESTAMP");
        this.checkName(QueryDataType.TIMESTAMP_WITH_TZ_DATE, "TIMESTAMP_WITH_TZ_DATE");
        this.checkName(QueryDataType.TIMESTAMP_WITH_TZ_CALENDAR, "TIMESTAMP_WITH_TZ_CALENDAR");
        this.checkName(QueryDataType.TIMESTAMP_WITH_TZ_INSTANT, "TIMESTAMP_WITH_TZ_INSTANT");
        this.checkName(QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, "TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME");
        this.checkName(QueryDataType.TIMESTAMP_WITH_TZ_ZONED_DATE_TIME, "TIMESTAMP_WITH_TZ_ZONED_DATE_TIME");
        this.checkName(QueryDataType.OBJECT, "OBJECT");
        this.checkName(new QueryDataType("CustomType"), "CustomType");
        this.checkName(QueryDataType.NULL, "NULL");
        this.checkName(QueryDataType.INTERVAL_YEAR_MONTH, "INTERVAL_YEAR_MONTH");
        this.checkName(QueryDataType.INTERVAL_DAY_SECOND, "INTERVAL_DAY_SECOND");
        this.checkName(QueryDataType.MAP, "MAP");
        this.checkName(QueryDataType.JSON, "JSON");
        this.checkName(QueryDataType.ROW, "ROW");
    }

    @Test
    public void testSerialization() {
        for (QueryDataType type : QueryDataType.values()) {
            this.checkSerialization(type);
        }
        QueryDataType person = new QueryDataType("Person", TypeKind.COMPACT, "PersonType");
        QueryDataType company = new QueryDataType("Company");
        person.addField("name", QueryDataType.VARCHAR);
        person.addField("employer", company);
        person.addField("friend", person);
        company.addField("id", QueryDataType.BIGINT);
        company.addField("employee", person);
        company.addField("competitor", company);
        person.finalizeFields();
        company.finalizeFields();
        this.checkSerialization(person);
    }

    @Test
    public void testDigestEscaping() {
        QueryDataType person = new QueryDataType("[P(e:r=s,o)n]", TypeKind.PORTABLE, "1:2:3");
        person.addField("name", QueryDataType.VARCHAR);
        person.addField("[(:fri=end,)]", person);
        person.finalizeFields();
        Assert.assertEquals((Object)"\\[P\\(e\\:r\\=s\\,o\\)n\\][PORTABLE=1:2:3](name:VARCHAR, \\[\\(\\:fri\\=end\\,\\)\\]:\\[P\\(e\\:r\\=s\\,o\\)n\\])", (Object)person.getDigest());
    }

    @Test
    public void testFinalization() {
        QueryDataType placeholder = new QueryDataType("Person");
        Assertions.assertThatThrownBy(() -> ((QueryDataType)placeholder).finalizeFields()).hasMessage("Type has no fields");
        Assertions.assertThat((List)placeholder.getObjectFields()).isEmpty();
        Assertions.assertThatThrownBy(() -> placeholder.addField("name", QueryDataType.VARCHAR)).hasMessage("Placeholder types are not expected to have fields");
        Assertions.assertThatThrownBy(() -> ((QueryDataType)placeholder).finalizeFields()).hasMessage("Placeholder types are not expected to have fields");
        QueryDataType person = new QueryDataType("Person");
        Assertions.assertThatThrownBy(() -> ((QueryDataType)person).finalizeFields()).hasMessage("Type has no fields");
        person.addField("name", QueryDataType.VARCHAR);
        person.addField("age", QueryDataType.INT);
        Assertions.assertThatThrownBy(() -> ((QueryDataType)person).getObjectFields()).hasMessage("Type fields are not finalized");
        person.finalizeFields();
        Assertions.assertThat((List)person.getObjectFields()).hasSize(2);
        Assertions.assertThatThrownBy(() -> person.addField("friend", person)).hasMessage("Type fields are already finalized");
        Assertions.assertThatThrownBy(() -> ((QueryDataType)person).finalizeFields()).hasMessage("Type fields are already finalized");
    }

    @Test
    public void testResolutionByFamily() {
        this.checkFamily(QueryDataType.VARCHAR, QueryDataTypeFamily.VARCHAR);
        this.checkFamily(QueryDataType.BOOLEAN, QueryDataTypeFamily.BOOLEAN);
        this.checkFamily(QueryDataType.TINYINT, QueryDataTypeFamily.TINYINT);
        this.checkFamily(QueryDataType.SMALLINT, QueryDataTypeFamily.SMALLINT);
        this.checkFamily(QueryDataType.INT, QueryDataTypeFamily.INTEGER);
        this.checkFamily(QueryDataType.BIGINT, QueryDataTypeFamily.BIGINT);
        this.checkFamily(QueryDataType.DECIMAL, QueryDataTypeFamily.DECIMAL);
        this.checkFamily(QueryDataType.REAL, QueryDataTypeFamily.REAL);
        this.checkFamily(QueryDataType.DOUBLE, QueryDataTypeFamily.DOUBLE);
        this.checkFamily(QueryDataType.TIME, QueryDataTypeFamily.TIME);
        this.checkFamily(QueryDataType.DATE, QueryDataTypeFamily.DATE);
        this.checkFamily(QueryDataType.TIMESTAMP, QueryDataTypeFamily.TIMESTAMP);
        this.checkFamily(QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE);
        this.checkFamily(QueryDataType.OBJECT, QueryDataTypeFamily.OBJECT);
        this.checkFamily(QueryDataType.NULL, QueryDataTypeFamily.NULL);
    }

    private void checkConverter(QueryDataType type, Converter converter) {
        Assert.assertSame((Object)converter, (Object)type.getConverter());
        if (!type.isCustomType()) {
            Assert.assertSame((Object)type, (Object)QueryDataType.resolveForConverter((Converter)converter));
        }
    }

    private void checkClasses(QueryDataType type, Class<?> ... classes) {
        QueryDataTypeTest.assertContains(List.of(classes), (Object)type.getConverter().getValueClass());
        for (Class<?> clazz : classes) {
            Assert.assertSame((Object)type, (Object)QueryDataTypeUtils.resolveTypeForClass(clazz));
        }
    }

    private void checkName(QueryDataType type, String name) {
        Assert.assertEquals((Object)name, (Object)type.toString());
        if (type.isCustomType()) {
            Assertions.assertThatThrownBy(() -> QueryDataType.valueOf((String)name)).hasMessage("No predefined QueryDataType with name " + name);
        } else {
            Assert.assertSame((Object)type, (Object)QueryDataType.valueOf((String)name));
        }
    }

    private void checkSerialization(QueryDataType type) {
        QueryDataType identifiedDataSerialized = QueryDataTypeTest.serde(type);
        Object javaSerialized = ((SupplierEx)QueryDataTypeTest.serde((SupplierEx & Serializable)() -> type)).get();
        for (Object serialized : List.of(identifiedDataSerialized, javaSerialized)) {
            if (type.isCustomType()) {
                Assert.assertEquals((Object)type, (Object)serialized);
                continue;
            }
            Assert.assertSame((Object)type, (Object)serialized);
        }
    }

    private static <T> T serde(T object) {
        return (T)serializationService.toObject((Object)serializationService.toData(object));
    }

    private void checkFamily(QueryDataType expectedType, QueryDataTypeFamily typeFamily) {
        Assert.assertSame((Object)expectedType, (Object)QueryDataTypeUtils.resolveTypeForTypeFamily((QueryDataTypeFamily)typeFamily));
    }
}

