/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.extract;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.CoreSqlTestSupport;
import com.hazelcast.sql.impl.LazyTarget;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTarget;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class GenericQueryTargetTest
extends CoreSqlTestSupport {
    @Test
    public void testTargetDescriptor() {
        GenericQueryTargetTest.serializeAndCheck(new GenericQueryTargetDescriptor(), 85);
    }

    @Test
    public void testTarget() {
        this.checkTarget(GenericQueryTargetTest.createTarget(true));
        this.checkTarget(GenericQueryTargetTest.createTarget(false));
    }

    private void checkTarget(GenericQueryTarget target) {
        TestObject object = new TestObject(1, 2);
        this.checkTarget(target, object, object);
        this.checkTarget(target, object, GenericQueryTargetTest.toData(object));
    }

    private void checkTarget(GenericQueryTarget target, TestObject originalObject, Object object) {
        if (object instanceof Data) {
            target.setTarget(null, (Data)object);
        } else {
            target.setTarget(object, null);
        }
        QueryExtractor targetExtractor = target.createExtractor(null, QueryDataType.OBJECT);
        LazyTarget lazyTarget = (LazyTarget)targetExtractor.get();
        TestObject extractedObject = (TestObject)lazyTarget.deserialize((SerializationService)new DefaultSerializationServiceBuilder().build());
        Assert.assertEquals((long)originalObject.getField(), (long)extractedObject.getField());
        Assert.assertEquals((long)originalObject.getField2(), (long)extractedObject.getField2());
        QueryExtractor badTargetExtractor = target.createExtractor(null, QueryDataType.INT);
        QueryException error = (QueryException)GenericQueryTargetTest.assertThrows(QueryException.class, () -> ((QueryExtractor)badTargetExtractor).get());
        Assert.assertEquals((long)2000L, (long)error.getCode());
        Assert.assertTrue((boolean)error.getMessage().startsWith("Failed to extract map entry " + (target.isKey() ? "key" : "value")));
        QueryExtractor fieldExtractor = target.createExtractor("field", QueryDataType.OBJECT);
        int extractedField = (Integer)fieldExtractor.get();
        Assert.assertEquals((long)originalObject.getField(), (long)extractedField);
        QueryExtractor badFieldTypeExtractor = target.createExtractor("field", QueryDataType.BIGINT);
        error = (QueryException)GenericQueryTargetTest.assertThrows(QueryException.class, () -> ((QueryExtractor)badFieldTypeExtractor).get());
        Assert.assertEquals((long)2000L, (long)error.getCode());
        Assert.assertTrue((boolean)error.getMessage().startsWith("Failed to extract map entry " + (target.isKey() ? "key" : "value") + " field"));
        QueryExtractor badFieldNameExtractor = target.createExtractor("badField", QueryDataType.INT);
        Assert.assertNull((Object)badFieldNameExtractor.get());
    }

    private static Data toData(TestObject object) {
        return new DefaultSerializationServiceBuilder().build().toData((Object)object);
    }

    private static GenericQueryTarget createTarget(boolean key) {
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        Extractors extractors = Extractors.newBuilder((InternalSerializationService)ss).build();
        GenericQueryTargetDescriptor descriptor = new GenericQueryTargetDescriptor();
        GenericQueryTarget target = (GenericQueryTarget)descriptor.create(ss, extractors, key);
        Assert.assertEquals((Object)key, (Object)target.isKey());
        return target;
    }

    private static class TestObject
    implements DataSerializable {
        private int field;
        private int field2;

        private TestObject() {
        }

        private TestObject(int field, int field2) {
            this.field = field;
            this.field2 = field2;
        }

        private int getField() {
            return this.field;
        }

        public int getField2() {
            return this.field2;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.field);
            out.writeInt(this.field2);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.field = in.readInt();
            this.field2 = in.readInt();
        }
    }
}

