/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql;

import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.CoreSqlTestSupport;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlStatementTest
extends CoreSqlTestSupport {
    private static final String SQL = "sql";

    @Test
    public void testDefaults() {
        SqlStatement query = SqlStatementTest.create();
        Assert.assertEquals((Object)SQL, (Object)query.getSql());
        Assert.assertEquals((long)0L, (long)query.getParameters().size());
        Assert.assertEquals((long)-1L, (long)query.getTimeoutMillis());
        Assert.assertEquals((long)4096L, (long)query.getCursorBufferSize());
        Assert.assertNull((Object)query.getSchema());
    }

    @Test(expected=NullPointerException.class)
    public void testSql_null() {
        new SqlStatement(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSql_empty() {
        new SqlStatement("");
    }

    @Test
    public void testParameters() {
        Object param0 = new Object();
        Object param1 = new Object();
        Object param2 = new Object();
        SqlStatement query = SqlStatementTest.create();
        Assert.assertEquals((long)0L, (long)query.getParameters().size());
        query.setParameters(Arrays.asList(param0, param1));
        Assert.assertEquals((long)2L, (long)query.getParameters().size());
        Assert.assertEquals((Object)param0, query.getParameters().get(0));
        Assert.assertEquals((Object)param1, query.getParameters().get(1));
        query.addParameter(param2);
        Assert.assertEquals((long)3L, (long)query.getParameters().size());
        Assert.assertEquals((Object)param0, query.getParameters().get(0));
        Assert.assertEquals((Object)param1, query.getParameters().get(1));
        Assert.assertEquals((Object)param2, query.getParameters().get(2));
        query.clearParameters();
        Assert.assertEquals((long)0L, (long)query.getParameters().size());
        query.addParameter(param0);
        Assert.assertEquals((long)1L, (long)query.getParameters().size());
        Assert.assertEquals((Object)param0, query.getParameters().get(0));
    }

    @Test
    public void testTimeout() {
        SqlStatement query = SqlStatementTest.create().setTimeoutMillis(1L);
        Assert.assertEquals((long)1L, (long)query.getTimeoutMillis());
        query.setTimeoutMillis(0L);
        Assert.assertEquals((long)0L, (long)query.getTimeoutMillis());
        query.setTimeoutMillis(-1L);
        Assert.assertEquals((long)-1L, (long)query.getTimeoutMillis());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTimeout_negative() {
        SqlStatementTest.create().setTimeoutMillis(-2L);
    }

    @Test
    public void testCursorBufferSize() {
        SqlStatement query = SqlStatementTest.create().setCursorBufferSize(1);
        Assert.assertEquals((long)1L, (long)query.getCursorBufferSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCursorBufferSize_zero() {
        SqlStatementTest.create().setCursorBufferSize(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCursorBufferSize_negative() {
        SqlStatementTest.create().setCursorBufferSize(-1);
    }

    @Test
    public void testCopy() {
        SqlStatement original = SqlStatementTest.create();
        original.setSchema("schema");
        SqlStatementTest.checkEquals(original, original.copy(), true);
        original.setParameters(Arrays.asList(1, 2)).setTimeoutMillis(3L).setCursorBufferSize(4);
        SqlStatementTest.checkEquals(original, original.copy(), true);
    }

    @Test
    public void testEquals() {
        SqlStatement query = SqlStatementTest.create();
        SqlStatement another = query.copy();
        SqlStatementTest.checkEquals(query, another, true);
        another = query.copy().setSql("sql1");
        SqlStatementTest.checkEquals(query, another, false);
        another = query.copy().setParameters(Arrays.asList(1, 2, 3));
        SqlStatementTest.checkEquals(query, another, false);
        another = query.copy().setTimeoutMillis(11L);
        SqlStatementTest.checkEquals(query, another, false);
        another = query.copy().setCursorBufferSize(21);
        SqlStatementTest.checkEquals(query, another, false);
        another = query.copy().setSchema("schema");
        SqlStatementTest.checkEquals(query, another, false);
    }

    private static SqlStatement create() {
        return new SqlStatement(SQL);
    }
}

