/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.shape.fractal;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.shape.fractal.MortonCode;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class MortonCodeTest
extends TestCase {
    public MortonCodeTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(MortonCodeTest.class);
    }

    public void testSize() {
        MortonCodeTest.assertEquals((int)MortonCode.size((int)0), (int)1);
        MortonCodeTest.assertEquals((int)MortonCode.size((int)1), (int)4);
        MortonCodeTest.assertEquals((int)MortonCode.size((int)2), (int)16);
        MortonCodeTest.assertEquals((int)MortonCode.size((int)3), (int)64);
        MortonCodeTest.assertEquals((int)MortonCode.size((int)4), (int)256);
        MortonCodeTest.assertEquals((int)MortonCode.size((int)5), (int)1024);
        MortonCodeTest.assertEquals((int)MortonCode.size((int)6), (int)4096);
    }

    public void testLevel() {
        MortonCodeTest.assertEquals((int)MortonCode.level((int)1), (int)0);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)2), (int)1);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)3), (int)1);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)4), (int)1);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)5), (int)2);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)13), (int)2);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)15), (int)2);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)16), (int)2);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)17), (int)3);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)63), (int)3);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)64), (int)3);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)65), (int)4);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)255), (int)4);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)255), (int)4);
        MortonCodeTest.assertEquals((int)MortonCode.level((int)256), (int)4);
    }

    public void testDecode() {
        this.checkDecode(0, 0, 0);
        this.checkDecode(1, 1, 0);
        this.checkDecode(2, 0, 1);
        this.checkDecode(3, 1, 1);
        this.checkDecode(4, 2, 0);
        this.checkDecode(24, 4, 2);
        this.checkDecode(124, 14, 6);
        this.checkDecode(255, 15, 15);
    }

    public void testDecodeEncode() {
        this.checkDecodeEncodeForLevel(4);
        this.checkDecodeEncodeForLevel(5);
    }

    private void checkDecode(int index, int x, int y) {
        Coordinate p = MortonCode.decode((int)index);
        MortonCodeTest.assertEquals((int)((int)p.getX()), (int)x);
        MortonCodeTest.assertEquals((int)((int)p.getY()), (int)y);
    }

    private void checkDecodeEncodeForLevel(int level) {
        int n = MortonCode.size((int)level);
        for (int i = 0; i < n; ++i) {
            this.checkDecodeEncode(level, i);
        }
    }

    private void checkDecodeEncode(int level, int index) {
        Coordinate p = MortonCode.decode((int)index);
        int encode = MortonCode.encode((int)((int)p.getX()), (int)((int)p.getY()));
        MortonCodeTest.assertEquals((int)index, (int)encode);
    }
}

