/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.relate;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.IntersectionMatrix;
import com.hazelcast.shaded.org.locationtech.jts.operation.relate.RelateOp;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class RelateTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(RelateTest.class);
    }

    public RelateTest(String name) {
        super(name);
    }

    public void testContainsIncorrectIMMatrix() {
        String a = "LINESTRING (1 0, 0 2, 0 0, 2 2)";
        String b = "LINESTRING (0 0, 2 2)";
        this.runRelateTest(a, b, "001F001F2");
    }

    public void testIntersectsSnappedEndpoint1() {
        String a = "LINESTRING (-29796.696826656284 138522.76848210802, -29804.3911369969 138519.3504205817)";
        String b = "LINESTRING (-29802.795222153436 138520.05937757515, -29802.23305474065 138518.7938969792)";
        this.runRelateTest(a, b, "F01FF0102");
    }

    public void testIntersectsSnappedEndpoint2() {
        String a = "LINESTRING (-57.2681216 49.4063466, -57.267725199999994 49.406617499999996, -57.26747895046037 49.406750916517765)";
        String b = "LINESTRING (-57.267475399999995 49.4067465, -57.2675701 49.406864299999995, -57.267989 49.407135399999994)";
        this.runRelateTest(a, b, "FF10F0102");
    }

    void runRelateTest(String wkt1, String wkt2, String expectedIM) {
        Geometry g1 = this.read(wkt1);
        Geometry g2 = this.read(wkt2);
        IntersectionMatrix im = RelateOp.relate((Geometry)g1, (Geometry)g2);
        String imStr = im.toString();
        RelateTest.assertTrue((boolean)im.matches(expectedIM));
    }
}

