/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.UnaryUnionNG;
import java.util.Collection;
import java.util.List;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class UnaryUnionNGTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(UnaryUnionNGTest.class);
    }

    public UnaryUnionNGTest(String name) {
        super(name);
    }

    public void testMultiPolygonNarrowGap() {
        this.checkUnaryUnion("MULTIPOLYGON (((1 9, 5.7 9, 5.7 1, 1 1, 1 9)), ((9 9, 9 1, 6 1, 6 9, 9 9)))", 1.0, "POLYGON ((1 9, 6 9, 9 9, 9 1, 6 1, 1 1, 1 9))");
    }

    public void testPolygonsRounded() {
        this.checkUnaryUnion("GEOMETRYCOLLECTION (POLYGON ((1 9, 6 9, 6 1, 1 1, 1 9)), POLYGON ((9 1, 2 8, 9 9, 9 1)))", 1.0, "POLYGON ((1 9, 6 9, 9 9, 9 1, 6 4, 6 1, 1 1, 1 9))");
    }

    public void testPolygonsOverlapping() {
        this.checkUnaryUnion("GEOMETRYCOLLECTION (POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200)), POLYGON ((250 250, 250 150, 150 150, 150 250, 250 250)))", 1.0, "POLYGON ((100 200, 150 200, 150 250, 250 250, 250 150, 200 150, 200 100, 100 100, 100 200))");
    }

    public void testCollection() {
        this.checkUnaryUnion(new String[]{"POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))", "POLYGON ((300 100, 200 100, 200 200, 300 200, 300 100))", "POLYGON ((100 300, 200 300, 200 200, 100 200, 100 300))", "POLYGON ((300 300, 300 200, 200 200, 200 300, 300 300))"}, 1.0, "POLYGON ((100 100, 100 200, 100 300, 200 300, 300 300, 300 200, 300 100, 200 100, 100 100))");
    }

    public void testCollectionEmpty() {
        this.checkUnaryUnion(new String[0], 1.0, "GEOMETRYCOLLECTION EMPTY");
    }

    private void checkUnaryUnion(String wkt, double scaleFactor, String wktExpected) {
        Geometry geom = this.read(wkt);
        Geometry expected = this.read(wktExpected);
        PrecisionModel pm = new PrecisionModel(scaleFactor);
        Geometry result = UnaryUnionNG.union((Geometry)geom, (PrecisionModel)pm);
        this.checkEqual(expected, result);
    }

    private void checkUnaryUnion(String[] wkt, double scaleFactor, String wktExpected) {
        List geoms = this.readList(wkt);
        Geometry expected = this.read(wktExpected);
        PrecisionModel pm = new PrecisionModel(scaleFactor);
        Geometry result = geoms.isEmpty() ? UnaryUnionNG.union((Collection)geoms, (GeometryFactory)this.getGeometryFactory(), (PrecisionModel)pm) : UnaryUnionNG.union((Collection)geoms, (PrecisionModel)pm);
        this.checkEqual(expected, result);
    }
}

