/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.buffer;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryCollection;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiPolygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTWriter;
import com.hazelcast.shaded.org.locationtech.jts.operation.buffer.validate.BufferResultValidator;
import com.hazelcast.shaded.org.locationtech.jts.util.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;

public class BufferValidator {
    private Geometry original;
    private double bufferDistance;
    private Map nameToTestMap = new HashMap();
    private Geometry buffer;
    private static final int QUADRANT_SEGMENTS_1 = 100;
    private static final int QUADRANT_SEGMENTS_2 = 50;
    private String wkt;
    private GeometryFactory geomFact = new GeometryFactory();
    private WKTWriter wktWriter = new WKTWriter();
    private WKTReader wktReader;

    public static void main(String[] args) throws Exception {
        Geometry g = new WKTReader().read("MULTILINESTRING (( 635074.5418406526 6184832.4888257105, 635074.5681951842 6184832.571842485, 635074.6472587794 6184832.575795664 ), ( 635074.6657069515 6184832.53889932, 635074.6933792098 6184832.451929366, 635074.5642420045 6184832.474330718 ))");
    }

    public BufferValidator(double bufferDistance, String wkt) throws ParseException {
        this(bufferDistance, wkt, true);
    }

    public BufferValidator(double bufferDistance, String wkt, boolean addContainsTest) throws ParseException {
        this.setFactory(new PrecisionModel(), 888);
        this.bufferDistance = bufferDistance;
        this.wkt = wkt;
        if (addContainsTest) {
            this.addContainsTest();
        }
    }

    public void test() throws Exception {
        try {
            Collection tests = this.nameToTestMap.values();
            for (Test test : tests) {
                test.test();
            }
        }
        catch (Exception e) {
            throw new Exception(this.supplement(e.toString()) + StringUtil.getStackTrace((Throwable)e));
        }
    }

    private String supplement(String message) throws ParseException {
        String newMessage = "\n" + message + "\n";
        newMessage = newMessage + "Original: " + this.wktWriter.writeFormatted(this.getOriginal()) + "\n";
        newMessage = newMessage + "Buffer Distance: " + this.bufferDistance + "\n";
        newMessage = newMessage + "Buffer: " + this.wktWriter.writeFormatted(this.getBuffer()) + "\n";
        return newMessage.substring(0, newMessage.length() - 1);
    }

    private BufferValidator addTest(Test test) {
        this.nameToTestMap.put(test.getName(), test);
        return this;
    }

    public BufferValidator setExpectedArea(final double expectedArea) {
        return this.addTest(new Test("Area Test"){

            @Override
            public void test() throws Exception {
                double tolerance = Math.abs(BufferValidator.this.getBuffer().getArea() - BufferValidator.this.getOriginal().buffer(BufferValidator.this.bufferDistance, 50).getArea());
                Assert.assertEquals((String)this.getName(), (double)expectedArea, (double)BufferValidator.this.getBuffer().getArea(), (double)tolerance);
            }
        });
    }

    public BufferValidator setEmptyBufferExpected(final boolean emptyBufferExpected) {
        return this.addTest(new Test("Empty Buffer Test", 1){

            @Override
            public void test() throws Exception {
                Assert.assertTrue((String)BufferValidator.this.supplement("Expected buffer " + (emptyBufferExpected ? "" : "not ") + "to be empty"), (emptyBufferExpected == BufferValidator.this.getBuffer().isEmpty() ? 1 : 0) != 0);
            }
        });
    }

    public BufferValidator setBufferHolesExpected(final boolean bufferHolesExpected) {
        return this.addTest(new Test("Buffer Holes Test"){

            @Override
            public void test() throws Exception {
                Assert.assertTrue((String)BufferValidator.this.supplement("Expected buffer " + (bufferHolesExpected ? "" : "not ") + "to have holes"), (this.hasHoles(BufferValidator.this.getBuffer()) == bufferHolesExpected ? 1 : 0) != 0);
            }

            private boolean hasHoles(Geometry buffer) {
                if (buffer.isEmpty()) {
                    return false;
                }
                if (buffer instanceof Polygon) {
                    return ((Polygon)buffer).getNumInteriorRing() > 0;
                }
                MultiPolygon multiPolygon = (MultiPolygon)buffer;
                for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                    if (!this.hasHoles(multiPolygon.getGeometryN(i))) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private Geometry getOriginal() throws ParseException {
        if (this.original == null) {
            this.original = this.wktReader.read(this.wkt);
        }
        return this.original;
    }

    public BufferValidator setPrecisionModel(PrecisionModel precisionModel) {
        this.wktReader = new WKTReader(new GeometryFactory(precisionModel));
        return this;
    }

    public BufferValidator setFactory(PrecisionModel precisionModel, int srid) {
        this.wktReader = new WKTReader(new GeometryFactory(precisionModel, srid));
        return this;
    }

    private Geometry getBuffer() throws ParseException {
        if (this.buffer == null) {
            this.buffer = this.getOriginal().buffer(this.bufferDistance, 100);
            if (this.getBuffer().getClass() == GeometryCollection.class && this.getBuffer().isEmpty()) {
                try {
                    this.buffer = this.wktReader.read("POINT EMPTY");
                }
                catch (ParseException e) {
                    com.hazelcast.shaded.org.locationtech.jts.util.Assert.shouldNeverReachHere();
                }
            }
        }
        return this.buffer;
    }

    private void addContainsTest() {
        this.addTest(new Test("Contains Test"){

            @Override
            public void test() throws Exception {
                if (BufferValidator.this.getOriginal().getClass() == GeometryCollection.class) {
                    return;
                }
                com.hazelcast.shaded.org.locationtech.jts.util.Assert.isTrue((boolean)BufferValidator.this.getOriginal().isValid());
                if (BufferValidator.this.bufferDistance > 0.0) {
                    Assert.assertTrue((String)BufferValidator.this.supplement("Expected buffer to contain original"), (boolean)this.contains(BufferValidator.this.getBuffer(), BufferValidator.this.getOriginal()));
                } else {
                    Assert.assertTrue((String)BufferValidator.this.supplement("Expected original to contain buffer"), (boolean)this.contains(BufferValidator.this.getOriginal(), BufferValidator.this.getBuffer()));
                }
            }

            private boolean contains(Geometry a, Geometry b) {
                if (b.isEmpty()) {
                    return true;
                }
                boolean isContained = a.contains(b);
                return isContained;
            }
        });
    }

    private void addBufferResultValidatorTest() {
        this.addTest(new Test("BufferResultValidator Test"){

            @Override
            public void test() throws Exception {
                if (BufferValidator.this.getOriginal().getClass() == GeometryCollection.class) {
                    return;
                }
                Assert.assertTrue((String)BufferValidator.this.supplement("BufferResultValidator failure"), (boolean)BufferResultValidator.isValid((Geometry)BufferValidator.this.getOriginal(), (double)BufferValidator.this.bufferDistance, (Geometry)BufferValidator.this.getBuffer()));
            }
        });
    }

    private static abstract class Test
    implements Comparable {
        private String name;
        private int priority;

        public Test(String name) {
            this(name, 2);
        }

        public Test(String name, int priority) {
            this.name = name;
            this.priority = priority;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public abstract void test() throws Exception;

        public int compareTo(Object o) {
            return this.priority - ((Test)o).priority;
        }
    }
}

