/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.linearref;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.Lineal;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiLineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.linearref.LengthLocationMap;
import com.hazelcast.shaded.org.locationtech.jts.linearref.LinearLocation;
import com.hazelcast.shaded.org.locationtech.jts.linearref.LocationIndexOfPoint;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class LengthLocationMapTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(LengthLocationMapTest.class);
    }

    public LengthLocationMapTest(String name) {
        super(name);
    }

    public void testLengthAtPosition30() {
        this.checkLlm("LINESTRING (0 0, 0 100)", "POINT (0 30)", 30.0);
    }

    public void testLengthAtPosition50() {
        this.checkLlm("LINESTRING (0 0, 0 100)", "POINT (0 50)", 50.0);
    }

    public void testLengthAtPosition60() {
        this.checkLlm("LINESTRING (0 0, 0 100)", "POINT (0 60)", 60.0);
    }

    public void testLengthAtPosition100() {
        this.checkLlm("LINESTRING (0 0, 0 100)", "POINT (0 100)", 100.0);
    }

    public void testLengthAtPosition101() {
        this.checkLlm("LINESTRING (0 0, 0 100)", "POINT (0 101)", 100.0);
    }

    public void testLengthAtPosition0() {
        this.checkLlm("LINESTRING (0 0, 0 100)", "POINT (0 0)", 0.0);
    }

    public void testLengthAtPositionMinus1() {
        this.checkLlm("LINESTRING (0 0, 0 100)", "POINT (0 -1)", 0.0);
    }

    public void testMultiLineLengthPosition30() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 50, 0 100))", "POINT (0 30)", 30.0);
    }

    public void testMultiLineLengthPosition50() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 50, 0 100))", "POINT (0 50)", 50.0);
    }

    public void testMultiLineLengthPosition60() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 50, 0 100))", "POINT (0 60)", 60.0);
    }

    public void testMultiLineLengthAtPosition100() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 50, 0 100))", "POINT (0 100)", 100.0);
    }

    public void testMultiLineLengthAtPosition101() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 50, 0 100))", "POINT (0 101)", 100.0);
    }

    public void testMultiLineLengthAtPosition0() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 50, 0 100))", "POINT (0 0)", 0.0);
    }

    public void testMultiLineLengthAtPositionMinus1() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 50, 0 100))", "POINT (0 -1)", 0.0);
    }

    public void testMultiLineHoleLengthPosition30() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 51, 0 100))", "POINT (0 30)", 30.0);
    }

    public void testMultiLineHoleLengthPosition50() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 51, 0 100))", "POINT (0 50)", 50.0);
    }

    public void testMultiLineHoleLengthPosition60() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 51, 0 100))", "POINT (0 60)", 59.0);
    }

    public void testMultiLineHoleLengthAtPosition100() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 51, 0 100))", "POINT (0 100)", 99.0);
    }

    public void testMultiLineHoleLengthAtPosition101() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 51, 0 100))", "POINT (0 101)", 99.0);
    }

    public void testMultiLineHoleLengthAtPosition0() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 51, 0 100))", "POINT (0 0)", 0.0);
    }

    public void testMultiLineHoleLengthAtPosition60() {
        this.checkLlm("MULTILINESTRING((0 0, 0 30), (0 31, 0 60), (0 61, 0 100))", "POINT (0 60)", 59.0);
    }

    public void testMultiLineHoleLengthAtPositionMinus1() {
        this.checkLlm("MULTILINESTRING((0 0, 0 50), (0 51, 0 100))", "POINT (0 -1)", 0.0);
    }

    private void checkLlm(String wkt0, String wkt1, double expectedDistance) {
        Lineal line = (Lineal)this.read(wkt0);
        Point point = (Point)this.read(wkt1);
        if (line instanceof LineString) {
            this.checkLlm((LineString)line, point, expectedDistance);
        } else {
            this.checkLlm((MultiLineString)line, point, expectedDistance);
        }
    }

    private void checkLlm(LineString geom0, Point geom1, double expectedDistance) {
        LinearLocation loc = LocationIndexOfPoint.indexOf((Geometry)geom0, (Coordinate)geom1.getCoordinate());
        LengthLocationMapTest.assertEquals((Object)expectedDistance, (Object)LengthLocationMap.getLength((Geometry)geom0, (LinearLocation)loc));
    }

    private void checkLlm(MultiLineString geom0, Point geom1, double expectedDistance) {
        LinearLocation loc = LocationIndexOfPoint.indexOf((Geometry)geom0, (Coordinate)geom1.getCoordinate());
        LengthLocationMapTest.assertEquals((Object)expectedDistance, (Object)LengthLocationMap.getLength((Geometry)geom0, (LinearLocation)loc));
    }
}

