/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.io.gml2;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.gml2.GMLReader;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import junit.textui.TestRunner;
import org.xml.sax.SAXException;
import test.jts.GeometryTestCase;

public class GMLReaderTest
extends GeometryTestCase {
    private static final int DEFAULT_SRID = 9876;
    private static final GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), 9876);

    public static void main(String[] args) {
        TestRunner.run(GMLReaderTest.class);
    }

    public GMLReaderTest(String name) {
        super(name);
    }

    public void testPoint() {
        this.checkRead("<gml:Point>    <gml:coordinates>45.67,88.56</gml:coordinates> </gml:Point>", "POINT (45.67 88.56)");
    }

    public void testPointNoNamespace() {
        this.checkRead("<Point>    <coordinates>45.67,88.56</coordinates> </Point>", "POINT (45.67 88.56)");
    }

    public void testPointWithCoordSepSpace() {
        this.checkRead("<gml:Point>    <gml:coordinates>45.67, 88.56</gml:coordinates> </gml:Point>", "POINT (45.67 88.56)");
    }

    public void testPointWithCoordSepMultiSpaceAfter() {
        this.checkRead("<gml:Point>    <gml:coordinates>45.67,     88.56</gml:coordinates> </gml:Point>", "POINT (45.67 88.56)");
    }

    public void testPointWithCoordSepMultiSpaceBefore() {
        this.checkRead("<gml:Point>    <gml:coordinates>45.67   ,88.56</gml:coordinates> </gml:Point>", "POINT (45.67 88.56)");
    }

    public void testPointWithCoordSepMultiSpaceBoth() {
        this.checkRead("<gml:Point>    <gml:coordinates>45.67   ,   88.56</gml:coordinates> </gml:Point>", "POINT (45.67 88.56)");
    }

    public void testPointSRIDInt() {
        this.checkRead("<gml:Point srsName='1234'>    <gml:coordinates>45.67,     88.56</gml:coordinates> </gml:Point>", "POINT (45.67 88.56)", 1234);
    }

    public void testPointSRIDHash() {
        this.checkRead("<gml:Point srsName='some.prefix#4326'>    <gml:coordinates>45.67,     88.56</gml:coordinates> </gml:Point>", "POINT (45.67 88.56)", 4326);
    }

    public void testPointSRIDSlash() {
        this.checkRead("<gml:Point srsName='http://www.opengis.net/def/crs/EPSG/0/4326'>    <gml:coordinates>45.67,     88.56</gml:coordinates> </gml:Point>", "POINT (45.67 88.56)", 4326);
    }

    public void testPointSRIDColon() {
        this.checkRead("<gml:Point srsName='urn:ogc:def:crs:EPSG::4326'>    <gml:coordinates>45.67,     88.56</gml:coordinates> </gml:Point>", "POINT (45.67 88.56)", 4326);
    }

    public void testLineStringWithCoordSepSpace() {
        this.checkRead("<gml:LineString>    <gml:coordinates>45.67, 88.56 55.56,89.44</gml:coordinates> </gml:LineString >", "LINESTRING (45.67 88.56, 55.56 89.44)");
    }

    public void testLineStringWithManySpaces() {
        this.checkRead("<gml:LineString>    <gml:coordinates>45.67,   88.56    55.56,89.44</gml:coordinates> </gml:LineString >", "LINESTRING (45.67 88.56, 55.56 89.44)");
    }

    private void checkRead(String gml, String wktExpected) {
        this.checkRead(gml, wktExpected, 9876);
    }

    private void checkRead(String gml, String wktExpected, int srid) {
        GMLReader gr = new GMLReader();
        Geometry g = null;
        try {
            g = gr.read(gml, geometryFactory);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            GMLReaderTest.fail((String)e.getMessage());
        }
        Geometry expected = this.read(wktExpected);
        this.checkEqual(expected, g);
        GMLReaderTest.assertEquals((String)"SRID incorrect - ", (int)srid, (int)g.getSRID());
    }
}

