/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.io;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateXY;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.io.Ordinate;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTWriter;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class WKTWriterStaticFnTest
extends GeometryTestCase {
    private Random _rnd;
    private WKTReader _reader;

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(WKTWriterStaticFnTest.class));
    }

    public WKTWriterStaticFnTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._rnd = new Random(13L);
        this._reader = new WKTReader();
        this._reader.setIsOldJtsCoordinateSyntaxAllowed(false);
    }

    public void testStaticToPoint() throws ParseException {
        for (int i = 0; i < 1000; ++i) {
            Coordinate cs = new Coordinate(100.0 * this._rnd.nextDouble(), 100.0 * this._rnd.nextDouble());
            String toPointText = WKTWriter.toPoint((Coordinate)cs);
            Coordinate cd = this._reader.read(toPointText).getCoordinate();
            WKTWriterStaticFnTest.assertEquals((Object)cs, (Object)cd);
        }
    }

    public void testStaticToLineStringFromSequence() throws ParseException {
        for (int i = 0; i < 1000; ++i) {
            int size = 2 + this._rnd.nextInt(10);
            CoordinateSequence cs = WKTWriterStaticFnTest.getCSFactory(Ordinate.createXY()).create(size, 2, 0);
            for (int j = 0; j < cs.size(); ++j) {
                cs.setOrdinate(j, 0, 100.0 * this._rnd.nextDouble());
                cs.setOrdinate(j, 1, 100.0 * this._rnd.nextDouble());
            }
            String toLineStringText = WKTWriter.toLineString((CoordinateSequence)cs);
            CoordinateSequence cd = ((LineString)this._reader.read(toLineStringText)).getCoordinateSequence();
            WKTWriterStaticFnTest.assertEquals((int)cs.size(), (int)cd.size());
            for (int j = 0; j < cs.size(); ++j) {
                WKTWriterStaticFnTest.assertEquals((Object)cs.getCoordinate(j), (Object)cd.getCoordinate(j));
            }
        }
    }

    public void testStaticToLineStringFromCoordinateArray() throws ParseException {
        for (int i = 0; i < 1000; ++i) {
            int size = 2 + this._rnd.nextInt(10);
            Coordinate[] cs = new Coordinate[size];
            for (int j = 0; j < cs.length; ++j) {
                cs[j] = new CoordinateXY(100.0 * this._rnd.nextDouble(), 100.0 * this._rnd.nextDouble());
            }
            String toLineStringText = WKTWriter.toLineString((Coordinate[])cs);
            Coordinate[] cd = this._reader.read(toLineStringText).getCoordinates();
            for (int j = 0; j < cs.length; ++j) {
                WKTWriterStaticFnTest.assertEquals((Object)cs[j], (Object)cd[j]);
            }
        }
    }

    public void testStaticToLineStringFromTwoCoords() throws ParseException {
        for (int i = 0; i < 1000; ++i) {
            Coordinate[] cs = new Coordinate[]{new CoordinateXY(100.0 * this._rnd.nextDouble(), 100.0 * this._rnd.nextDouble()), new CoordinateXY(100.0 * this._rnd.nextDouble(), 100.0 * this._rnd.nextDouble())};
            String toLineStringText = WKTWriter.toLineString((Coordinate)cs[0], (Coordinate)cs[1]);
            Coordinate[] cd = this._reader.read(toLineStringText).getCoordinates();
            WKTWriterStaticFnTest.assertEquals((int)2, (int)cd.length);
            WKTWriterStaticFnTest.assertEquals((Object)cs[0], (Object)cd[0]);
            WKTWriterStaticFnTest.assertEquals((Object)cs[1], (Object)cd[1]);
        }
    }

    public void testPointNoSciNot() {
        Coordinate coord = new Coordinate(1.23456789E8, 9.87654321E8);
        String wkt = WKTWriter.toPoint((Coordinate)coord);
        WKTWriterStaticFnTest.assertEquals((String)"POINT ( 123456789 987654321 )", (String)wkt);
    }

    public void testLineStringNoSciNot() {
        Coordinate coord = new Coordinate(1.23456789E8, 9.87654321E8);
        Coordinate coord2 = new Coordinate(1.0E8, 9.0E8);
        String wkt = WKTWriter.toLineString((Coordinate)coord, (Coordinate)coord2);
        WKTWriterStaticFnTest.assertEquals((String)"LINESTRING ( 123456789 987654321, 100000000 900000000 )", (String)wkt);
    }
}

