/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.io;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryCollection;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiLineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiPoint;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiPolygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.Ordinate;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import java.util.EnumSet;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class WKTReaderTest
extends GeometryTestCase {
    private final WKTReader readerXY;
    private final WKTReader readerXYOld;
    private final WKTReader readerXYZ;
    private final WKTReader readerXYM;
    private final WKTReader readerXYZM;
    private WKTReader readerXYZCloseRings;
    static double[][] mpCoords = new double[][]{{10.0, 10.0}, {20.0, 20.0}};
    double[][] mLcoords = new double[][]{{10.0, 10.0, 20.0, 20.0}, {15.0, 15.0, 30.0, 15.0}};
    double[][] mAcoords = new double[][]{{10.0, 10.0, 10.0, 20.0, 20.0, 20.0, 20.0, 15.0, 10.0, 10.0}, {11.0, 11.0, 12.0, 11.0, 12.0, 12.0, 12.0, 11.0, 11.0, 11.0}, {60.0, 60.0, 70.0, 70.0, 80.0, 60.0, 60.0, 60.0}};

    public static void main(String[] args) {
        TestRunner.run((Test)WKTReaderTest.suite());
    }

    public WKTReaderTest(String name) {
        super(name);
        this.readerXY = WKTReaderTest.getWKTReader((EnumSet<Ordinate>)Ordinate.createXY(), 1.0);
        this.readerXY.setIsOldJtsCoordinateSyntaxAllowed(false);
        this.readerXYOld = WKTReaderTest.getWKTReader((EnumSet<Ordinate>)Ordinate.createXY(), 1.0);
        this.readerXYOld.setIsOldJtsCoordinateSyntaxAllowed(true);
        this.readerXYZ = WKTReaderTest.getWKTReader((EnumSet<Ordinate>)Ordinate.createXYZ(), 1.0);
        this.readerXYM = WKTReaderTest.getWKTReader((EnumSet<Ordinate>)Ordinate.createXYM(), 1.0);
        this.readerXYZM = WKTReaderTest.getWKTReader((EnumSet<Ordinate>)Ordinate.createXYZM(), 1.0);
        this.readerXYZCloseRings = WKTReaderTest.getWKTReader((EnumSet<Ordinate>)Ordinate.createXYZM(), 1.0);
        this.readerXYZCloseRings.setFixStructure(true);
    }

    public static Test suite() {
        return new TestSuite(WKTReaderTest.class);
    }

    public void testPoint() throws Exception {
        double[] coordinates = new double[]{10.0, 10.0};
        CoordinateSequence seqPt2D = WKTReaderTest.createSequence(Ordinate.createXY(), coordinates);
        CoordinateSequence seqPt2DE = WKTReaderTest.createSequence(Ordinate.createXY(), new double[0]);
        CoordinateSequence seqPt3D = WKTReaderTest.createSequence(Ordinate.createXYZ(), coordinates);
        CoordinateSequence seqPt2DM = WKTReaderTest.createSequence(Ordinate.createXYM(), coordinates);
        CoordinateSequence seqPt3DM = WKTReaderTest.createSequence(Ordinate.createXYZM(), coordinates);
        Point pt2D = (Point)this.readerXY.read("POINT (10 10)");
        Point pt2DE = (Point)this.readerXY.read("POINT EMPTY");
        Point pt3D = (Point)this.readerXYZ.read("POINT Z(10 10 10)");
        Point pt2DM = (Point)this.readerXYM.read("POINT M(10 10 11)");
        Point pt2DM2 = (Point)new WKTReader().read("POINT M(10 10 11)");
        Point pt3DM = (Point)this.readerXYZM.read("POINT ZM(10 10 10 11)");
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqPt2D, pt2D.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqPt2DE, pt2DE.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqPt3D, pt3D.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)pt2DM.getCoordinateSequence().hasM());
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqPt2DM, pt2DM.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)pt2DM2.getCoordinateSequence().hasM());
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqPt2DM, pt2DM2.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqPt3DM, pt3DM.getCoordinateSequence()));
    }

    public void testLineString() throws Exception {
        double[] coordinates = new double[]{10.0, 10.0, 20.0, 20.0, 30.0, 40.0};
        CoordinateSequence seqLs2D = WKTReaderTest.createSequence(Ordinate.createXY(), coordinates);
        CoordinateSequence seqLs2DE = WKTReaderTest.createSequence(Ordinate.createXY(), new double[0]);
        CoordinateSequence seqLs3D = WKTReaderTest.createSequence(Ordinate.createXYZ(), coordinates);
        CoordinateSequence seqLs2DM = WKTReaderTest.createSequence(Ordinate.createXYM(), coordinates);
        CoordinateSequence seqLs3DM = WKTReaderTest.createSequence(Ordinate.createXYZM(), coordinates);
        LineString ls2D = (LineString)this.readerXY.read("LINESTRING (10 10, 20 20, 30 40)");
        LineString ls2DE = (LineString)this.readerXY.read("LINESTRING EMPTY");
        LineString ls3D = (LineString)this.readerXYZ.read("LINESTRING Z(10 10 10, 20 20 10, 30 40 10)");
        LineString ls2DM = (LineString)this.readerXYM.read("LINESTRING M(10 10 11, 20 20 11, 30 40 11)");
        LineString ls3DM = (LineString)this.readerXYZM.read("LINESTRING ZM(10 10 10 11, 20 20 10 11, 30 40 10 11)");
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqLs2D, ls2D.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqLs2DE, ls2DE.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqLs3D, ls3D.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqLs2DM, ls2DM.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqLs3DM, ls3DM.getCoordinateSequence()));
    }

    public void testLinearRing() throws Exception {
        double[] coordinates = new double[]{10.0, 10.0, 20.0, 20.0, 30.0, 40.0, 10.0, 10.0};
        CoordinateSequence seqLs2D = WKTReaderTest.createSequence(Ordinate.createXY(), coordinates);
        CoordinateSequence seqLs2DE = WKTReaderTest.createSequence(Ordinate.createXY(), new double[0]);
        CoordinateSequence seqLs3D = WKTReaderTest.createSequence(Ordinate.createXYZ(), coordinates);
        CoordinateSequence seqLs2DM = WKTReaderTest.createSequence(Ordinate.createXYM(), coordinates);
        CoordinateSequence seqLs3DM = WKTReaderTest.createSequence(Ordinate.createXYZM(), coordinates);
        LineString ls2D = (LineString)this.readerXY.read("LINEARRING (10 10, 20 20, 30 40, 10 10)");
        LineString ls2DE = (LineString)this.readerXY.read("LINEARRING EMPTY");
        LineString ls3D = (LineString)this.readerXYZ.read("LINEARRING Z(10 10 10, 20 20 10, 30 40 10, 10 10 10)");
        LineString ls2DM = (LineString)this.readerXYM.read("LINEARRING M(10 10 11, 20 20 11, 30 40 11, 10 10 11)");
        LineString ls3DM = (LineString)this.readerXYZM.read("LINEARRING ZM(10 10 10 11, 20 20 10 11, 30 40 10 11, 10 10 10 11)");
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqLs2D, ls2D.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqLs2DE, ls2DE.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqLs3D, ls3D.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqLs2DM, ls2DM.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seqLs3DM, ls3DM.getCoordinateSequence()));
    }

    public void testLinearRingNotClosed() {
        try {
            this.readerXY.read("LINEARRING (10 10, 20 20, 30 40, 10 99)");
            WKTReaderTest.fail();
        }
        catch (Throwable e) {
            WKTReaderTest.assertTrue((boolean)(e instanceof IllegalArgumentException));
            WKTReaderTest.assertTrue((boolean)e.getMessage().contains("not form a closed linestring"));
        }
    }

    public void testPolygon() throws Exception {
        double[] shell = new double[]{10.0, 10.0, 10.0, 20.0, 20.0, 20.0, 20.0, 15.0, 10.0, 10.0};
        double[] ring1 = new double[]{11.0, 11.0, 12.0, 11.0, 12.0, 12.0, 12.0, 11.0, 11.0, 11.0};
        double[] ring2 = new double[]{11.0, 19.0, 11.0, 18.0, 12.0, 18.0, 12.0, 19.0, 11.0, 19.0};
        CoordinateSequence[] csPoly2D = new CoordinateSequence[]{WKTReaderTest.createSequence(Ordinate.createXY(), shell), WKTReaderTest.createSequence(Ordinate.createXY(), ring1), WKTReaderTest.createSequence(Ordinate.createXY(), ring2)};
        CoordinateSequence csPoly2DE = WKTReaderTest.createSequence(Ordinate.createXY(), new double[0]);
        CoordinateSequence[] csPoly3D = new CoordinateSequence[]{WKTReaderTest.createSequence(Ordinate.createXYZ(), shell), WKTReaderTest.createSequence(Ordinate.createXYZ(), ring1), WKTReaderTest.createSequence(Ordinate.createXYZ(), ring2)};
        CoordinateSequence[] csPoly2DM = new CoordinateSequence[]{WKTReaderTest.createSequence(Ordinate.createXYM(), shell), WKTReaderTest.createSequence(Ordinate.createXYM(), ring1), WKTReaderTest.createSequence(Ordinate.createXYM(), ring2)};
        CoordinateSequence[] csPoly3DM = new CoordinateSequence[]{WKTReaderTest.createSequence(Ordinate.createXYZM(), shell), WKTReaderTest.createSequence(Ordinate.createXYZM(), ring1), WKTReaderTest.createSequence(Ordinate.createXYZM(), ring2)};
        WKTReader rdr = this.readerXY;
        Polygon[] poly2D = new Polygon[]{(Polygon)rdr.read("POLYGON ((10 10, 10 20, 20 20, 20 15, 10 10))"), (Polygon)rdr.read("POLYGON ((10 10, 10 20, 20 20, 20 15, 10 10), (11 11, 12 11, 12 12, 12 11, 11 11))"), (Polygon)rdr.read("POLYGON ((10 10, 10 20, 20 20, 20 15, 10 10), (11 11, 12 11, 12 12, 12 11, 11 11), (11 19, 11 18, 12 18, 12 19, 11 19))")};
        Polygon poly2DE = (Polygon)rdr.read("POLYGON EMPTY");
        rdr = this.readerXYZ;
        Polygon[] poly3D = new Polygon[]{(Polygon)rdr.read("POLYGON Z((10 10 10, 10 20 10, 20 20 10, 20 15 10, 10 10 10))"), (Polygon)rdr.read("POLYGON Z((10 10 10, 10 20 10, 20 20 10, 20 15 10, 10 10 10), (11 11 10, 12 11 10, 12 12 10, 12 11 10, 11 11 10))"), (Polygon)rdr.read("POLYGON Z((10 10 10, 10 20 10, 20 20 10, 20 15 10, 10 10 10), (11 11 10, 12 11 10, 12 12 10, 12 11 10, 11 11 10), (11 19 10, 11 18 10, 12 18 10, 12 19 10, 11 19 10))")};
        rdr = this.readerXYM;
        Polygon[] poly2DM = new Polygon[]{(Polygon)rdr.read("POLYGON M((10 10 11, 10 20 11, 20 20 11, 20 15 11, 10 10 11))"), (Polygon)rdr.read("POLYGON M((10 10 11, 10 20 11, 20 20 11, 20 15 11, 10 10 11), (11 11 11, 12 11 11, 12 12 11, 12 11 11, 11 11 11))"), (Polygon)rdr.read("POLYGON M((10 10 11, 10 20 11, 20 20 11, 20 15 11, 10 10 11), (11 11 11, 12 11 11, 12 12 11, 12 11 11, 11 11 11), (11 19 11, 11 18 11, 12 18 11, 12 19 11, 11 19 11))")};
        rdr = this.readerXYZM;
        Polygon[] poly3DM = new Polygon[]{(Polygon)rdr.read("POLYGON ZM((10 10 10 11, 10 20 10 11, 20 20 10 11, 20 15 10 11, 10 10 10 11))"), (Polygon)rdr.read("POLYGON ZM((10 10 10 11, 10 20 10 11, 20 20 10 11, 20 15 10 11, 10 10 10 11), (11 11 10 11, 12 11 10 11, 12 12 10 11, 12 11 10 11, 11 11 10 11))"), (Polygon)rdr.read("POLYGON ZM((10 10 10 11, 10 20 10 11, 20 20 10 11, 20 15 10 11, 10 10 10 11), (11 11 10 11, 12 11 10 11, 12 12 10 11, 12 11 10 11, 11 11 10 11), (11 19 10 11, 11 18 10 11, 12 18 10 11, 12 19 10 11, 11 19 10 11))")};
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(csPoly2D[0], poly2D[2].getExteriorRing().getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(csPoly2D[1], poly2D[2].getInteriorRingN(0).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(csPoly2D[2], poly2D[2].getInteriorRingN(1).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqualDim(csPoly2DE, poly2DE.getExteriorRing().getCoordinateSequence(), 2));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(csPoly3D[0], poly3D[2].getExteriorRing().getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(csPoly3D[1], poly3D[2].getInteriorRingN(0).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(csPoly3D[2], poly3D[2].getInteriorRingN(1).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(csPoly2DM[0], poly2DM[2].getExteriorRing().getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(csPoly2DM[1], poly2DM[2].getInteriorRingN(0).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(csPoly2DM[2], poly2DM[2].getInteriorRingN(1).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(csPoly3DM[0], poly3DM[2].getExteriorRing().getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(csPoly3DM[1], poly3DM[2].getInteriorRingN(0).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(csPoly3DM[2], poly3DM[2].getInteriorRingN(1).getCoordinateSequence()));
    }

    public void testMultiPointXY() throws Exception {
        MultiPoint mp = (MultiPoint)this.readerXY.read("MULTIPOINT ((10 10), (20 20))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXY(), mpCoords);
        this.checkCS(cs[0], mp.getGeometryN(0));
        this.checkCS(cs[1], mp.getGeometryN(1));
    }

    public void testMultiPointXYOldSyntax() throws Exception {
        MultiPoint mp = (MultiPoint)this.readerXY.read("MULTIPOINT (10 10, 20 20)");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXY(), mpCoords);
        this.checkCS(cs[0], mp.getGeometryN(0));
        this.checkCS(cs[1], mp.getGeometryN(1));
    }

    public void testMultiPointXY_Empty() throws Exception {
        MultiPoint mp = (MultiPoint)this.readerXY.read("MULTIPOINT EMPTY");
        this.checkEmpty((Geometry)mp);
    }

    public void testMultiPointXY_WithEmpty() throws Exception {
        MultiPoint mp = (MultiPoint)this.readerXY.read("MULTIPOINT ((10 10), EMPTY, (20 20))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXY(), mpCoords);
        this.checkCS(cs[0], mp.getGeometryN(0));
        this.checkEmpty(mp.getGeometryN(1));
        this.checkCS(cs[1], mp.getGeometryN(2));
    }

    public void testMultiPointXYM() throws Exception {
        MultiPoint mp = (MultiPoint)this.readerXYM.read("MULTIPOINT M((10 10 11), (20 20 11))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXYM(), mpCoords);
        this.checkCS(cs[0], mp.getGeometryN(0));
        this.checkCS(cs[1], mp.getGeometryN(1));
    }

    public void testMultiPointXYZ() throws Exception {
        MultiPoint mp = (MultiPoint)this.readerXYZ.read("MULTIPOINT Z((10 10 10), (20 20 10))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXYZ(), mpCoords);
        this.checkCS(cs[0], mp.getGeometryN(0));
        this.checkCS(cs[1], mp.getGeometryN(1));
    }

    public void testMultiPointXYZM() throws Exception {
        MultiPoint mp = (MultiPoint)this.readerXYZM.read("MULTIPOINT ZM((10 10 10 11), (20 20 10 11))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXYZM(), mpCoords);
        this.checkCS(cs[0], mp.getGeometryN(0));
        this.checkCS(cs[1], mp.getGeometryN(1));
    }

    public void testMultiLineStringXY() throws Exception {
        MultiLineString mp = (MultiLineString)this.readerXY.read("MULTILINESTRING ((10 10, 20 20), (15 15, 30 15))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXY(), this.mLcoords);
        this.checkCS(cs[0], mp.getGeometryN(0));
        this.checkCS(cs[1], mp.getGeometryN(1));
    }

    public void testMultiLineStringXY_Empty() throws Exception {
        MultiLineString mp = (MultiLineString)this.readerXY.read("MULTILINESTRING EMPTY");
        this.checkEmpty((Geometry)mp);
    }

    public void testMultiLineStringXY_WithEmpty() throws Exception {
        MultiLineString mp = (MultiLineString)this.readerXY.read("MULTILINESTRING ((10 10, 20 20), EMPTY, (15 15, 30 15))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXY(), this.mLcoords);
        this.checkCS(cs[0], mp.getGeometryN(0));
        this.checkEmpty(mp.getGeometryN(1));
        this.checkCS(cs[1], mp.getGeometryN(2));
    }

    public void testMultiLineStringXYM() throws Exception {
        MultiLineString mp = (MultiLineString)this.readerXYM.read("MULTILINESTRING M((10 10 11, 20 20 11), (15 15 11, 30 15 11))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXYM(), this.mLcoords);
        this.checkCS(cs[0], mp.getGeometryN(0));
        this.checkCS(cs[1], mp.getGeometryN(1));
    }

    public void testMultiLineStringXYZ() throws Exception {
        MultiLineString mp = (MultiLineString)this.readerXYZ.read("MULTILINESTRING Z((10 10 10, 20 20 10), (15 15 10, 30 15 10))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXYZ(), this.mLcoords);
        this.checkCS(cs[0], mp.getGeometryN(0));
        this.checkCS(cs[1], mp.getGeometryN(1));
    }

    public void testMultiLineStringYZM() throws Exception {
        MultiLineString mp = (MultiLineString)this.readerXYZM.read("MULTILINESTRING ZM((10 10 10 11, 20 20 10 11), (15 15 10 11, 30 15 10 11))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXYZM(), this.mLcoords);
        this.checkCS(cs[0], mp.getGeometryN(0));
        this.checkCS(cs[1], mp.getGeometryN(1));
    }

    public void testMultiPolygonXY() throws Exception {
        MultiPolygon mp = (MultiPolygon)this.readerXY.read("MULTIPOLYGON (((10 10, 10 20, 20 20, 20 15, 10 10), (11 11, 12 11, 12 12, 12 11, 11 11)), ((60 60, 70 70, 80 60, 60 60)))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXY(), this.mAcoords);
        this.checkCS(cs[0], (Geometry)((Polygon)mp.getGeometryN(0)).getExteriorRing());
        this.checkCS(cs[1], (Geometry)((Polygon)mp.getGeometryN(0)).getInteriorRingN(0));
        this.checkCS(cs[2], (Geometry)((Polygon)mp.getGeometryN(1)).getExteriorRing());
    }

    public void testMultiPolygonXY_Empty() throws Exception {
        MultiPolygon mp = (MultiPolygon)this.readerXY.read("MULTIPOLYGON EMPTY");
        this.checkEmpty((Geometry)mp);
    }

    public void testMultiPolygonXY_WithEmpty() throws Exception {
        MultiPolygon mp = (MultiPolygon)this.readerXY.read("MULTIPOLYGON (((10 10, 10 20, 20 20, 20 15, 10 10), (11 11, 12 11, 12 12, 12 11, 11 11)), EMPTY, ((60 60, 70 70, 80 60, 60 60)))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXY(), this.mAcoords);
        this.checkCS(cs[0], (Geometry)((Polygon)mp.getGeometryN(0)).getExteriorRing());
        this.checkCS(cs[1], (Geometry)((Polygon)mp.getGeometryN(0)).getInteriorRingN(0));
        this.checkEmpty((Geometry)((Polygon)mp.getGeometryN(1)));
        this.checkCS(cs[2], (Geometry)((Polygon)mp.getGeometryN(2)).getExteriorRing());
    }

    public void testMultiPolygonXYM() throws Exception {
        MultiPolygon mp = (MultiPolygon)this.readerXYM.read("MULTIPOLYGON M(((10 10 11, 10 20 11, 20 20 11, 20 15 11, 10 10 11), (11 11 11, 12 11 11, 12 12 11, 12 11 11, 11 11 11)), ((60 60 11, 70 70 11, 80 60 11, 60 60 11)))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXYM(), this.mAcoords);
        this.checkCS(cs[0], (Geometry)((Polygon)mp.getGeometryN(0)).getExteriorRing());
        this.checkCS(cs[1], (Geometry)((Polygon)mp.getGeometryN(0)).getInteriorRingN(0));
        this.checkCS(cs[2], (Geometry)((Polygon)mp.getGeometryN(1)).getExteriorRing());
    }

    public void testMultiPolygonXYZ() throws Exception {
        MultiPolygon mp = (MultiPolygon)this.readerXYZ.read("MULTIPOLYGON Z(((10 10 10, 10 20 10, 20 20 10, 20 15 10, 10 10 10), (11 11 10, 12 11 10, 12 12 10, 12 11 10, 11 11 10)), ((60 60 10, 70 70 10, 80 60 10, 60 60 10)))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXYZ(), this.mAcoords);
        this.checkCS(cs[0], (Geometry)((Polygon)mp.getGeometryN(0)).getExteriorRing());
        this.checkCS(cs[1], (Geometry)((Polygon)mp.getGeometryN(0)).getInteriorRingN(0));
        this.checkCS(cs[2], (Geometry)((Polygon)mp.getGeometryN(1)).getExteriorRing());
    }

    public void testMultiPolygonYZM() throws Exception {
        MultiPolygon mp = (MultiPolygon)this.readerXYZM.read("MULTIPOLYGON ZM(((10 10 10 11, 10 20 10 11, 20 20 10 11, 20 15 10 11, 10 10 10 11), (11 11 10 11, 12 11 10 11, 12 12 10 11, 12 11 10 11, 11 11 10 11)), ((60 60 10 11, 70 70 10 11, 80 60 10 11, 60 60 10 11)))");
        CoordinateSequence[] cs = WKTReaderTest.createSequences(Ordinate.createXYZM(), this.mAcoords);
        this.checkCS(cs[0], (Geometry)((Polygon)mp.getGeometryN(0)).getExteriorRing());
        this.checkCS(cs[1], (Geometry)((Polygon)mp.getGeometryN(0)).getInteriorRingN(0));
        this.checkCS(cs[2], (Geometry)((Polygon)mp.getGeometryN(1)).getExteriorRing());
    }

    public void testGeometryCollection() throws Exception {
        double[][] coordinates = new double[][]{{10.0, 10.0}, {30.0, 30.0}, {15.0, 15.0, 20.0, 20.0}, new double[0], {10.0, 10.0, 20.0, 20.0, 30.0, 40.0, 10.0, 10.0}};
        CoordinateSequence[] css = new CoordinateSequence[]{WKTReaderTest.createSequence(Ordinate.createXY(), coordinates[0]), WKTReaderTest.createSequence(Ordinate.createXY(), coordinates[1]), WKTReaderTest.createSequence(Ordinate.createXY(), coordinates[2]), WKTReaderTest.createSequence(Ordinate.createXY(), coordinates[3]), WKTReaderTest.createSequence(Ordinate.createXY(), coordinates[4])};
        WKTReader rdr = WKTReaderTest.getWKTReader((EnumSet<Ordinate>)Ordinate.createXY(), 1.0);
        GeometryCollection gc0 = (GeometryCollection)rdr.read("GEOMETRYCOLLECTION (POINT (10 10), POINT (30 30), LINESTRING (15 15, 20 20))");
        GeometryCollection gc1 = (GeometryCollection)rdr.read("GEOMETRYCOLLECTION (POINT (10 10), LINEARRING EMPTY, LINESTRING (15 15, 20 20))");
        GeometryCollection gc2 = (GeometryCollection)rdr.read("GEOMETRYCOLLECTION (POINT (10 10), LINEARRING (10 10, 20 20, 30 40, 10 10), LINESTRING (15 15, 20 20))");
        GeometryCollection gc3 = (GeometryCollection)rdr.read("GEOMETRYCOLLECTION EMPTY");
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(css[0], ((Point)gc0.getGeometryN(0)).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(css[1], ((Point)gc0.getGeometryN(1)).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(css[2], ((LineString)gc0.getGeometryN(2)).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(css[0], ((Point)gc1.getGeometryN(0)).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(css[3], ((LinearRing)gc1.getGeometryN(1)).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(css[2], ((LineString)gc1.getGeometryN(2)).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(css[0], ((Point)gc2.getGeometryN(0)).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(css[4], ((LinearRing)gc2.getGeometryN(1)).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(css[2], ((LineString)gc2.getGeometryN(2)).getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)gc3.isEmpty());
    }

    public void testEmptyLineDimOldSyntax() throws ParseException {
        WKTReader wktReader = new WKTReader();
        LineString geom = (LineString)wktReader.read("LINESTRING EMPTY");
        int dim = geom.getCoordinateSequence().getDimension();
        this.checkCSDim(geom.getCoordinateSequence(), 3);
    }

    public void testEmptyLineDim() throws ParseException {
        WKTReader wktReader = new WKTReader();
        wktReader.setIsOldJtsCoordinateSyntaxAllowed(false);
        LineString geom = (LineString)wktReader.read("LINESTRING EMPTY");
        this.checkCSDim(geom.getCoordinateSequence(), 2);
    }

    public void testEmptyPolygonDim() throws ParseException {
        WKTReader wktReader = new WKTReader();
        wktReader.setIsOldJtsCoordinateSyntaxAllowed(false);
        Polygon geom = (Polygon)wktReader.read("POLYGON EMPTY");
        this.checkCSDim(geom.getExteriorRing().getCoordinateSequence(), 2);
    }

    public void testNaN() throws Exception {
        CoordinateSequence seq = WKTReaderTest.createSequence(Ordinate.createXYZ(), new double[]{10.0, 10.0});
        seq.setOrdinate(0, 2, Double.NaN);
        Point pt1 = (Point)this.readerXYOld.read("POINT (10 10 NaN)");
        Point pt2 = (Point)this.readerXYOld.read("POINT (10 10 nan)");
        Point pt3 = (Point)this.readerXYOld.read("POINT (10 10 NAN)");
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seq, pt1.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seq, pt2.getCoordinateSequence()));
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(seq, pt3.getCoordinateSequence()));
    }

    public void testLargeNumbers() throws Exception {
        PrecisionModel precisionModel = new PrecisionModel(1.0E9);
        GeometryFactory geometryFactory = new GeometryFactory(precisionModel, 0);
        WKTReader reader = new WKTReader(geometryFactory);
        CoordinateSequence point1 = ((Point)reader.read("POINT (123456789.01234567890 10)")).getCoordinateSequence();
        CoordinateSequence point2 = geometryFactory.createPoint(new Coordinate(1.2345678901234567E8, 10.0)).getCoordinateSequence();
        WKTReaderTest.assertEquals((double)point1.getOrdinate(0, 0), (double)point2.getOrdinate(0, 0), (double)1.0E-7);
        WKTReaderTest.assertEquals((double)point1.getOrdinate(0, 1), (double)point2.getOrdinate(0, 1), (double)1.0E-7);
    }

    public void testTurkishLocale() throws Exception {
        Locale original = Locale.getDefault();
        try {
            Locale.setDefault(Locale.forLanguageTag("tr"));
            Point point = (Point)this.readerXY.read("point (10 20)");
            WKTReaderTest.assertEquals((double)10.0, (double)point.getX(), (double)1.0E-7);
            WKTReaderTest.assertEquals((double)20.0, (double)point.getY(), (double)1.0E-7);
        }
        finally {
            Locale.setDefault(original);
        }
    }

    private void checkCS(CoordinateSequence cs, Geometry geom) {
        WKTReaderTest.assertTrue((boolean)WKTReaderTest.isEqual(cs, this.extractCS(geom)));
    }

    private CoordinateSequence extractCS(Geometry geom) {
        if (geom instanceof Point) {
            return ((Point)geom).getCoordinateSequence();
        }
        if (geom instanceof LineString) {
            return ((LineString)geom).getCoordinateSequence();
        }
        throw new IllegalArgumentException("Can't extract coordinate sequence from geometry of type " + geom.getGeometryType());
    }

    private void checkEmpty(Geometry geom) {
        WKTReaderTest.assertTrue((boolean)geom.isEmpty());
        if (geom instanceof GeometryCollection) {
            WKTReaderTest.assertTrue((geom.getNumGeometries() == 0 ? 1 : 0) != 0);
        }
    }

    private void checkCSDim(CoordinateSequence cs, int expectedCoordDim) {
        int dim = cs.getDimension();
        WKTReaderTest.assertEquals((int)expectedCoordDim, (int)dim);
    }

    private static CoordinateSequence[] createSequences(EnumSet<Ordinate> ordinateFlags, double[][] xyarray) {
        CoordinateSequence[] csarray = new CoordinateSequence[xyarray.length];
        for (int i = 0; i < xyarray.length; ++i) {
            csarray[i] = WKTReaderTest.createSequence(ordinateFlags, xyarray[i]);
        }
        return csarray;
    }

    private static CoordinateSequence createSequence(EnumSet<Ordinate> ordinateFlags, double[] xy) {
        int dimension = WKTReaderTest.requiredDimension(ordinateFlags);
        double[] ordinateValues = WKTReaderTest.injectZM(ordinateFlags, xy);
        if (ordinateValues.length % dimension != 0) {
            throw new IllegalArgumentException("ordinateFlags and number of provided ordinate values don't match");
        }
        int size = ordinateValues.length / dimension;
        CoordinateSequence res = WKTReaderTest.getCSFactory(ordinateFlags).create(size, WKTReaderTest.requiredDimension(ordinateFlags));
        int k = 0;
        for (int i = 0; i < ordinateValues.length; i += dimension) {
            for (int j = 0; j < dimension; ++j) {
                res.setOrdinate(k, j, ordinateValues[i + j]);
            }
            ++k;
        }
        return res;
    }

    private static int requiredDimension(EnumSet<Ordinate> ordinateFlags) {
        return ordinateFlags.size();
    }

    private static double[] injectZM(EnumSet<Ordinate> ordinateFlags, double[] xy) {
        int size = xy.length / 2;
        int dimension = WKTReaderTest.requiredDimension(ordinateFlags);
        double[] res = new double[size * dimension];
        int k = 0;
        for (int i = 0; i < xy.length; i += 2) {
            res[k++] = xy[i];
            res[k++] = xy[i + 1];
            if (ordinateFlags.contains(Ordinate.Z)) {
                res[k++] = 10.0;
            }
            if (!ordinateFlags.contains(Ordinate.M)) continue;
            res[k++] = 11.0;
        }
        return res;
    }
}

