/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.index.strtree;

import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.EnvelopeDistance;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class EnvelopeDistanceTest
extends TestCase {
    public EnvelopeDistanceTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{EnvelopeDistanceTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public void testDisjoint() {
        this.checkEnvelopeDistance(new Envelope(0.0, 10.0, 0.0, 10.0), new Envelope(20.0, 30.0, 20.0, 40.0), 50.0);
    }

    public void testOverlapping() {
        this.checkEnvelopeDistance(new Envelope(0.0, 30.0, 0.0, 30.0), new Envelope(20.0, 30.0, 20.0, 40.0), 50.0);
    }

    public void testCrossing() {
        this.checkEnvelopeDistance(new Envelope(0.0, 40.0, 10.0, 20.0), new Envelope(20.0, 30.0, 0.0, 30.0), 50.0);
    }

    public void testCrossing2() {
        this.checkEnvelopeDistance(new Envelope(0.0, 10.0, 4.0, 6.0), new Envelope(4.0, 6.0, 0.0, 10.0), 14.142135623730951);
    }

    private void checkEnvelopeDistance(Envelope env1, Envelope env2, double expected) {
        double result = EnvelopeDistance.maximumDistance((Envelope)env1, (Envelope)env2);
        EnvelopeDistanceTest.assertEquals((Object)expected, (Object)result);
    }
}

