/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.index.quadtree;

import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.index.quadtree.EnvelopeList;
import com.hazelcast.shaded.org.locationtech.jts.index.quadtree.Quadtree;
import com.hazelcast.shaded.org.locationtech.jts.util.Stopwatch;
import java.util.ArrayList;
import java.util.List;

public class QuadtreeCorrectTest {
    static final int NUM_ITEMS = 2000;
    static final double MIN_EXTENT = -1000.0;
    static final double MAX_EXTENT = 1000.0;
    EnvelopeList envList = new EnvelopeList();
    Quadtree q = new Quadtree();

    public static void main(String[] args) throws Exception {
        QuadtreeCorrectTest test = new QuadtreeCorrectTest();
        test.run();
    }

    public void run() {
        this.fill();
        System.out.println("depth = " + this.q.depth() + "  size = " + this.q.size());
        this.runQueries();
    }

    void fill() {
        this.createGrid(2000);
    }

    void createGrid(int nGridCells) {
        int gridSize = (int)Math.sqrt(nGridCells);
        double extent = 2000.0;
        double gridInc = extent / (double)(++gridSize);
        double cellSize = 2.0 * gridInc;
        for (int i = 0; i < gridSize; ++i) {
            for (int j = 0; j < gridSize; ++j) {
                double x = -1000.0 + gridInc * (double)i;
                double y = -1000.0 + gridInc * (double)j;
                Envelope env = new Envelope(x, x + cellSize, y, y + cellSize);
                this.q.insert(env, (Object)env);
                this.envList.add(env);
            }
        }
    }

    void runQueries() {
        int nGridCells = 100;
        int cellSize = (int)Math.sqrt(2000.0);
        double extent = 2000.0;
        double queryCellSize = 2.0 * extent / (double)cellSize;
        this.queryGrid(nGridCells, queryCellSize);
    }

    void queryGrid(int nGridCells, double cellSize) {
        Stopwatch sw = new Stopwatch();
        sw.start();
        int gridSize = (int)Math.sqrt(nGridCells);
        double extent = 2000.0;
        double gridInc = extent / (double)(++gridSize);
        for (int i = 0; i < gridSize; ++i) {
            for (int j = 0; j < gridSize; ++j) {
                double x = -1000.0 + gridInc * (double)i;
                double y = -1000.0 + gridInc * (double)j;
                Envelope env = new Envelope(x, x + cellSize, y, y + cellSize);
                this.queryTest(env);
            }
        }
        System.out.println("Time = " + sw.getTimeString());
    }

    void queryTime(Envelope env) {
        List<Envelope> eList = this.envList.query(env);
    }

    void queryTest(Envelope env) {
        List candidateList = this.q.query(env);
        List finalList = this.getOverlapping(candidateList, env);
        List<Envelope> eList = this.envList.query(env);
        if (finalList.size() != eList.size()) {
            throw new RuntimeException("queries do not match");
        }
    }

    private List getOverlapping(List items, Envelope searchEnv) {
        ArrayList<Envelope> result = new ArrayList<Envelope>();
        for (int i = 0; i < items.size(); ++i) {
            Envelope env = (Envelope)items.get(i);
            if (!env.intersects(searchEnv)) continue;
            result.add(env);
        }
        return result;
    }
}

