/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom.impl;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequenceFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateXY;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateXYM;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateXYZM;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.impl.CoordinateSequenceTestBase;
import com.hazelcast.shaded.org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import junit.textui.TestRunner;

public class PackedCoordinateSequenceTest
extends CoordinateSequenceTestBase {
    public static void main(String[] args) {
        TestRunner.run(PackedCoordinateSequenceTest.class);
    }

    public PackedCoordinateSequenceTest(String name) {
        super(name);
    }

    @Override
    CoordinateSequenceFactory getCSFactory() {
        return new PackedCoordinateSequenceFactory();
    }

    public void testDouble() {
        this.checkAll((CoordinateSequenceFactory)PackedCoordinateSequenceFactory.DOUBLE_FACTORY);
    }

    public void testFloat() {
        this.checkAll((CoordinateSequenceFactory)PackedCoordinateSequenceFactory.FLOAT_FACTORY);
    }

    public void checkAll(CoordinateSequenceFactory factory) {
        this.checkDim2(1, factory);
        this.checkDim2(5, factory);
        this.checkDim3(factory);
        this.checkDim3_M1(factory);
        this.checkDim4_M1(factory);
        this.checkDim4(factory);
        this.checkDimInvalid(factory);
    }

    public void checkDim2(int size, CoordinateSequenceFactory factory) {
        CoordinateSequence seq = factory.create(size, 2);
        this.initProgression(seq);
        PackedCoordinateSequenceTest.assertEquals((String)"Dimension should be 2", (int)2, (int)seq.getDimension());
        PackedCoordinateSequenceTest.assertTrue((String)"Z should not be present", (!seq.hasZ() ? 1 : 0) != 0);
        PackedCoordinateSequenceTest.assertTrue((String)"M should not be present", (!seq.hasM() ? 1 : 0) != 0);
        int indexLast = size - 1;
        double valLast = indexLast;
        Coordinate coord = seq.getCoordinate(indexLast);
        PackedCoordinateSequenceTest.assertTrue((boolean)(coord instanceof CoordinateXY));
        PackedCoordinateSequenceTest.assertEquals((Object)valLast, (Object)coord.getX());
        PackedCoordinateSequenceTest.assertEquals((Object)valLast, (Object)coord.getY());
        Coordinate[] array = seq.toCoordinateArray();
        PackedCoordinateSequenceTest.assertEquals((Object)coord, (Object)array[indexLast]);
        PackedCoordinateSequenceTest.assertTrue((coord != array[indexLast] ? 1 : 0) != 0);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(seq, array));
        CoordinateSequence copy = factory.create(array);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(copy, array));
        CoordinateSequence copy2 = factory.create(seq);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(copy2, array));
    }

    public void checkDim3(CoordinateSequenceFactory factory) {
        CoordinateSequence seq = factory.create(5, 3);
        this.initProgression(seq);
        PackedCoordinateSequenceTest.assertEquals((String)"Dimension should be 3", (int)3, (int)seq.getDimension());
        PackedCoordinateSequenceTest.assertTrue((String)"Z should be present", (boolean)seq.hasZ());
        PackedCoordinateSequenceTest.assertTrue((String)"M should not be present", (!seq.hasM() ? 1 : 0) != 0);
        Coordinate coord = seq.getCoordinate(4);
        PackedCoordinateSequenceTest.assertTrue((coord.getClass() == Coordinate.class ? 1 : 0) != 0);
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getX());
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getY());
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getZ());
        Coordinate[] array = seq.toCoordinateArray();
        PackedCoordinateSequenceTest.assertEquals((Object)coord, (Object)array[4]);
        PackedCoordinateSequenceTest.assertTrue((coord != array[4] ? 1 : 0) != 0);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(seq, array));
        CoordinateSequence copy = factory.create(array);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(copy, array));
        CoordinateSequence copy2 = factory.create(seq);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(copy2, array));
    }

    public void checkDim3_M1(CoordinateSequenceFactory factory) {
        CoordinateSequence seq = factory.create(5, 3, 1);
        this.initProgression(seq);
        PackedCoordinateSequenceTest.assertEquals((String)"Dimension should be 3", (int)3, (int)seq.getDimension());
        PackedCoordinateSequenceTest.assertTrue((String)"Z should not be present", (!seq.hasZ() ? 1 : 0) != 0);
        PackedCoordinateSequenceTest.assertTrue((String)"M should be present", (boolean)seq.hasM());
        Coordinate coord = seq.getCoordinate(4);
        PackedCoordinateSequenceTest.assertTrue((boolean)(coord instanceof CoordinateXYM));
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getX());
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getY());
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getM());
        Coordinate[] array = seq.toCoordinateArray();
        PackedCoordinateSequenceTest.assertEquals((Object)coord, (Object)array[4]);
        PackedCoordinateSequenceTest.assertTrue((coord != array[4] ? 1 : 0) != 0);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(seq, array));
        CoordinateSequence copy = factory.create(array);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(copy, array));
        CoordinateSequence copy2 = factory.create(seq);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(copy2, array));
    }

    public void checkDim4_M1(CoordinateSequenceFactory factory) {
        CoordinateSequence seq = factory.create(5, 4, 1);
        this.initProgression(seq);
        PackedCoordinateSequenceTest.assertEquals((String)"Dimension should be 4", (int)4, (int)seq.getDimension());
        PackedCoordinateSequenceTest.assertTrue((String)"Z should be present", (boolean)seq.hasZ());
        PackedCoordinateSequenceTest.assertTrue((String)"M should be present", (boolean)seq.hasM());
        Coordinate coord = seq.getCoordinate(4);
        PackedCoordinateSequenceTest.assertTrue((boolean)(coord instanceof CoordinateXYZM));
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getX());
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getY());
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getZ());
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getM());
        Coordinate[] array = seq.toCoordinateArray();
        PackedCoordinateSequenceTest.assertEquals((Object)coord, (Object)array[4]);
        PackedCoordinateSequenceTest.assertTrue((coord != array[4] ? 1 : 0) != 0);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(seq, array));
        CoordinateSequence copy = factory.create(array);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(copy, array));
        CoordinateSequence copy2 = factory.create(seq);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(copy2, array));
    }

    public void checkDim4(CoordinateSequenceFactory factory) {
        CoordinateSequence seq = factory.create(5, 4);
        this.initProgression(seq);
        PackedCoordinateSequenceTest.assertEquals((String)"Dimension should be 4", (int)4, (int)seq.getDimension());
        PackedCoordinateSequenceTest.assertTrue((String)"Z should be present", (boolean)seq.hasZ());
        PackedCoordinateSequenceTest.assertTrue((String)"M should be present", (boolean)seq.hasM());
        Coordinate coord = seq.getCoordinate(4);
        PackedCoordinateSequenceTest.assertTrue((boolean)(coord instanceof CoordinateXYZM));
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getX());
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getY());
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getZ());
        PackedCoordinateSequenceTest.assertEquals((Object)4.0, (Object)coord.getM());
        Coordinate[] array = seq.toCoordinateArray();
        PackedCoordinateSequenceTest.assertEquals((Object)coord, (Object)array[4]);
        PackedCoordinateSequenceTest.assertTrue((coord != array[4] ? 1 : 0) != 0);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(seq, array));
        CoordinateSequence copy = factory.create(array);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(copy, array));
        CoordinateSequence copy2 = factory.create(seq);
        PackedCoordinateSequenceTest.assertTrue((boolean)this.isEqual(copy2, array));
    }

    public void XtestMixedFactoryWithXY() {
        GeometryFactory factoryPacked = new GeometryFactory((CoordinateSequenceFactory)new PackedCoordinateSequenceFactory());
        Polygon polygonPacked = factoryPacked.createPolygon(new Coordinate[]{new CoordinateXY(0.0, 0.0), new CoordinateXY(10.0, 0.0), new CoordinateXY(10.0, 10.0), new CoordinateXY(0.0, 10.0), new CoordinateXY(0.0, 0.0)});
        GeometryFactory factoryDefault = new GeometryFactory();
        Polygon polygonArray = factoryDefault.createPolygon(new Coordinate[]{new CoordinateXY(5.0, 5.0), new CoordinateXY(15.0, 5.0), new CoordinateXY(15.0, 15.0), new CoordinateXY(5.0, 15.0), new CoordinateXY(5.0, 5.0)});
        polygonArray.intersection((Geometry)polygonPacked);
        polygonPacked.intersection((Geometry)polygonArray);
    }

    public void checkDimInvalid(CoordinateSequenceFactory factory) {
        try {
            CoordinateSequence seq = factory.create(5, 2, 1);
            PackedCoordinateSequenceTest.fail((String)"Dimension=2/Measure=1 (XM) not supported");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void initProgression(CoordinateSequence seq) {
        for (int index = 0; index < seq.size(); ++index) {
            for (int ordinateIndex = 0; ordinateIndex < seq.getDimension(); ++ordinateIndex) {
                seq.setOrdinate(index, ordinateIndex, (double)index);
            }
        }
    }
}

