/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryCollection;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryCollectionIterator;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class GeometryCollectionIteratorTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(GeometryCollectionIteratorTest.class);
    }

    public GeometryCollectionIteratorTest(String name) {
        super(name);
    }

    public void testGeometryCollection() throws Exception {
        GeometryCollection g = (GeometryCollection)this.read("GEOMETRYCOLLECTION (GEOMETRYCOLLECTION (POINT (10 10)))");
        GeometryCollectionIterator i = new GeometryCollectionIterator((Geometry)g);
        GeometryCollectionIteratorTest.assertTrue((boolean)i.hasNext());
        GeometryCollectionIteratorTest.assertTrue((boolean)(i.next() instanceof GeometryCollection));
        GeometryCollectionIteratorTest.assertTrue((boolean)i.hasNext());
        GeometryCollectionIteratorTest.assertTrue((boolean)(i.next() instanceof GeometryCollection));
        GeometryCollectionIteratorTest.assertTrue((boolean)i.hasNext());
        GeometryCollectionIteratorTest.assertTrue((boolean)(i.next() instanceof Point));
        GeometryCollectionIteratorTest.assertTrue((!i.hasNext() ? 1 : 0) != 0);
    }

    public void testAtomic() throws Exception {
        Polygon g = (Polygon)this.read("POLYGON ((1 9, 9 9, 9 1, 1 1, 1 9))");
        GeometryCollectionIterator i = new GeometryCollectionIterator((Geometry)g);
        GeometryCollectionIteratorTest.assertTrue((boolean)i.hasNext());
        GeometryCollectionIteratorTest.assertTrue((boolean)(i.next() instanceof Polygon));
        GeometryCollectionIteratorTest.assertTrue((!i.hasNext() ? 1 : 0) != 0);
    }
}

