/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class EnvelopeTest
extends TestCase {
    private PrecisionModel precisionModel = new PrecisionModel(1.0);
    private GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);

    public EnvelopeTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(EnvelopeTest.class);
    }

    public void testEverything() throws Exception {
        Envelope e1 = new Envelope();
        EnvelopeTest.assertTrue((boolean)e1.isNull());
        EnvelopeTest.assertEquals((double)0.0, (double)e1.getWidth(), (double)0.001);
        EnvelopeTest.assertEquals((double)0.0, (double)e1.getHeight(), (double)0.001);
        e1.expandToInclude(100.0, 101.0);
        e1.expandToInclude(200.0, 202.0);
        e1.expandToInclude(150.0, 151.0);
        EnvelopeTest.assertEquals((double)200.0, (double)e1.getMaxX(), (double)0.001);
        EnvelopeTest.assertEquals((double)202.0, (double)e1.getMaxY(), (double)0.001);
        EnvelopeTest.assertEquals((double)100.0, (double)e1.getMinX(), (double)0.001);
        EnvelopeTest.assertEquals((double)101.0, (double)e1.getMinY(), (double)0.001);
        EnvelopeTest.assertTrue((boolean)e1.contains(120.0, 120.0));
        EnvelopeTest.assertTrue((boolean)e1.contains(120.0, 101.0));
        EnvelopeTest.assertTrue((!e1.contains(120.0, 100.0) ? 1 : 0) != 0);
        EnvelopeTest.assertEquals((double)101.0, (double)e1.getHeight(), (double)0.001);
        EnvelopeTest.assertEquals((double)100.0, (double)e1.getWidth(), (double)0.001);
        EnvelopeTest.assertTrue((!e1.isNull() ? 1 : 0) != 0);
        Envelope e2 = new Envelope(499.0, 500.0, 500.0, 501.0);
        EnvelopeTest.assertTrue((!e1.contains(e2) ? 1 : 0) != 0);
        EnvelopeTest.assertTrue((!e1.intersects(e2) ? 1 : 0) != 0);
        e1.expandToInclude(e2);
        EnvelopeTest.assertTrue((boolean)e1.contains(e2));
        EnvelopeTest.assertTrue((boolean)e1.intersects(e2));
        EnvelopeTest.assertEquals((double)500.0, (double)e1.getMaxX(), (double)0.001);
        EnvelopeTest.assertEquals((double)501.0, (double)e1.getMaxY(), (double)0.001);
        EnvelopeTest.assertEquals((double)100.0, (double)e1.getMinX(), (double)0.001);
        EnvelopeTest.assertEquals((double)101.0, (double)e1.getMinY(), (double)0.001);
        Envelope e3 = new Envelope(300.0, 700.0, 300.0, 700.0);
        EnvelopeTest.assertTrue((!e1.contains(e3) ? 1 : 0) != 0);
        EnvelopeTest.assertTrue((boolean)e1.intersects(e3));
        Envelope e4 = new Envelope(300.0, 301.0, 300.0, 301.0);
        EnvelopeTest.assertTrue((boolean)e1.contains(e4));
        EnvelopeTest.assertTrue((boolean)e1.intersects(e4));
    }

    public void testIntersects() {
        this.checkIntersectsPermuted(1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, true);
        this.checkIntersectsPermuted(1.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, false);
    }

    public void testIntersectsEmpty() {
        EnvelopeTest.assertTrue((!new Envelope(-5.0, 5.0, -5.0, 5.0).intersects(new Envelope()) ? 1 : 0) != 0);
        EnvelopeTest.assertTrue((!new Envelope().intersects(new Envelope(-5.0, 5.0, -5.0, 5.0)) ? 1 : 0) != 0);
        EnvelopeTest.assertTrue((!new Envelope().intersects(new Envelope(100.0, 101.0, 100.0, 101.0)) ? 1 : 0) != 0);
        EnvelopeTest.assertTrue((!new Envelope(100.0, 101.0, 100.0, 101.0).intersects(new Envelope()) ? 1 : 0) != 0);
    }

    public void testDisjointEmpty() {
        EnvelopeTest.assertTrue((boolean)new Envelope(-5.0, 5.0, -5.0, 5.0).disjoint(new Envelope()));
        EnvelopeTest.assertTrue((boolean)new Envelope().disjoint(new Envelope(-5.0, 5.0, -5.0, 5.0)));
        EnvelopeTest.assertTrue((boolean)new Envelope().disjoint(new Envelope(100.0, 101.0, 100.0, 101.0)));
        EnvelopeTest.assertTrue((boolean)new Envelope(100.0, 101.0, 100.0, 101.0).disjoint(new Envelope()));
    }

    public void testContainsEmpty() {
        EnvelopeTest.assertTrue((!new Envelope(-5.0, 5.0, -5.0, 5.0).contains(new Envelope()) ? 1 : 0) != 0);
        EnvelopeTest.assertTrue((!new Envelope().contains(new Envelope(-5.0, 5.0, -5.0, 5.0)) ? 1 : 0) != 0);
        EnvelopeTest.assertTrue((!new Envelope().contains(new Envelope(100.0, 101.0, 100.0, 101.0)) ? 1 : 0) != 0);
        EnvelopeTest.assertTrue((!new Envelope(100.0, 101.0, 100.0, 101.0).contains(new Envelope()) ? 1 : 0) != 0);
    }

    public void testExpandToIncludeEmpty() {
        EnvelopeTest.assertEquals((Object)new Envelope(-5.0, 5.0, -5.0, 5.0), (Object)this.expandToInclude(new Envelope(-5.0, 5.0, -5.0, 5.0), new Envelope()));
        EnvelopeTest.assertEquals((Object)new Envelope(-5.0, 5.0, -5.0, 5.0), (Object)this.expandToInclude(new Envelope(), new Envelope(-5.0, 5.0, -5.0, 5.0)));
        EnvelopeTest.assertEquals((Object)new Envelope(100.0, 101.0, 100.0, 101.0), (Object)this.expandToInclude(new Envelope(), new Envelope(100.0, 101.0, 100.0, 101.0)));
        EnvelopeTest.assertEquals((Object)new Envelope(100.0, 101.0, 100.0, 101.0), (Object)this.expandToInclude(new Envelope(100.0, 101.0, 100.0, 101.0), new Envelope()));
    }

    private Envelope expandToInclude(Envelope a, Envelope b) {
        a.expandToInclude(b);
        return a;
    }

    public void testEmpty() {
        EnvelopeTest.assertEquals((double)0.0, (double)new Envelope().getHeight(), (double)0.0);
        EnvelopeTest.assertEquals((double)0.0, (double)new Envelope().getWidth(), (double)0.0);
        EnvelopeTest.assertEquals((Object)new Envelope(), (Object)new Envelope());
        Envelope e = new Envelope(100.0, 101.0, 100.0, 101.0);
        e.init(new Envelope());
        EnvelopeTest.assertEquals((Object)new Envelope(), (Object)e);
    }

    public void testAsGeometry() throws Exception {
        EnvelopeTest.assertTrue((boolean)this.geometryFactory.createPoint((Coordinate)null).getEnvelope().isEmpty());
        Geometry g = this.geometryFactory.createPoint(new Coordinate(5.0, 6.0)).getEnvelope();
        EnvelopeTest.assertTrue((!g.isEmpty() ? 1 : 0) != 0);
        EnvelopeTest.assertTrue((boolean)(g instanceof Point));
        Point p = (Point)g;
        EnvelopeTest.assertEquals((double)5.0, (double)p.getX(), (double)0.1);
        EnvelopeTest.assertEquals((double)6.0, (double)p.getY(), (double)0.1);
        LineString l = (LineString)this.reader.read("LINESTRING(10 10, 20 20, 30 40)");
        Geometry g2 = l.getEnvelope();
        EnvelopeTest.assertTrue((!g2.isEmpty() ? 1 : 0) != 0);
        EnvelopeTest.assertTrue((boolean)(g2 instanceof Polygon));
        Polygon poly = (Polygon)g2;
        poly.normalize();
        EnvelopeTest.assertEquals((int)5, (int)poly.getExteriorRing().getNumPoints());
        EnvelopeTest.assertEquals((Object)new Coordinate(10.0, 10.0), (Object)poly.getExteriorRing().getCoordinateN(0));
        EnvelopeTest.assertEquals((Object)new Coordinate(10.0, 40.0), (Object)poly.getExteriorRing().getCoordinateN(1));
        EnvelopeTest.assertEquals((Object)new Coordinate(30.0, 40.0), (Object)poly.getExteriorRing().getCoordinateN(2));
        EnvelopeTest.assertEquals((Object)new Coordinate(30.0, 10.0), (Object)poly.getExteriorRing().getCoordinateN(3));
        EnvelopeTest.assertEquals((Object)new Coordinate(10.0, 10.0), (Object)poly.getExteriorRing().getCoordinateN(4));
    }

    public void testSetToNull() throws Exception {
        Envelope e1 = new Envelope();
        EnvelopeTest.assertTrue((boolean)e1.isNull());
        e1.expandToInclude(5.0, 5.0);
        EnvelopeTest.assertTrue((!e1.isNull() ? 1 : 0) != 0);
        e1.setToNull();
        EnvelopeTest.assertTrue((boolean)e1.isNull());
    }

    public void testEquals() throws Exception {
        Envelope e1 = new Envelope(1.0, 2.0, 3.0, 4.0);
        Envelope e2 = new Envelope(1.0, 2.0, 3.0, 4.0);
        EnvelopeTest.assertEquals((Object)e1, (Object)e2);
        EnvelopeTest.assertEquals((int)e1.hashCode(), (int)e2.hashCode());
        Envelope e3 = new Envelope(1.0, 2.0, 3.0, 5.0);
        EnvelopeTest.assertTrue((!e1.equals((Object)e3) ? 1 : 0) != 0);
        EnvelopeTest.assertTrue((e1.hashCode() != e3.hashCode() ? 1 : 0) != 0);
        e1.setToNull();
        EnvelopeTest.assertTrue((!e1.equals((Object)e2) ? 1 : 0) != 0);
        EnvelopeTest.assertTrue((e1.hashCode() != e2.hashCode() ? 1 : 0) != 0);
        e2.setToNull();
        EnvelopeTest.assertEquals((Object)e1, (Object)e2);
        EnvelopeTest.assertEquals((int)e1.hashCode(), (int)e2.hashCode());
    }

    public void testEquals2() {
        EnvelopeTest.assertTrue((boolean)new Envelope().equals((Object)new Envelope()));
        EnvelopeTest.assertTrue((boolean)new Envelope(1.0, 2.0, 1.0, 2.0).equals((Object)new Envelope(1.0, 2.0, 1.0, 2.0)));
        EnvelopeTest.assertTrue((!new Envelope(1.0, 2.0, 1.5, 2.0).equals((Object)new Envelope(1.0, 2.0, 1.0, 2.0)) ? 1 : 0) != 0);
    }

    public void testCopyConstructor() throws Exception {
        Envelope e1 = new Envelope(1.0, 2.0, 3.0, 4.0);
        Envelope e2 = new Envelope(e1);
        EnvelopeTest.assertEquals((double)1.0, (double)e2.getMinX(), (double)1.0E-5);
        EnvelopeTest.assertEquals((double)2.0, (double)e2.getMaxX(), (double)1.0E-5);
        EnvelopeTest.assertEquals((double)3.0, (double)e2.getMinY(), (double)1.0E-5);
        EnvelopeTest.assertEquals((double)4.0, (double)e2.getMaxY(), (double)1.0E-5);
    }

    public void testCopy() throws Exception {
        Envelope e1 = new Envelope(1.0, 2.0, 3.0, 4.0);
        Envelope e2 = e1.copy();
        EnvelopeTest.assertEquals((double)1.0, (double)e2.getMinX(), (double)1.0E-5);
        EnvelopeTest.assertEquals((double)2.0, (double)e2.getMaxX(), (double)1.0E-5);
        EnvelopeTest.assertEquals((double)3.0, (double)e2.getMinY(), (double)1.0E-5);
        EnvelopeTest.assertEquals((double)4.0, (double)e2.getMaxY(), (double)1.0E-5);
        Envelope eNull = new Envelope();
        Envelope eNullCopy = eNull.copy();
        EnvelopeTest.assertTrue((boolean)eNullCopy.isNull());
    }

    public void testGeometryFactoryCreateEnvelope() throws Exception {
        this.checkExpectedEnvelopeGeometry("POINT (0 0)");
        this.checkExpectedEnvelopeGeometry("POINT (100 13)");
        this.checkExpectedEnvelopeGeometry("LINESTRING (0 0, 0 10)");
        this.checkExpectedEnvelopeGeometry("LINESTRING (0 0, 10 0)");
        String poly10 = "POLYGON ((0 10, 10 10, 10 0, 0 0, 0 10))";
        this.checkExpectedEnvelopeGeometry(poly10);
        this.checkExpectedEnvelopeGeometry("LINESTRING (0 0, 10 10)", poly10);
        this.checkExpectedEnvelopeGeometry("POLYGON ((5 10, 10 6, 5 0, 0 6, 5 10))", poly10);
    }

    public void testMetrics() {
        Envelope env = new Envelope(0.0, 4.0, 0.0, 3.0);
        EnvelopeTest.assertEquals((Object)env.getWidth(), (Object)4.0);
        EnvelopeTest.assertEquals((Object)env.getHeight(), (Object)3.0);
        EnvelopeTest.assertEquals((Object)env.getDiameter(), (Object)5.0);
    }

    public void testEmptyMetrics() {
        Envelope env = new Envelope();
        EnvelopeTest.assertEquals((Object)env.getWidth(), (Object)0.0);
        EnvelopeTest.assertEquals((Object)env.getHeight(), (Object)0.0);
        EnvelopeTest.assertEquals((Object)env.getDiameter(), (Object)0.0);
    }

    private void checkIntersectsPermuted(double a1x, double a1y, double a2x, double a2y, double b1x, double b1y, double b2x, double b2y, boolean expected) {
        this.checkIntersects(a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y, expected);
        this.checkIntersects(a1x, a2y, a2x, a1y, b1x, b1y, b2x, b2y, expected);
        this.checkIntersects(a1x, a1y, a2x, a2y, b1x, b2y, b2x, b1y, expected);
        this.checkIntersects(a1x, a2y, a2x, a1y, b1x, b2y, b2x, b1y, expected);
    }

    private void checkIntersects(double a1x, double a1y, double a2x, double a2y, double b1x, double b1y, double b2x, double b2y, boolean expected) {
        Envelope a = new Envelope(a1x, a2x, a1y, a2y);
        Envelope b = new Envelope(b1x, b2x, b1y, b2y);
        EnvelopeTest.assertEquals((boolean)expected, (boolean)a.intersects(b));
        EnvelopeTest.assertEquals((boolean)expected, (!a.disjoint(b) ? 1 : 0) != 0);
        Coordinate a1 = new Coordinate(a1x, a1y);
        Coordinate a2 = new Coordinate(a2x, a2y);
        Coordinate b1 = new Coordinate(b1x, b1y);
        Coordinate b2 = new Coordinate(b2x, b2y);
        EnvelopeTest.assertEquals((boolean)expected, (boolean)Envelope.intersects((Coordinate)a1, (Coordinate)a2, (Coordinate)b1, (Coordinate)b2));
        EnvelopeTest.assertEquals((boolean)expected, (boolean)a.intersects(b1, b2));
    }

    void checkExpectedEnvelopeGeometry(String wktInput) throws ParseException {
        this.checkExpectedEnvelopeGeometry(wktInput, wktInput);
    }

    void checkExpectedEnvelopeGeometry(String wktInput, String wktEnvGeomExpected) throws ParseException {
        Geometry input = this.reader.read(wktInput);
        Geometry envGeomExpected = this.reader.read(wktEnvGeomExpected);
        Envelope env = input.getEnvelopeInternal();
        Geometry envGeomActual = this.geometryFactory.toGeometry(env);
        boolean isEqual = envGeomActual.equalsNorm(envGeomExpected);
        EnvelopeTest.assertTrue((boolean)isEqual);
    }

    public void testCompareTo() {
        this.checkCompareTo(0, new Envelope(), new Envelope());
        this.checkCompareTo(0, new Envelope(1.0, 2.0, 1.0, 2.0), new Envelope(1.0, 2.0, 1.0, 2.0));
        this.checkCompareTo(1, new Envelope(2.0, 3.0, 1.0, 2.0), new Envelope(1.0, 2.0, 1.0, 2.0));
        this.checkCompareTo(-1, new Envelope(1.0, 2.0, 1.0, 2.0), new Envelope(2.0, 3.0, 1.0, 2.0));
        this.checkCompareTo(1, new Envelope(1.0, 2.0, 1.0, 3.0), new Envelope(1.0, 2.0, 1.0, 2.0));
        this.checkCompareTo(1, new Envelope(2.0, 3.0, 1.0, 3.0), new Envelope(1.0, 3.0, 1.0, 2.0));
    }

    public void checkCompareTo(int expected, Envelope env1, Envelope env2) {
        EnvelopeTest.assertTrue((expected == env1.compareTo((Object)env2) ? 1 : 0) != 0);
        EnvelopeTest.assertTrue((-expected == env2.compareTo((Object)env1) ? 1 : 0) != 0);
    }
}

