/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.dissolve;

import com.hazelcast.shaded.org.locationtech.jts.dissolve.LineDissolver;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import test.jts.util.IOUtil;

public class LineDissolverTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(LineDissolverTest.class);
    }

    public LineDissolverTest(String name) {
        super(name);
    }

    public void testDebug() throws ParseException {
        this.testIsolatedRing();
    }

    public void testSingleSegmentLine() throws ParseException {
        this.checkDissolve("LINESTRING (0 0, 1 1)", "LINESTRING (0 0, 1 1)");
    }

    public void testTwoSegmentLine() throws ParseException {
        this.checkDissolve("LINESTRING (0 0, 1 1, 2 2)", "LINESTRING (0 0, 1 1, 2 2)");
    }

    public void testOverlappingTwoSegmentLines() throws ParseException {
        this.checkDissolve(new String[]{"LINESTRING (0 0, 1 1, 2 2)", "LINESTRING (1 1, 2 2, 3 3)"}, "LINESTRING (0 0, 1 1, 2 2, 3 3)");
    }

    public void testOverlappingLines3() throws ParseException {
        this.checkDissolve(new String[]{"LINESTRING (0 0, 1 1, 2 2)", "LINESTRING (1 1, 2 2, 3 3)", "LINESTRING (1 1, 2 2, 2 0)"}, "MULTILINESTRING ((0 0, 1 1, 2 2), (2 0, 2 2), (2 2, 3 3))");
    }

    public void testDivergingLines() throws ParseException {
        this.checkDissolve("MULTILINESTRING ((0 0, 1 0, 2 1), (0 0, 1 0, 2 0), (1 0, 2 1, 2 0, 3 0))", "MULTILINESTRING ((0 0, 1 0), (1 0, 2 0), (1 0, 2 1, 2 0), (2 0, 3 0))");
    }

    public void testLollipop() throws ParseException {
        this.checkDissolve("LINESTRING (0 0, 1 0, 2 0, 2 1, 1 0, 0 0)", "MULTILINESTRING ((0 0, 1 0), (1 0, 2 0, 2 1, 1 0))");
    }

    public void testDisjointLines() throws ParseException {
        this.checkDissolve("MULTILINESTRING ((0 0, 1 0, 2 1), (10 0, 11 0, 12 0))", "MULTILINESTRING ((0 0, 1 0, 2 1), (10 0, 11 0, 12 0))");
    }

    public void testSingleLine() throws ParseException {
        this.checkDissolve("MULTILINESTRING ((0 0, 1 0, 2 1))", "LINESTRING (0 0, 1 0, 2 1)");
    }

    public void testOneSegmentY() throws ParseException {
        this.checkDissolve("MULTILINESTRING ((0 0, 1 1, 2 2), (1 1, 1 2))", "MULTILINESTRING ((0 0, 1 1), (1 1, 2 2), (1 1, 1 2))");
    }

    public void testTwoSegmentY() throws ParseException {
        this.checkDissolve("MULTILINESTRING ((0 0, 9 9, 10 10, 11 11, 20 20), (10 10, 10 20))", "MULTILINESTRING ((10 20, 10 10), (10 10, 9 9, 0 0), (10 10, 11 11, 20 20))");
    }

    public void testIsolatedRing() throws ParseException {
        this.checkDissolve("LINESTRING (0 0, 1 1, 1 0, 0 0)", "LINESTRING (0 0, 1 1, 1 0, 0 0)");
    }

    public void testIsolateRingFromMultipleLineStrings() throws ParseException {
        this.checkDissolve("MULTILINESTRING ((0 0, 1 0, 1 1), (0 0, 0 1, 1 1))", "LINESTRING (0 0, 0 1, 1 1, 1 0, 0 0)");
    }

    public void testRingWithTail() throws ParseException {
        this.checkDissolve("MULTILINESTRING ((0 0, 1 0, 1 1), (0 0, 0 1, 1 1), (1 0, 2 0))", "MULTILINESTRING ((1 0, 0 0, 0 1, 1 1, 1 0), (1 0, 2 0))");
    }

    public void testZeroLengthStartSegment() throws ParseException {
        this.checkDissolve("MULTILINESTRING ((0 0, 0 0, 2 1))", "LINESTRING (0 0, 2 1)");
    }

    private void checkDissolve(String wkt, String expectedWKT) throws ParseException {
        this.checkDissolve(new String[]{wkt}, expectedWKT);
    }

    private void checkDissolve(String[] wkt, String expectedWKT) throws ParseException {
        List<Geometry> geoms = IOUtil.readWKT(wkt);
        Geometry expected = IOUtil.readWKT(expectedWKT);
        this.checkDissolve(geoms, expected);
    }

    private void checkDissolve(List geoms, Geometry expected) {
        LineDissolver d = new LineDissolver();
        d.add((Collection)geoms);
        Geometry result = d.getResult();
        boolean equal = result.norm().equalsExact(expected.norm());
        if (!equal) {
            // empty if block
        }
        LineDissolverTest.assertTrue((boolean)equal);
    }
}

