/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.awt;

import com.hazelcast.shaded.org.locationtech.jts.awt.ShapeReader;
import com.hazelcast.shaded.org.locationtech.jts.awt.ShapeWriter;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import java.awt.Shape;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class PolygonShapeTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(PolygonShapeTest.class);
    }

    public PolygonShapeTest(String name) {
        super(name);
    }

    public void testFlatness() {
        Geometry geom = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        ShapeWriter sw = new ShapeWriter();
        Shape shp = sw.toShape(geom);
        Geometry geom2 = ShapeReader.read((Shape)shp, (double)0.5, (GeometryFactory)geom.getFactory());
        Geometry geomExpected = this.read("POLYGON ((100 -200, 200 -200, 200 -100, 100 -100, 100 -200))");
        PolygonShapeTest.assertTrue((boolean)geomExpected.equalsExact(geom2));
    }

    public void testEmptyHole() {
        Geometry geom = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200), EMPTY)");
        ShapeWriter sw = new ShapeWriter();
        Shape shp = sw.toShape(geom);
        Geometry geom2 = ShapeReader.read((Shape)shp, (double)0.5, (GeometryFactory)geom.getFactory());
        Geometry geomExpected = this.read("POLYGON ((100 -200, 200 -200, 200 -100, 100 -100, 100 -200))");
        PolygonShapeTest.assertTrue((boolean)geomExpected.equalsExact(geom2));
    }
}

