/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;

public class ShewchuksDeterminant {
    private static final double epsilon;
    private static final double splitter;
    private static final double resulterrbound;
    private static final double ccwerrboundA;
    private static final double ccwerrboundB;
    private static final double ccwerrboundC;
    private static final double o3derrboundA;
    private static final double o3derrboundB;
    private static final double o3derrboundC;
    private static final double iccerrboundA;
    private static final double iccerrboundB;
    private static final double iccerrboundC;
    private static final double isperrboundA;
    private static final double isperrboundB;
    private static final double isperrboundC;

    public static int orientationIndexFilter(Coordinate pa, Coordinate pb, Coordinate pc) {
        double detsum;
        double detleft = (pa.x - pc.x) * (pb.y - pc.y);
        double detright = (pa.y - pc.y) * (pb.x - pc.x);
        double det = detleft - detright;
        if (detleft > 0.0) {
            if (detright <= 0.0) {
                return ShewchuksDeterminant.signum(det);
            }
            detsum = detleft + detright;
        } else if (detleft < 0.0) {
            if (detright >= 0.0) {
                return ShewchuksDeterminant.signum(det);
            }
            detsum = -detleft - detright;
        } else {
            return ShewchuksDeterminant.signum(det);
        }
        double ERR_BOUND = 1.0E-15;
        double errbound = ERR_BOUND * detsum;
        if (det >= errbound || -det >= errbound) {
            return ShewchuksDeterminant.signum(det);
        }
        return 2;
    }

    private static int signum(double x) {
        if (x > 0.0) {
            return 1;
        }
        if (x < 0.0) {
            return -1;
        }
        return 0;
    }

    public static int orientationIndex(Coordinate p1, Coordinate p2, Coordinate q) {
        double orientation = ShewchuksDeterminant.orient2d(p1, p2, q);
        if (orientation > 0.0) {
            return 1;
        }
        if (orientation < 0.0) {
            return -1;
        }
        return 0;
    }

    private static double orient2d(Coordinate pa, Coordinate pb, Coordinate pc) {
        double detsum;
        double detleft = (pa.x - pc.x) * (pb.y - pc.y);
        double detright = (pa.y - pc.y) * (pb.x - pc.x);
        double det = detleft - detright;
        if (detleft > 0.0) {
            if (detright <= 0.0) {
                return det;
            }
            detsum = detleft + detright;
        } else if (detleft < 0.0) {
            if (detright >= 0.0) {
                return det;
            }
            detsum = -detleft - detright;
        } else {
            return det;
        }
        double errbound = ccwerrboundA * detsum;
        if (det >= errbound || -det >= errbound) {
            return det;
        }
        return ShewchuksDeterminant.orient2dadapt(pa, pb, pc, detsum);
    }

    private static double orient2dadapt(Coordinate pa, Coordinate pb, Coordinate pc, double detsum) {
        double acx = pa.x - pc.x;
        double bcx = pb.x - pc.x;
        double acy = pa.y - pc.y;
        double bcy = pb.y - pc.y;
        double detleft = ShewchuksDeterminant.Two_Product_Head(acx, bcy);
        double detlefttail = ShewchuksDeterminant.Two_Product_Tail(acx, bcy, detleft);
        double detright = ShewchuksDeterminant.Two_Product_Head(acy, bcx);
        double detrighttail = ShewchuksDeterminant.Two_Product_Tail(acy, bcx, detright);
        double[] B2 = new double[4];
        B2[2] = ShewchuksDeterminant.Two_Two_Diff__x2(detleft, detlefttail, detright, detrighttail);
        B2[1] = ShewchuksDeterminant.Two_Two_Diff__x1(detleft, detlefttail, detright, detrighttail);
        B2[0] = ShewchuksDeterminant.Two_Two_Diff__x0(detleft, detlefttail, detright, detrighttail);
        B2[3] = ShewchuksDeterminant.Two_Two_Diff__x3(detleft, detlefttail, detright, detrighttail);
        double det = B2[0] + B2[1] + B2[2] + B2[3];
        double errbound = ccwerrboundB * detsum;
        if (det >= errbound || -det >= errbound) {
            return det;
        }
        double acxtail = ShewchuksDeterminant.Two_Diff_Tail(pa.x, pc.x, acx);
        double bcxtail = ShewchuksDeterminant.Two_Diff_Tail(pb.x, pc.x, bcx);
        double acytail = ShewchuksDeterminant.Two_Diff_Tail(pa.y, pc.y, acy);
        double bcytail = ShewchuksDeterminant.Two_Diff_Tail(pb.y, pc.y, bcy);
        if (acxtail == 0.0 && acytail == 0.0 && bcxtail == 0.0 && bcytail == 0.0) {
            return det;
        }
        if ((det += acx * bcytail + bcy * acxtail - (acy * bcxtail + bcx * acytail)) >= (errbound = ccwerrboundC * detsum + resulterrbound * ShewchuksDeterminant.Absolute(det)) || -det >= errbound) {
            return det;
        }
        double s1 = ShewchuksDeterminant.Two_Product_Head(acxtail, bcy);
        double s0 = ShewchuksDeterminant.Two_Product_Tail(acxtail, bcy, s1);
        double t1 = ShewchuksDeterminant.Two_Product_Head(acytail, bcx);
        double t0 = ShewchuksDeterminant.Two_Product_Tail(acytail, bcx, t1);
        double u3 = ShewchuksDeterminant.Two_Two_Diff__x3(s1, s0, t1, t0);
        double[] u = new double[4];
        u[2] = ShewchuksDeterminant.Two_Two_Diff__x2(s1, s0, t1, t0);
        u[1] = ShewchuksDeterminant.Two_Two_Diff__x1(s1, s0, t1, t0);
        u[0] = ShewchuksDeterminant.Two_Two_Diff__x0(s1, s0, t1, t0);
        u[3] = u3;
        double[] C1 = new double[8];
        int C1length = ShewchuksDeterminant.fast_expansion_sum_zeroelim(4, B2, 4, u, C1);
        s1 = ShewchuksDeterminant.Two_Product_Head(acx, bcytail);
        s0 = ShewchuksDeterminant.Two_Product_Tail(acx, bcytail, s1);
        t1 = ShewchuksDeterminant.Two_Product_Head(acy, bcxtail);
        t0 = ShewchuksDeterminant.Two_Product_Tail(acy, bcxtail, t1);
        u3 = ShewchuksDeterminant.Two_Two_Diff__x3(s1, s0, t1, t0);
        u[2] = ShewchuksDeterminant.Two_Two_Diff__x2(s1, s0, t1, t0);
        u[1] = ShewchuksDeterminant.Two_Two_Diff__x1(s1, s0, t1, t0);
        u[0] = ShewchuksDeterminant.Two_Two_Diff__x0(s1, s0, t1, t0);
        u[3] = u3;
        double[] C2 = new double[12];
        int C2length = ShewchuksDeterminant.fast_expansion_sum_zeroelim(C1length, C1, 4, u, C2);
        s1 = ShewchuksDeterminant.Two_Product_Head(acxtail, bcytail);
        s0 = ShewchuksDeterminant.Two_Product_Tail(acxtail, bcytail, s1);
        t1 = ShewchuksDeterminant.Two_Product_Head(acytail, bcxtail);
        t0 = ShewchuksDeterminant.Two_Product_Tail(acytail, bcxtail, t1);
        u3 = ShewchuksDeterminant.Two_Two_Diff__x3(s1, s0, t1, t0);
        u[2] = ShewchuksDeterminant.Two_Two_Diff__x2(s1, s0, t1, t0);
        u[1] = ShewchuksDeterminant.Two_Two_Diff__x1(s1, s0, t1, t0);
        u[0] = ShewchuksDeterminant.Two_Two_Diff__x0(s1, s0, t1, t0);
        u[3] = u3;
        double[] D = new double[16];
        int Dlength = ShewchuksDeterminant.fast_expansion_sum_zeroelim(C2length, C2, 4, u, D);
        return D[Dlength - 1];
    }

    private static double Absolute(double a) {
        return a >= 0.0 ? a : -a;
    }

    private static double Fast_Two_Sum_Tail(double a, double b, double x) {
        double bvirt = x - a;
        double y = b - bvirt;
        return y;
    }

    private static double Fast_Two_Sum_Head(double a, double b) {
        double x = a + b;
        return x;
    }

    private static double Two_Sum_Tail(double a, double b, double x) {
        double bvirt = x - a;
        double avirt = x - bvirt;
        double bround = b - bvirt;
        double around = a - avirt;
        double y = around + bround;
        return y;
    }

    private static double Two_Sum_Head(double a, double b) {
        double x = a + b;
        return x;
    }

    private static double Two_Diff_Tail(double a, double b, double x) {
        double bvirt = a - x;
        double avirt = x + bvirt;
        double bround = bvirt - b;
        double around = a - avirt;
        double y = around + bround;
        return y;
    }

    private static double Two_Diff_Head(double a, double b) {
        double x = a - b;
        return x;
    }

    private static double SplitLo(double a) {
        double c = splitter * a;
        double abig = c - a;
        double ahi = c - abig;
        double alo = a - ahi;
        return alo;
    }

    private static double SplitHi(double a) {
        double c = splitter * a;
        double abig = c - a;
        double ahi = c - abig;
        return ahi;
    }

    private static double Two_Product_Tail(double a, double b, double x) {
        double ahi = ShewchuksDeterminant.SplitHi(a);
        double alo = ShewchuksDeterminant.SplitLo(a);
        double bhi = ShewchuksDeterminant.SplitHi(b);
        double blo = ShewchuksDeterminant.SplitLo(b);
        double err1 = x - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        double y = alo * blo - err3;
        return y;
    }

    private static double Two_Product_Head(double a, double b) {
        double x = a * b;
        return x;
    }

    private static double Two_One_Diff__x0(double a1, double a0, double b) {
        double _i = ShewchuksDeterminant.Two_Diff_Head(a0, b);
        double x0 = ShewchuksDeterminant.Two_Diff_Tail(a0, b, _i);
        return x0;
    }

    private static double Two_One_Diff__x1(double a1, double a0, double b) {
        double _i = ShewchuksDeterminant.Two_Diff_Head(a0, b);
        double x2 = ShewchuksDeterminant.Two_Sum_Head(a1, _i);
        double x1 = ShewchuksDeterminant.Two_Sum_Tail(a1, _i, x2);
        return x1;
    }

    private static double Two_One_Diff__x2(double a1, double a0, double b) {
        double _i = ShewchuksDeterminant.Two_Diff_Head(a0, b);
        double x2 = ShewchuksDeterminant.Two_Sum_Head(a1, _i);
        return x2;
    }

    private static double Two_Two_Diff__x0(double a1, double a0, double b1, double b0) {
        double x0 = ShewchuksDeterminant.Two_One_Diff__x0(a1, a0, b0);
        return x0;
    }

    private static double Two_Two_Diff__x1(double a1, double a0, double b1, double b0) {
        double _j = ShewchuksDeterminant.Two_One_Diff__x2(a1, a0, b0);
        double _0 = ShewchuksDeterminant.Two_One_Diff__x1(a1, a0, b0);
        double x1 = ShewchuksDeterminant.Two_One_Diff__x0(_j, _0, b1);
        return x1;
    }

    private static double Two_Two_Diff__x2(double a1, double a0, double b1, double b0) {
        double _j = ShewchuksDeterminant.Two_One_Diff__x2(a1, a0, b0);
        double _0 = ShewchuksDeterminant.Two_One_Diff__x1(a1, a0, b0);
        double x2 = ShewchuksDeterminant.Two_One_Diff__x1(_j, _0, b1);
        return x2;
    }

    private static double Two_Two_Diff__x3(double a1, double a0, double b1, double b0) {
        double _j = ShewchuksDeterminant.Two_One_Diff__x2(a1, a0, b0);
        double _0 = ShewchuksDeterminant.Two_One_Diff__x1(a1, a0, b0);
        double x3 = ShewchuksDeterminant.Two_One_Diff__x2(_j, _0, b1);
        return x3;
    }

    private static int fast_expansion_sum_zeroelim(int elen, double[] e, int flen, double[] f, double[] h) {
        double hh;
        double Qnew;
        double Q;
        double enow = e[0];
        double fnow = f[0];
        int findex = 0;
        int eindex = 0;
        if (fnow > enow == fnow > -enow) {
            Q = enow;
            enow = e[eindex++];
        } else {
            Q = fnow;
            fnow = f[findex++];
        }
        int hindex = 0;
        if (eindex < elen && findex < flen) {
            if (fnow > enow == fnow > -enow) {
                Qnew = ShewchuksDeterminant.Fast_Two_Sum_Head(enow, Q);
                hh = ShewchuksDeterminant.Fast_Two_Sum_Tail(enow, Q, Qnew);
                enow = e[eindex++];
            } else {
                Qnew = ShewchuksDeterminant.Fast_Two_Sum_Head(fnow, Q);
                hh = ShewchuksDeterminant.Fast_Two_Sum_Tail(fnow, Q, Qnew);
                fnow = f[findex++];
            }
            Q = Qnew;
            if (hh != 0.0) {
                h[hindex++] = hh;
            }
            while (eindex < elen && findex < flen) {
                if (fnow > enow == fnow > -enow) {
                    Qnew = ShewchuksDeterminant.Two_Sum_Head(Q, enow);
                    hh = ShewchuksDeterminant.Two_Sum_Tail(Q, enow, Qnew);
                    enow = e[eindex++];
                } else {
                    Qnew = ShewchuksDeterminant.Two_Sum_Head(Q, fnow);
                    hh = ShewchuksDeterminant.Two_Sum_Tail(Q, fnow, Qnew);
                    fnow = f[findex++];
                }
                Q = Qnew;
                if (hh == 0.0) continue;
                h[hindex++] = hh;
            }
        }
        while (eindex < elen) {
            Qnew = ShewchuksDeterminant.Two_Sum_Head(Q, enow);
            hh = ShewchuksDeterminant.Two_Sum_Tail(Q, enow, Qnew);
            enow = e[eindex++];
            Q = Qnew;
            if (hh == 0.0) continue;
            h[hindex++] = hh;
        }
        while (findex < flen) {
            Qnew = ShewchuksDeterminant.Two_Sum_Head(Q, fnow);
            hh = ShewchuksDeterminant.Two_Sum_Tail(Q, fnow, Qnew);
            fnow = f[findex++];
            Q = Qnew;
            if (hh == 0.0) continue;
            h[hindex++] = hh;
        }
        if (Q != 0.0 || hindex == 0) {
            h[hindex++] = Q;
        }
        return hindex;
    }

    private static double estimate(int elen, double[] e) {
        double Q = e[0];
        for (int eindex = 1; eindex < elen; ++eindex) {
            Q += e[eindex];
        }
        return Q;
    }

    static {
        double lastcheck;
        boolean every_other = true;
        double half = 0.5;
        double epsilon_temp = 1.0;
        double splitter_temp = 1.0;
        double check = 1.0;
        do {
            lastcheck = check;
            epsilon_temp *= half;
            if (every_other) {
                splitter_temp *= 2.0;
            }
            every_other = !every_other;
        } while ((check = 1.0 + epsilon_temp) != 1.0 && check != lastcheck);
        splitter_temp += 1.0;
        resulterrbound = (3.0 + 8.0 * epsilon_temp) * epsilon_temp;
        ccwerrboundA = (3.0 + 16.0 * epsilon_temp) * epsilon_temp;
        ccwerrboundB = (2.0 + 12.0 * epsilon_temp) * epsilon_temp;
        ccwerrboundC = (9.0 + 64.0 * epsilon_temp) * epsilon_temp * epsilon_temp;
        o3derrboundA = (7.0 + 56.0 * epsilon_temp) * epsilon_temp;
        o3derrboundB = (3.0 + 28.0 * epsilon_temp) * epsilon_temp;
        o3derrboundC = (26.0 + 288.0 * epsilon_temp) * epsilon_temp * epsilon_temp;
        iccerrboundA = (10.0 + 96.0 * epsilon_temp) * epsilon_temp;
        iccerrboundB = (4.0 + 48.0 * epsilon_temp) * epsilon_temp;
        iccerrboundC = (44.0 + 576.0 * epsilon_temp) * epsilon_temp * epsilon_temp;
        isperrboundA = (16.0 + 224.0 * epsilon_temp) * epsilon_temp;
        isperrboundB = (5.0 + 72.0 * epsilon_temp) * epsilon_temp;
        isperrboundC = (71.0 + 1408.0 * epsilon_temp) * epsilon_temp * epsilon_temp;
        epsilon = epsilon_temp;
        splitter = splitter_temp;
    }
}

