/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.RobustLineIntersector;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateXY;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineSegment;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class RobustLineIntersectorZTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(RobustLineIntersectorZTest.class);
    }

    public RobustLineIntersectorZTest(String name) {
        super(name);
    }

    public void testInterior() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 3.0, 3.0, 3.0), RobustLineIntersectorZTest.line(1.0, 3.0, 10.0, 3.0, 1.0, 30.0), RobustLineIntersectorZTest.pt(2.0, 2.0, 11.0));
    }

    public void testInterior2D() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 3.0, 3.0), RobustLineIntersectorZTest.line(1.0, 3.0, 3.0, 1.0), RobustLineIntersectorZTest.pt(2.0, 2.0, Double.NaN));
    }

    public void testInterior3D2D() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 3.0, 3.0, 3.0), RobustLineIntersectorZTest.line(1.0, 3.0, 3.0, 1.0), RobustLineIntersectorZTest.pt(2.0, 2.0, 2.0));
    }

    public void testInterior2D3D() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 3.0, 3.0), RobustLineIntersectorZTest.line(1.0, 3.0, 10.0, 3.0, 1.0, 30.0), RobustLineIntersectorZTest.pt(2.0, 2.0, 20.0));
    }

    public void testInterior2D3DPart() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 3.0, 3.0, 3.0), RobustLineIntersectorZTest.line(1.0, 3.0, 10.0, 3.0, 1.0, Double.NaN), RobustLineIntersectorZTest.pt(2.0, 2.0, 6.0));
    }

    public void testEndpoint() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 3.0, 3.0, 3.0), RobustLineIntersectorZTest.line(3.0, 3.0, 3.0, 3.0, 1.0, 30.0), RobustLineIntersectorZTest.pt(3.0, 3.0, 3.0));
    }

    public void testEndpoint2D() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 3.0, 3.0), RobustLineIntersectorZTest.line(3.0, 3.0, 3.0, 1.0), RobustLineIntersectorZTest.pt(3.0, 3.0, Double.NaN));
    }

    public void testEndpoint2D3D() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 3.0, 3.0, 3.0), RobustLineIntersectorZTest.line(3.0, 3.0, 3.0, 1.0), RobustLineIntersectorZTest.pt(3.0, 3.0, 3.0));
    }

    public void testInteriorEndpoint() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 3.0, 3.0, 3.0), RobustLineIntersectorZTest.line(2.0, 2.0, 10.0, 3.0, 1.0, 30.0), RobustLineIntersectorZTest.pt(2.0, 2.0, 10.0));
    }

    public void testInteriorEndpoint3D2D() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 3.0, 3.0, 3.0), RobustLineIntersectorZTest.line(2.0, 2.0, 3.0, 1.0), RobustLineIntersectorZTest.pt(2.0, 2.0, 2.0));
    }

    public void testInteriorEndpoint2D3D() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 3.0, 3.0), RobustLineIntersectorZTest.line(2.0, 2.0, 10.0, 3.0, 1.0, 20.0), RobustLineIntersectorZTest.pt(2.0, 2.0, 10.0));
    }

    public void testCollinearEqual() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 3.0, 3.0, 3.0), RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 3.0, 3.0, 3.0), RobustLineIntersectorZTest.pt(1.0, 1.0, 1.0), RobustLineIntersectorZTest.pt(3.0, 3.0, 3.0));
    }

    public void testCollinearEqual3D2D() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 3.0, 3.0, 3.0), RobustLineIntersectorZTest.line(1.0, 1.0, 3.0, 3.0), RobustLineIntersectorZTest.pt(1.0, 1.0, 1.0), RobustLineIntersectorZTest.pt(3.0, 3.0, 3.0));
    }

    public void testCollinearEndpoint() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 3.0, 3.0, 3.0), RobustLineIntersectorZTest.line(3.0, 3.0, 3.0, 5.0, 5.0, 5.0), RobustLineIntersectorZTest.pt(3.0, 3.0, 3.0));
    }

    public void testCollinearEndpoint3D2D() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 3.0, 3.0, 3.0), RobustLineIntersectorZTest.line(3.0, 3.0, 5.0, 5.0), RobustLineIntersectorZTest.pt(3.0, 3.0, 3.0));
    }

    public void testCollinearContained() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 5.0, 5.0, 5.0), RobustLineIntersectorZTest.line(3.0, 3.0, 3.0, 4.0, 4.0, 4.0), RobustLineIntersectorZTest.pt(3.0, 3.0, 3.0), RobustLineIntersectorZTest.pt(4.0, 4.0, 4.0));
    }

    public void testCollinearContained3D2D() {
        this.checkIntersection(RobustLineIntersectorZTest.line(1.0, 1.0, 1.0, 5.0, 5.0, 5.0), RobustLineIntersectorZTest.line(3.0, 3.0, 4.0, 4.0), RobustLineIntersectorZTest.pt(3.0, 3.0, 3.0), RobustLineIntersectorZTest.pt(4.0, 4.0, 4.0));
    }

    public void testInteriorXY() {
        this.checkIntersection(new LineSegment((Coordinate)new CoordinateXY(1.0, 1.0), (Coordinate)new CoordinateXY(3.0, 3.0)), new LineSegment((Coordinate)new CoordinateXY(1.0, 3.0), (Coordinate)new CoordinateXY(3.0, 1.0)), RobustLineIntersectorZTest.pt(2.0, 2.0));
    }

    public void testCollinearContainedXY() {
        this.checkIntersection(new LineSegment((Coordinate)new CoordinateXY(1.0, 1.0), (Coordinate)new CoordinateXY(5.0, 5.0)), new LineSegment((Coordinate)new CoordinateXY(3.0, 3.0), (Coordinate)new CoordinateXY(4.0, 4.0)), RobustLineIntersectorZTest.pt(3.0, 3.0), RobustLineIntersectorZTest.pt(4.0, 4.0));
    }

    private void checkIntersection(LineSegment line1, LineSegment line2, Coordinate p1, Coordinate p2) {
        this.checkIntersectionDir(line1, line2, p1, p2);
        this.checkIntersectionDir(line2, line1, p1, p2);
        LineSegment line1Rev = new LineSegment(line1.p1, line1.p0);
        LineSegment line2Rev = new LineSegment(line2.p1, line2.p0);
        this.checkIntersectionDir(line1Rev, line2Rev, p1, p2);
        this.checkIntersectionDir(line2Rev, line1Rev, p1, p2);
    }

    private void checkIntersectionDir(LineSegment line1, LineSegment line2, Coordinate p1, Coordinate p2) {
        RobustLineIntersector li = new RobustLineIntersector();
        li.computeIntersection(line1.p0, line1.p1, line2.p0, line2.p1);
        RobustLineIntersectorZTest.assertEquals((int)2, (int)li.getIntersectionNum());
        Coordinate actual1 = li.getIntersection(0);
        Coordinate actual2 = li.getIntersection(1);
        if (actual1.compareTo(actual2) > 0) {
            actual1 = li.getIntersection(1);
            actual2 = li.getIntersection(0);
        }
        this.checkEqualXYZ(p1, actual1);
        this.checkEqualXYZ(p2, actual2);
    }

    private void checkIntersection(LineSegment line1, LineSegment line2, Coordinate pt) {
        this.checkIntersectionDir(line1, line2, pt);
        this.checkIntersectionDir(line2, line1, pt);
        LineSegment line1Rev = new LineSegment(line1.p1, line1.p0);
        LineSegment line2Rev = new LineSegment(line2.p1, line2.p0);
        this.checkIntersectionDir(line1Rev, line2Rev, pt);
        this.checkIntersectionDir(line2Rev, line1Rev, pt);
    }

    private void checkIntersectionDir(LineSegment line1, LineSegment line2, Coordinate pt) {
        RobustLineIntersector li = new RobustLineIntersector();
        li.computeIntersection(line1.p0, line1.p1, line2.p0, line2.p1);
        RobustLineIntersectorZTest.assertEquals((int)1, (int)li.getIntersectionNum());
        Coordinate actual = li.getIntersection(0);
        this.checkEqualXYZ(pt, actual);
    }

    private static Coordinate pt(double x, double y, double z) {
        return new Coordinate(x, y, z);
    }

    private static Coordinate pt(double x, double y) {
        return RobustLineIntersectorZTest.pt(x, y, Double.NaN);
    }

    private static LineSegment line(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new LineSegment(new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2));
    }

    private static LineSegment line(double x1, double y1, double x2, double y2) {
        return new LineSegment(new Coordinate(x1, y1), new Coordinate(x2, y2));
    }
}

