/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.MinimumDiameter;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class MinimumRectanglelTest
extends GeometryTestCase {
    private static final double TOL = 1.0E-10;

    public static void main(String[] args) {
        TestRunner.run(MinimumRectanglelTest.class);
    }

    public MinimumRectanglelTest(String name) {
        super(name);
    }

    public void testLengthZero() {
        this.checkMinRectangle("LINESTRING (1 1, 1 1)", "POINT (1 1)");
    }

    public void testHorizontal() {
        this.checkMinRectangle("LINESTRING (1 1, 3 1, 5 1, 7 1)", "LINESTRING (1 1, 7 1)");
    }

    public void testVertical() {
        this.checkMinRectangle("LINESTRING (1 1, 1 4, 1 7, 1 9)", "LINESTRING (1 1, 1 9)");
    }

    public void testBentLine() {
        this.checkMinRectangle("LINESTRING (1 2, 3 8, 9 6)", "POLYGON ((9 6, 7 10, -1 6, 1 2, 9 6))");
    }

    public void testFlatDiagonal() throws Exception {
        this.checkMinRectangle("LINESTRING(-99.48710639268086 34.79029839231914,-99.48370699999998 34.78689899963806,-99.48152167568102 34.784713675318976)", "LINESTRING (-99.48710639268086 34.79029839231914, -99.48152167568102 34.784713675318976)");
    }

    private void checkMinRectangle(String wkt, String wktExpected) {
        Geometry geom = this.read(wkt);
        Geometry actual = MinimumDiameter.getMinimumRectangle((Geometry)geom);
        Geometry expected = this.read(wktExpected);
        this.checkEqual(expected, actual, 1.0E-10);
    }
}

