/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTFileReader;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import com.hazelcast.shaded.org.locationtech.jts.util.Stopwatch;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;
import test.jts.TestFiles;

public class InteriorPointTest
extends GeometryTestCase {
    WKTReader rdr = new WKTReader();

    public static void main(String[] args) {
        TestRunner.run(InteriorPointTest.class);
    }

    public InteriorPointTest(String name) {
        super(name);
    }

    public void testPolygonZeroArea() {
        this.checkInteriorPoint(this.read("POLYGON ((10 10, 10 10, 10 10, 10 10))"), new Coordinate(10.0, 10.0));
    }

    public void testAll() throws Exception {
        this.checkInteriorPointFile(TestFiles.getResourceFilePath("world.wkt"));
    }

    void checkInteriorPointFile(String file) throws Exception {
        WKTFileReader fileRdr = new WKTFileReader((Reader)new FileReader(file), this.rdr);
        this.checkInteriorPointFile(fileRdr);
    }

    void checkInteriorPointResource(String resource) throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        WKTFileReader fileRdr = new WKTFileReader((Reader)new InputStreamReader(is), this.rdr);
        this.checkInteriorPointFile(fileRdr);
    }

    private void checkInteriorPointFile(WKTFileReader fileRdr) throws IOException, ParseException {
        List polys = fileRdr.read();
        this.checkInteriorPoint(polys);
    }

    void checkInteriorPoint(List geoms) {
        Stopwatch sw = new Stopwatch();
        for (Geometry g : geoms) {
            this.checkInteriorPoint(g);
            System.out.print(".");
        }
    }

    private void checkInteriorPoint(Geometry g) {
        Point ip = g.getInteriorPoint();
        InteriorPointTest.assertTrue((boolean)g.contains((Geometry)ip));
    }

    private void checkInteriorPoint(Geometry g, Coordinate expectedPt) {
        Point ip = g.getInteriorPoint();
        InteriorPointTest.assertTrue((boolean)ip.getCoordinate().equals2D(expectedPt));
    }
}

