/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.util;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.util.DefaultTransformer;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class DefaultTransformerTest {
    @Test
    public void testTransformDouble() throws Exception {
        double expected = 1.0;
        Double input = expected;
        DefaultTransformer t = new DefaultTransformer();
        Assert.assertEquals((double)expected, (double)t.transform((Object)input), (double)1.0E-4);
    }

    @Test
    public void testTransformNull() throws Exception {
        DefaultTransformer t = new DefaultTransformer();
        try {
            t.transform(null);
            Assert.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTransformInteger() throws Exception {
        double expected = 1.0;
        Integer input = 1;
        DefaultTransformer t = new DefaultTransformer();
        Assert.assertEquals((double)expected, (double)t.transform((Object)input), (double)1.0E-4);
    }

    @Test
    public void testTransformBigDecimal() throws Exception {
        double expected = 1.0;
        BigDecimal input = new BigDecimal("1.0");
        DefaultTransformer t = new DefaultTransformer();
        Assert.assertEquals((double)expected, (double)t.transform((Object)input), (double)1.0E-4);
    }

    @Test
    public void testTransformString() throws Exception {
        double expected = 1.0;
        String input = "1.0";
        DefaultTransformer t = new DefaultTransformer();
        Assert.assertEquals((double)expected, (double)t.transform((Object)input), (double)1.0E-4);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testTransformObject() {
        Boolean input = Boolean.TRUE;
        DefaultTransformer t = new DefaultTransformer();
        t.transform((Object)input);
    }

    @Test
    public void testSerial() {
        Assert.assertEquals((Object)new DefaultTransformer(), (Object)TestUtils.serializeAndRecover(new DefaultTransformer()));
    }
}

