/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.util;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathArithmeticException;
import com.hazelcast.shaded.org.apache.commons.math3.util.BigReal;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.junit.Assert;
import org.junit.Test;

public class BigRealTest {
    @Test
    public void testConstructor() {
        Assert.assertEquals((double)1.625, (double)new BigReal(new BigDecimal("1.625")).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)-5.0, (double)new BigReal(new BigInteger("-5")).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)-5.0, (double)new BigReal(new BigInteger("-5"), MathContext.DECIMAL64).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)0.125, (double)new BigReal(new BigInteger("125"), 3).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)0.125, (double)new BigReal(new BigInteger("125"), 3, MathContext.DECIMAL64).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.625, (double)new BigReal(new char[]{'1', '.', '6', '2', '5'}).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.625, (double)new BigReal(new char[]{'A', 'A', '1', '.', '6', '2', '5', '9'}, 2, 5).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.625, (double)new BigReal(new char[]{'A', 'A', '1', '.', '6', '2', '5', '9'}, 2, 5, MathContext.DECIMAL64).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.625, (double)new BigReal(new char[]{'1', '.', '6', '2', '5'}, MathContext.DECIMAL64).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.625, (double)new BigReal(1.625).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.625, (double)new BigReal(1.625, MathContext.DECIMAL64).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)-5.0, (double)new BigReal(-5).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)-5.0, (double)new BigReal(-5, MathContext.DECIMAL64).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)-5.0, (double)new BigReal(-5L).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)-5.0, (double)new BigReal(-5L, MathContext.DECIMAL64).doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.625, (double)new BigReal("1.625").doubleValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.625, (double)new BigReal("1.625", MathContext.DECIMAL64).doubleValue(), (double)1.0E-15);
    }

    @Test
    public void testCompareTo() {
        BigReal first = new BigReal(0.5);
        BigReal second = new BigReal(0.3333333333333333);
        BigReal third = new BigReal(0.5);
        Assert.assertEquals((long)0L, (long)first.compareTo(first));
        Assert.assertEquals((long)0L, (long)first.compareTo(third));
        Assert.assertEquals((long)1L, (long)first.compareTo(second));
        Assert.assertEquals((long)-1L, (long)second.compareTo(first));
    }

    @Test
    public void testAdd() {
        BigReal a = new BigReal("1.2345678");
        BigReal b = new BigReal("8.7654321");
        Assert.assertEquals((double)9.9999999, (double)a.add(b).doubleValue(), (double)1.0E-15);
    }

    @Test
    public void testSubtract() {
        BigReal a = new BigReal("1.2345678");
        BigReal b = new BigReal("8.7654321");
        Assert.assertEquals((double)-7.5308643, (double)a.subtract(b).doubleValue(), (double)1.0E-15);
    }

    @Test
    public void testNegate() {
        BigReal a = new BigReal("1.2345678");
        BigReal zero = new BigReal("0.0000000");
        Assert.assertEquals((Object)a.negate().add(a), (Object)zero);
        Assert.assertEquals((Object)a.add(a.negate()), (Object)zero);
        Assert.assertEquals((Object)zero, (Object)zero.negate());
    }

    @Test
    public void testDivide() {
        BigReal a = new BigReal("1.0000000000");
        BigReal b = new BigReal("0.0009765625");
        Assert.assertEquals((double)1024.0, (double)a.divide(b).doubleValue(), (double)1.0E-15);
    }

    @Test(expected=MathArithmeticException.class)
    public void testDivisionByZero() {
        BigReal a = BigReal.ONE;
        BigReal b = BigReal.ZERO;
        a.divide(b);
    }

    @Test
    public void testReciprocal() {
        BigReal a = new BigReal("1.2345678");
        double eps = FastMath.pow((double)10.0, (int)(-a.getScale()));
        BigReal one = new BigReal("1.0000000");
        BigReal b = a.reciprocal();
        BigReal r = one.subtract(a.multiply(b));
        Assert.assertTrue((FastMath.abs((double)r.doubleValue()) <= eps ? 1 : 0) != 0);
        r = one.subtract(b.multiply(a));
        Assert.assertTrue((FastMath.abs((double)r.doubleValue()) <= eps ? 1 : 0) != 0);
    }

    @Test(expected=MathArithmeticException.class)
    public void testReciprocalOfZero() {
        BigReal.ZERO.reciprocal();
    }

    @Test
    public void testMultiply() {
        BigReal a = new BigReal("1024.0");
        BigReal b = new BigReal("0.0009765625");
        Assert.assertEquals((double)1.0, (double)a.multiply(b).doubleValue(), (double)1.0E-15);
        int n = 1024;
        Assert.assertEquals((double)1.0, (double)b.multiply(n).doubleValue(), (double)1.0E-15);
    }

    @Test
    public void testDoubleValue() {
        Assert.assertEquals((double)0.5, (double)new BigReal(0.5).doubleValue(), (double)1.0E-15);
    }

    @Test
    public void testBigDecimalValue() {
        BigDecimal pi = new BigDecimal("3.1415926535897932384626433832795028841971693993751");
        Assert.assertEquals((Object)pi, (Object)new BigReal(pi).bigDecimalValue());
        Assert.assertEquals((Object)new BigDecimal(0.5), (Object)new BigReal(0.5).bigDecimalValue());
    }

    @Test
    public void testEqualsAndHashCode() {
        BigReal zero = new BigReal(0.0);
        Object nullReal = null;
        Assert.assertTrue((boolean)zero.equals((Object)zero));
        Assert.assertFalse((boolean)zero.equals(nullReal));
        Assert.assertFalse((boolean)zero.equals((Object)0.0));
        BigReal zero2 = new BigReal(0.0);
        Assert.assertTrue((boolean)zero.equals((Object)zero2));
        Assert.assertEquals((long)zero.hashCode(), (long)zero2.hashCode());
        BigReal one = new BigReal(1.0);
        Assert.assertFalse((one.equals((Object)zero) || zero.equals((Object)one) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)one.equals((Object)BigReal.ONE));
    }

    @Test
    public void testSerial() {
        BigReal[] Reals;
        for (BigReal Real : Reals = new BigReal[]{new BigReal(3.0), BigReal.ONE, BigReal.ZERO, new BigReal(17), new BigReal(Math.PI), new BigReal(-2.5)}) {
            Assert.assertEquals((Object)Real, (Object)TestUtils.serializeAndRecover(Real));
        }
    }
}

