/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.inference;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import com.hazelcast.shaded.org.apache.commons.math3.stat.inference.OneWayAnova;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class OneWayAnovaTest {
    protected OneWayAnova testStatistic = new OneWayAnova();
    private double[] emptyArray = new double[0];
    private double[] classA = new double[]{93.0, 103.0, 95.0, 101.0, 91.0, 105.0, 96.0, 94.0, 101.0};
    private double[] classB = new double[]{99.0, 92.0, 102.0, 100.0, 102.0, 89.0};
    private double[] classC = new double[]{110.0, 115.0, 111.0, 117.0, 128.0, 117.0};

    @Test
    public void testAnovaFValue() {
        ArrayList<double[]> threeClasses = new ArrayList<double[]>();
        threeClasses.add(this.classA);
        threeClasses.add(this.classB);
        threeClasses.add(this.classC);
        Assert.assertEquals((String)"ANOVA F-value", (double)24.67361709460624, (double)this.testStatistic.anovaFValue(threeClasses), (double)1.0E-12);
        ArrayList<double[]> twoClasses = new ArrayList<double[]>();
        twoClasses.add(this.classA);
        twoClasses.add(this.classB);
        Assert.assertEquals((String)"ANOVA F-value", (double)0.0150579150579, (double)this.testStatistic.anovaFValue(twoClasses), (double)1.0E-12);
        ArrayList<double[]> emptyContents = new ArrayList<double[]>();
        emptyContents.add(this.emptyArray);
        emptyContents.add(this.classC);
        try {
            this.testStatistic.anovaFValue(emptyContents);
            Assert.fail((String)"empty array for key classX, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        ArrayList<double[]> tooFew = new ArrayList<double[]>();
        tooFew.add(this.classA);
        try {
            this.testStatistic.anovaFValue(tooFew);
            Assert.fail((String)"less than two classes, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAnovaPValue() {
        ArrayList<double[]> threeClasses = new ArrayList<double[]>();
        threeClasses.add(this.classA);
        threeClasses.add(this.classB);
        threeClasses.add(this.classC);
        Assert.assertEquals((String)"ANOVA P-value", (double)6.959446E-6, (double)this.testStatistic.anovaPValue(threeClasses), (double)1.0E-12);
        ArrayList<double[]> twoClasses = new ArrayList<double[]>();
        twoClasses.add(this.classA);
        twoClasses.add(this.classB);
        Assert.assertEquals((String)"ANOVA P-value", (double)0.904212960464, (double)this.testStatistic.anovaPValue(twoClasses), (double)1.0E-12);
    }

    @Test
    public void testAnovaPValueSummaryStatistics() {
        ArrayList<SummaryStatistics> threeClasses = new ArrayList<SummaryStatistics>();
        SummaryStatistics statsA = new SummaryStatistics();
        for (double a : this.classA) {
            statsA.addValue(a);
        }
        threeClasses.add(statsA);
        SummaryStatistics statsB = new SummaryStatistics();
        for (double b : this.classB) {
            statsB.addValue(b);
        }
        threeClasses.add(statsB);
        SummaryStatistics statsC = new SummaryStatistics();
        for (double c : this.classC) {
            statsC.addValue(c);
        }
        threeClasses.add(statsC);
        Assert.assertEquals((String)"ANOVA P-value", (double)6.959446E-6, (double)this.testStatistic.anovaPValue(threeClasses, true), (double)1.0E-12);
        ArrayList<SummaryStatistics> twoClasses = new ArrayList<SummaryStatistics>();
        twoClasses.add(statsA);
        twoClasses.add(statsB);
        Assert.assertEquals((String)"ANOVA P-value", (double)0.904212960464, (double)this.testStatistic.anovaPValue(twoClasses, false), (double)1.0E-12);
    }

    @Test
    public void testAnovaTest() {
        ArrayList<double[]> threeClasses = new ArrayList<double[]>();
        threeClasses.add(this.classA);
        threeClasses.add(this.classB);
        threeClasses.add(this.classC);
        Assert.assertTrue((String)"ANOVA Test P<0.01", (boolean)this.testStatistic.anovaTest(threeClasses, 0.01));
        ArrayList<double[]> twoClasses = new ArrayList<double[]>();
        twoClasses.add(this.classA);
        twoClasses.add(this.classB);
        Assert.assertFalse((String)"ANOVA Test P>0.01", (boolean)this.testStatistic.anovaTest(twoClasses, 0.01));
    }
}

