/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.inference;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.NormalDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well19937c;
import com.hazelcast.shaded.org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import com.hazelcast.shaded.org.apache.commons.math3.util.CombinatoricsUtils;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathArrays;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class KolmogorovSmirnovTestTest {
    protected static final double TOLERANCE = 1.0E-9;
    protected static final double[] gaussian = new double[]{0.26055895, -0.63665233, 1.51221323, 0.61246988, -0.03013003, -1.73025682, -0.51435805, 0.70494168, 0.18242945, 0.94734336, -0.04286604, -0.37931719, -1.07026403, -2.05861425, 0.11201862, 0.71400136, -0.52122185, -0.02478725, -1.86811649, -1.79907688, 0.15046279, 1.32390193, 1.55889719, 1.83149171, -0.03948003, -0.98579207, -0.7679054, 0.89080682, 0.19532153, 0.40692841, 0.15047336, -0.58546562, -0.39865469, 0.77604271, -0.65188221, -1.80368554, 0.65273365, -0.75283102, -1.9102215, -0.07640869, -1.08681188, -0.892706, 2.09017508, 0.43907981, 0.10744033, -0.70961218, 1.157073, 0.44560525, -2.04593349, 0.53816843, -0.0836664, 0.24652218, 1.80549401, -0.99220707, -1.14589408, -0.2717029, -0.49696855, 0.00968353, -1.87113545, -1.91116529, 0.97151891, -0.73576115, -0.59437029, 0.72148436, 0.01747695, -0.62601157, -1.00971538, -1.42691397, 1.03250131, -0.30672627, -0.15353992, -1.19976069, -0.68364218, 0.37525652, -0.46592881, -0.52116168, -0.17162202, 1.04679215, 0.25165971, -0.04125231, -0.23756244, -0.93389975, 0.75551407, 0.08347445, -0.27482228, -0.4717632, -0.1867746, -0.1166976, 0.5763333, 0.1307952, 0.7630584, -0.3616248, 2.138379, -0.794663, 0.0231885, 0.7919195, 1.6057144, -0.3802508, 0.1229078, 1.5252901, -0.8543149, 0.302504};
    protected static final double[] gaussian2 = new double[]{2.88041498038308, -0.632349445671017, 0.402121295225571, 0.692626364613243, 1.30693446815426, -0.714176317131286, -0.233169206599583, 1.09113298322107, -1.53149079994305, 1.23259966205809, 1.01389927412503, 0.0143898711497477, -0.512813545447559, 2.79364360835469, 0.662008875538092, 1.04861546834788, -0.321280099931466, 0.250296656278743, 1.75820367603736, -2.31433523590905, -0.462694696086403, 0.187725700950191, -2.24410950019152, 2.83473751105445, 0.252460174391016, 1.39051945380281, -1.56270144203134, 0.998522814471644, -1.50147469080896, 0.145307533554146, 0.469089457043406, -0.0914780723809334, -0.123446939266548, -0.610513388160565, -3.71548343891957, -0.329577317349478, -0.312973794075871, 2.02051909758923, 2.85214308266271, 0.0193222002327237, -0.0322422268266562, 0.514736012106768, 0.231484953375887, -2.22468798953629, 1.42197716075595, 2.69988043856357, 0.0443757119128293, 0.721536984407798, -0.0445688839903234, -0.294372724550705, 0.234041580912698, -0.868973119365727, 1.3524893453845, -0.931054600134503, -0.263514296006792, 0.540949457402918, -0.882544288773685, -0.34148675747989, 1.56664494810034, 2.19850536566584, -0.667972122928022, -0.70889669526203, -0.00251758193079668, 2.39527162977682, -2.7559594317269, -0.547393502656671, -2.62144031572617, 2.81504147017922, -1.02036850201042, -1.00713927602786, -0.520197775122254, 1.00625480138649, 2.46756916531313, 1.64364743727799, 0.704545210648595, -0.425885789416992, -1.78387854908546, -0.286783886710481, 0.404183648369076, -0.369324280845769, -0.0391185138840443, 2.41257787857293, 2.49744281317859, -0.826964496939021, -0.792555379958975, 1.81097685787403, -0.475014580016638, 1.23387615291805, 0.646615294802053, 1.88496377454523, 1.20390698380814, -0.27812153371728, 2.50149494533101, 0.406964323253817, -1.72253451309982, 1.98432494184332, 2.2223658560333, 0.393086362404685, -0.504073151377089, -0.0484610869883821};
    protected static final double[] uniform = new double[]{0.7930305, 0.6424382, 0.8747699, 0.7156518, 0.1845909, 0.2022326, 0.4877206, 0.8928752, 0.2293062, 0.4222006, 0.1610459, 0.2830535, 0.9946345, 0.7329499, 0.26411126, 0.87958133, 0.29827437, 0.39185988, 0.38351185, 0.36359611, 0.48646472, 0.05577866, 0.5615225, 0.52672013, 0.13171783, 0.95864085, 0.03060207, 0.33514887, 0.72508148, 0.38901437, 0.9978665, 0.59813, 0.1065388, 0.7036991, 0.1071584, 0.4423963, 0.1107071, 0.6437221, 0.58523872, 0.05044634, 0.65999539, 0.3736726, 0.73270024, 0.47473755, 0.74661163, 0.50765549, 0.05377347, 0.40998009, 0.55235182, 0.21361998, 0.63117971, 0.18109222, 0.8915351, 0.23203248, 0.6177106, 0.6856418, 0.2158557, 0.9870501, 0.2036914, 0.2100311, 0.906502, 0.7459159, 0.5663179, 0.06753629, 0.39684629, 0.52504615, 0.14199103, 0.7855112, 0.90503321, 0.80452362, 0.9960115, 0.8172592, 0.5831134, 0.8794187, 0.2021501, 0.2923505, 0.9561824, 0.8792248, 0.85201008, 0.02945562, 0.26200374, 0.11382818, 0.17238856, 0.36449473, 0.69688273, 0.9621633, 0.4859432, 0.4503438, 0.1917656, 0.8357845, 0.9957812, 0.463357, 0.8654599, 0.4597996, 0.68190289, 0.58887855, 0.09359396, 0.98081979, 0.73659533, 0.89344777, 0.18903099, 0.97660425};

    @Test
    public void testOneSampleGaussianGaussian() {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        NormalDistribution unitNormal = new NormalDistribution(0.0, 1.0);
        Assert.assertEquals((double)0.3172069207622391, (double)test.kolmogorovSmirnovTest((RealDistribution)unitNormal, gaussian, false), (double)1.0E-9);
        Assert.assertFalse((boolean)test.kolmogorovSmirnovTest((RealDistribution)unitNormal, gaussian, 0.05));
        Assert.assertEquals((double)0.0932947561266756, (double)test.kolmogorovSmirnovStatistic((RealDistribution)unitNormal, gaussian), (double)1.0E-9);
    }

    @Test
    public void testOneSampleGaussianGaussianSmallSample() {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        NormalDistribution unitNormal = new NormalDistribution(0.0, 1.0);
        double[] shortGaussian = new double[50];
        System.arraycopy(gaussian, 0, shortGaussian, 0, 50);
        Assert.assertEquals((double)0.683736463728347, (double)test.kolmogorovSmirnovTest((RealDistribution)unitNormal, shortGaussian, false), (double)1.0E-9);
        Assert.assertFalse((boolean)test.kolmogorovSmirnovTest((RealDistribution)unitNormal, gaussian, 0.05));
        Assert.assertEquals((double)0.09820779969463278, (double)test.kolmogorovSmirnovStatistic((RealDistribution)unitNormal, shortGaussian), (double)1.0E-9);
    }

    @Test
    public void testOneSampleGaussianUniform() {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        NormalDistribution unitNormal = new NormalDistribution(0.0, 1.0);
        Assert.assertEquals((double)8.881784197001252E-16, (double)test.kolmogorovSmirnovTest((RealDistribution)unitNormal, uniform, false), (double)1.0E-9);
        Assert.assertFalse((boolean)test.kolmogorovSmirnovTest((RealDistribution)unitNormal, gaussian, 0.05));
        Assert.assertEquals((double)0.5117493931609258, (double)test.kolmogorovSmirnovStatistic((RealDistribution)unitNormal, uniform), (double)1.0E-9);
    }

    public void testOneSampleUniformUniform() {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        UniformRealDistribution unif = new UniformRealDistribution(-0.5, 0.5);
        Assert.assertEquals((double)8.881784197001252E-16, (double)test.kolmogorovSmirnovTest((RealDistribution)unif, uniform, false), (double)1.0E-9);
        Assert.assertTrue((boolean)test.kolmogorovSmirnovTest((RealDistribution)unif, uniform, 0.05));
        Assert.assertEquals((double)0.5400666982352942, (double)test.kolmogorovSmirnovStatistic((RealDistribution)unif, uniform), (double)1.0E-9);
    }

    @Test
    public void testOneSampleUniformUniformSmallSample() {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        UniformRealDistribution unif = new UniformRealDistribution(-0.5, 0.5);
        double[] shortUniform = new double[20];
        System.arraycopy(uniform, 0, shortUniform, 0, 20);
        Assert.assertEquals((double)4.117594598618268E-9, (double)test.kolmogorovSmirnovTest((RealDistribution)unif, shortUniform, false), (double)1.0E-9);
        Assert.assertTrue((boolean)test.kolmogorovSmirnovTest((RealDistribution)unif, shortUniform, 0.05));
        Assert.assertEquals((double)0.6610459, (double)test.kolmogorovSmirnovStatistic((RealDistribution)unif, shortUniform), (double)1.0E-9);
    }

    @Test
    public void testOneSampleUniformGaussian() {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        UniformRealDistribution unif = new UniformRealDistribution(-0.5, 0.5);
        Assert.assertEquals((double)4.9405812774239166E-11, (double)test.kolmogorovSmirnovTest((RealDistribution)unif, gaussian, false), (double)1.0E-9);
        Assert.assertTrue((boolean)test.kolmogorovSmirnovTest((RealDistribution)unif, gaussian, 0.05));
        Assert.assertEquals((double)0.3401058049019608, (double)test.kolmogorovSmirnovStatistic((RealDistribution)unif, gaussian), (double)1.0E-9);
    }

    @Test
    public void testTwoSampleSmallSampleExact() {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        double[] smallSample1 = new double[]{6.0, 7.0, 9.0, 13.0, 19.0, 21.0, 22.0, 23.0, 24.0};
        double[] smallSample2 = new double[]{10.0, 11.0, 12.0, 16.0, 20.0, 27.0, 28.0, 32.0, 44.0, 54.0};
        Assert.assertEquals((double)0.105577085453247, (double)test.kolmogorovSmirnovTest(smallSample1, smallSample2, false), (double)1.0E-9);
        Assert.assertEquals((double)0.5, (double)test.kolmogorovSmirnovStatistic(smallSample1, smallSample2), (double)1.0E-9);
    }

    @Test
    public void testTwoSampleSmallSampleExact2() {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        double[] smallSample1 = new double[]{6.0, 7.0, 9.0, 13.0, 19.0, 21.0, 22.0, 23.0, 24.0, 29.0, 30.0, 34.0, 36.0, 41.0, 45.0, 47.0, 51.0, 63.0, 33.0, 91.0};
        double[] smallSample2 = new double[]{10.0, 11.0, 12.0, 16.0, 20.0, 27.0, 28.0, 32.0, 44.0, 54.0, 56.0, 57.0, 64.0, 69.0, 71.0, 80.0, 81.0, 88.0, 90.0};
        Assert.assertEquals((double)0.0462986609, (double)test.kolmogorovSmirnovTest(smallSample1, smallSample2, false), (double)1.0E-9);
        Assert.assertEquals((double)0.4263157895, (double)test.kolmogorovSmirnovStatistic(smallSample1, smallSample2), (double)1.0E-9);
    }

    @Test
    public void testTwoSampleSmallSampleExact3() {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        double[] smallSample1 = new double[]{-10.0, -5.0, 17.0, 21.0, 22.0, 23.0, 24.0, 30.0, 44.0, 50.0, 56.0, 57.0, 59.0, 67.0, 73.0, 75.0, 77.0, 78.0, 79.0, 80.0, 81.0, 83.0, 84.0, 85.0, 88.0, 90.0, 92.0, 93.0, 94.0, 95.0, 98.0, 100.0, 101.0, 103.0, 105.0, 110.0};
        double[] smallSample2 = new double[]{-2.0, -1.0, 0.0, 10.0, 14.0, 15.0, 16.0, 20.0, 25.0, 26.0, 27.0, 31.0, 32.0, 33.0, 34.0, 45.0, 47.0, 48.0, 51.0, 52.0, 53.0, 54.0, 60.0, 61.0, 62.0, 63.0, 74.0, 82.0, 106.0, 107.0, 109.0, 11.0, 112.0, 113.0, 114.0};
        Assert.assertEquals((double)0.00300743602, (double)test.kolmogorovSmirnovTest(smallSample1, smallSample2, false), (double)1.0E-9);
        Assert.assertEquals((double)0.4103174603, (double)test.kolmogorovSmirnovStatistic(smallSample1, smallSample2), (double)1.0E-9);
        Assert.assertEquals((double)0.00300743602, (double)test.kolmogorovSmirnovTest(smallSample2, smallSample1, false), (double)1.0E-9);
    }

    @Test
    public void testTwoSampleExactP() {
        this.checkExactTable(4, 6, 0.8333333333333334, 0.01);
        this.checkExactTable(4, 7, 0.6071428571428571, 0.2);
        this.checkExactTable(6, 7, 0.6904761904761905, 0.05);
        this.checkExactTable(4, 10, 0.7, 0.05);
        this.checkExactTable(5, 15, 0.7333333333333333, 0.02);
        this.checkExactTable(9, 10, 0.6888888888888889, 0.01);
        this.checkExactTable(7, 10, 0.6142857142857143, 0.05);
    }

    @Test
    public void testTwoSampleApproximateCritialValues() {
        double tol = 0.01;
        double[] alpha = new double[]{0.1, 0.05, 0.025, 0.01, 0.005, 0.001};
        double[] c = new double[]{1.22, 1.36, 1.48, 1.63, 1.73, 1.95};
        int[] k = new int[]{60, 100, 500};
        for (int i = 0; i < k.length; ++i) {
            for (int j = 0; j < i; ++j) {
                double n = k[i];
                double m = k[j];
                for (int l = 0; l < alpha.length; ++l) {
                    double dCrit = c[l] * FastMath.sqrt((double)((n + m) / (n * m)));
                    this.checkApproximateTable(k[i], k[j], dCrit, alpha[l], 0.01);
                }
            }
        }
    }

    @Test
    public void testPelzGoodApproximation() {
        KolmogorovSmirnovTest ksTest = new KolmogorovSmirnovTest();
        double[] d = new double[]{0.15, 0.2, 0.25, 0.3, 0.35, 0.4};
        int[] n = new int[]{141, 150, 180, 220, 1000};
        double[] ref = new double[]{0.9968940168727819, 0.9979326624184857, 0.9994677598604506, 0.9999128354780209, 0.9999999999998661, 0.9999797514476236, 0.9999902122242081, 0.9999991327060908, 0.9999999657681911, 0.9999999999977929, 0.9999999706444976, 0.9999999906571532, 0.9999999997949596, 0.999999999998745, 0.9999999999993876, 0.9999999999916627, 0.9999999999984447, 0.9999999999999936, 0.999999999999341, 0.9999999999971508, 0.9999999999999877, 0.9999999999999191, 0.9999999999999254, 0.9999999999998178, 0.9999999999917788, 0.9999999999998556, 0.9999999999992014, 0.9999999999988859, 0.9999999999999325, 0.9999999999821726};
        double tol = 1.0E-14;
        int k = 0;
        for (int i = 0; i < 6; ++i) {
            int j = 0;
            while (j < 5) {
                Assert.assertEquals((double)ref[k], (double)ksTest.pelzGood(d[i], n[j]), (double)1.0E-14);
                ++j;
                ++k;
            }
        }
    }

    @Test
    public void testTwoSampleApproximateP() {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        Assert.assertEquals((double)0.0319983962391632, (double)test.kolmogorovSmirnovTest(gaussian, gaussian2), (double)1.0E-9);
        Assert.assertEquals((double)0.202352941176471, (double)test.kolmogorovSmirnovStatistic(gaussian, gaussian2), (double)1.0E-9);
    }

    @Test(timeout=5000L)
    public void testTwoSampleProductSizeOverflow() {
        int n = 50000;
        Assert.assertTrue((boolean)true);
        double[] x = new double[50000];
        double[] y = new double[50000];
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        Assert.assertFalse((boolean)Double.isNaN(test.kolmogorovSmirnovTest(x, y)));
    }

    @Test
    public void testTwoSampleMonteCarlo() {
        double[] d;
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest((RandomGenerator)new Well19937c(1000));
        int sampleSize = 14;
        double tol = 0.001;
        double[] shortUniform = new double[14];
        System.arraycopy(uniform, 0, shortUniform, 0, 14);
        double[] shortGaussian = new double[14];
        double[] shortGaussian2 = new double[14];
        System.arraycopy(gaussian, 0, shortGaussian, 0, 14);
        System.arraycopy(gaussian, 10, shortGaussian2, 0, 14);
        for (double dv : d = new double[]{test.kolmogorovSmirnovStatistic(shortGaussian, shortUniform), test.kolmogorovSmirnovStatistic(shortGaussian2, shortGaussian)}) {
            double exactPStrict = test.exactP(dv, 14, 14, true);
            double exactPNonStrict = test.exactP(dv, 14, 14, false);
            double montePStrict = test.monteCarloP(dv, 14, 14, true, 1000000);
            double montePNonStrict = test.monteCarloP(dv, 14, 14, false, 1000000);
            Assert.assertEquals((double)exactPStrict, (double)montePStrict, (double)0.001);
            Assert.assertEquals((double)exactPNonStrict, (double)montePNonStrict, (double)0.001);
        }
    }

    @Test
    public void testTwoSampleMonteCarloDifferentSampleSizes() {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest((RandomGenerator)new Well19937c(1000));
        int sampleSize1 = 14;
        int sampleSize2 = 7;
        double d = 0.3;
        boolean strict = false;
        double tol = 0.01;
        Assert.assertEquals((double)test.exactP(0.3, 14, 7, false), (double)test.monteCarloP(0.3, 14, 7, false, 1000000), (double)0.01);
    }

    public void testTwoSampleMonteCarloPerformance() {
        int numIterations = 100000;
        int N = (int)Math.sqrt(10000.0);
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest((RandomGenerator)new Well19937c(1000));
        for (int n = 2; n <= N; ++n) {
            long startMillis = System.currentTimeMillis();
            int m = 10000 / n;
            Assert.assertEquals((double)0.0, (double)test.monteCarloP(Double.POSITIVE_INFINITY, n, m, true, numIterations), (double)0.0);
            long endMillis = System.currentTimeMillis();
            System.out.println("n=" + n + ", m=" + m + ", time=" + (double)(endMillis - startMillis) / 1000.0 + "s");
        }
    }

    @Test
    public void testTwoSampleWithManyTies() {
        double[] x = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 3.181199, 3.181199, 3.181199, 3.181199, 3.181199, 3.181199, 3.723539, 3.723539, 3.723539, 3.723539, 4.383482, 4.383482, 4.383482, 4.383482, 5.320671, 5.320671, 5.320671, 5.717284, 6.964001, 7.352165, 8.71051, 8.71051, 8.71051, 8.71051, 8.71051, 8.71051, 9.539004, 9.539004, 10.720619, 17.726077, 17.726077, 17.726077, 17.726077, 22.053875, 23.799144, 27.355308, 30.58496, 30.58496, 30.58496, 30.58496, 30.751808};
        double[] y = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 2.202653, 3.061758, 3.723539, 5.62842, 5.62842, 5.62842, 5.62842, 5.62842, 6.916982, 6.916982, 6.916982, 10.178538, 10.178538, 10.178538, 10.178538, 10.178538};
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        Assert.assertEquals((double)0.0640394088, (double)test.kolmogorovSmirnovStatistic(x, y), (double)1.0E-6);
        Assert.assertEquals((double)0.979277729, (double)test.kolmogorovSmirnovTest(x, y), (double)1.0E-6);
    }

    @Test
    public void testTwoSamplesAllEqual() {
        int iterations = 10000;
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        for (int i = 2; i < 30; ++i) {
            double[] values = new double[i];
            Arrays.fill(values, (double)i);
            double[] ascendingValues = new double[i];
            for (int j = 0; j < ascendingValues.length; ++j) {
                ascendingValues[j] = j;
            }
            Assert.assertEquals((double)0.0, (double)test.kolmogorovSmirnovStatistic(values, values), (double)0.0);
            Assert.assertEquals((double)0.0, (double)test.kolmogorovSmirnovStatistic(ascendingValues, ascendingValues), (double)0.0);
            if (i < 10) {
                Assert.assertEquals((double)1.0, (double)test.exactP(0.0, values.length, values.length, true), (double)0.0);
                Assert.assertEquals((double)1.0, (double)test.exactP(0.0, values.length, values.length, false), (double)0.0);
            }
            Assert.assertEquals((double)1.0, (double)test.monteCarloP(0.0, values.length, values.length, true, iterations), (double)0.0);
            Assert.assertEquals((double)1.0, (double)test.monteCarloP(0.0, values.length, values.length, false, iterations), (double)0.0);
            Assert.assertEquals((double)1.0, (double)test.approximateP(0.0, values.length, values.length), (double)0.0);
            Assert.assertEquals((double)1.0, (double)test.approximateP(0.0, values.length, values.length), (double)0.0);
        }
    }

    @Test
    public void testDRounding() {
        double tol = 1.0E-12;
        double[] x = new double[]{0.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 12.0};
        double[] y = new double[]{1.0, 10.0, 11.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0};
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        Assert.assertEquals((double)0.0027495724090154106, (double)test.kolmogorovSmirnovTest(x, y, false), (double)1.0E-12);
        double[] x1 = new double[]{2.0, 4.0, 6.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0};
        double[] y1 = new double[]{0.0, 1.0, 3.0, 5.0, 7.0};
        Assert.assertEquals((double)0.08591408591408589, (double)test.kolmogorovSmirnovTest(x1, y1, false), (double)1.0E-12);
        double[] x2 = new double[]{4.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        double[] y2 = new double[]{0.0, 1.0, 2.0, 3.0, 5.0};
        Assert.assertEquals((double)0.015151515151515027, (double)test.kolmogorovSmirnovTest(x2, y2, false), (double)1.0E-12);
    }

    @Test
    public void testDRoundingMonteCarlo() {
        double tol = 0.01;
        int iterations = 1000000;
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest((RandomGenerator)new Well19937c(1000));
        double[] x = new double[]{0.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 12.0};
        double[] y = new double[]{1.0, 10.0, 11.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0};
        double d = test.kolmogorovSmirnovStatistic(x, y);
        Assert.assertEquals((double)0.0027495724090154106, (double)test.monteCarloP(d, x.length, y.length, false, 1000000), (double)0.01);
        double[] x1 = new double[]{2.0, 4.0, 6.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0};
        double[] y1 = new double[]{0.0, 1.0, 3.0, 5.0, 7.0};
        d = test.kolmogorovSmirnovStatistic(x1, y1);
        Assert.assertEquals((double)0.08591408591408589, (double)test.monteCarloP(d, x1.length, y1.length, false, 1000000), (double)0.01);
        double[] x2 = new double[]{4.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        double[] y2 = new double[]{0.0, 1.0, 2.0, 3.0, 5.0};
        d = test.kolmogorovSmirnovStatistic(x2, y2);
        Assert.assertEquals((double)0.015151515151515027, (double)test.monteCarloP(d, x2.length, y2.length, false, 1000000), (double)0.01);
    }

    @Test
    public void testFillBooleanArrayRandomlyWithFixedNumberTrueValues() {
        int[][] parameters = new int[][]{{5, 1}, {5, 2}, {5, 3}, {5, 4}, {8, 1}, {8, 2}, {8, 3}, {8, 4}, {8, 5}, {8, 6}, {8, 7}};
        double alpha = 0.001;
        int numIterations = 1000000;
        Well19937c rng = new Well19937c(0);
        for (int[] parameter : parameters) {
            int arraySize = parameter[0];
            int numberOfTrueValues = parameter[1];
            boolean[] b = new boolean[arraySize];
            long[] counts = new long[1 << arraySize];
            for (int i = 0; i < 1000000; ++i) {
                KolmogorovSmirnovTest.fillBooleanArrayRandomlyWithFixedNumberTrueValues((boolean[])b, (int)numberOfTrueValues, (RandomGenerator)rng);
                int x = 0;
                for (int j = 0; j < arraySize; ++j) {
                    x = x << 1 | (b[j] ? 1 : 0);
                }
                int n = x;
                counts[n] = counts[n] + 1L;
            }
            int numCombinations = (int)CombinatoricsUtils.binomialCoefficient((int)arraySize, (int)numberOfTrueValues);
            long[] observed = new long[numCombinations];
            double[] expected = new double[numCombinations];
            Arrays.fill(expected, 1000000.0 / (double)numCombinations);
            int observedIdx = 0;
            for (int i = 0; i < 1 << arraySize; ++i) {
                if (Integer.bitCount(i) == numberOfTrueValues) {
                    observed[observedIdx] = counts[i];
                    ++observedIdx;
                    continue;
                }
                Assert.assertEquals((long)0L, (long)counts[i]);
            }
            Assert.assertEquals((long)numCombinations, (long)observedIdx);
            TestUtils.assertChiSquareAccept(expected, observed, 0.001);
        }
    }

    @Test
    public void testBootstrapSmallSamplesWithTies() {
        double[] x = new double[]{0.0, 2.0, 4.0, 6.0, 8.0, 8.0, 10.0, 15.0, 22.0, 30.0, 33.0, 36.0, 38.0};
        double[] y = new double[]{9.0, 17.0, 20.0, 33.0, 40.0, 51.0, 60.0, 60.0, 72.0, 90.0, 101.0};
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest((RandomGenerator)new Well19937c(2000));
        Assert.assertEquals((double)0.0059, (double)test.bootstrap(x, y, 10000, false), (double)0.001);
    }

    @Test
    public void testBootstrapLargeSamples() {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest((RandomGenerator)new Well19937c(1000));
        Assert.assertEquals((double)0.0237, (double)test.bootstrap(gaussian, gaussian2, 10000), (double)0.01);
    }

    @Test
    public void testBootstrapRounding() {
        double[] x = new double[]{2.0, 4.0, 6.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0};
        double[] y = new double[]{0.0, 1.0, 3.0, 5.0, 7.0};
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest((RandomGenerator)new Well19937c(1000));
        Assert.assertEquals((double)0.06303, (double)test.bootstrap(x, y, 10000, false), (double)0.01);
    }

    @Test
    public void testFixTiesNoOp() throws Exception {
        double[] x = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
        double[] y = new double[]{5.0, 6.0, 7.0, 8.0};
        double[] origX = MathArrays.copyOf((double[])x);
        double[] origY = MathArrays.copyOf((double[])y);
        KolmogorovSmirnovTestTest.fixTies(x, y);
        Assert.assertArrayEquals((double[])origX, (double[])x, (double)0.0);
        Assert.assertArrayEquals((double[])origY, (double[])y, (double)0.0);
    }

    @Test
    public void testFixTiesConsistency() throws Exception {
        double[] x = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 2.0};
        double[] y = new double[]{5.0, 6.0, 7.0, 8.0, 1.0, 2.0};
        double[] xP = MathArrays.copyOf((double[])x);
        double[] yP = MathArrays.copyOf((double[])y);
        this.checkFixTies(x, y);
        double[] fixedX = MathArrays.copyOf((double[])x);
        double[] fixedY = MathArrays.copyOf((double[])y);
        this.checkFixTies(xP, yP);
        Assert.assertArrayEquals((double[])fixedX, (double[])xP, (double)0.0);
        Assert.assertArrayEquals((double[])fixedY, (double[])yP, (double)0.0);
    }

    @Test
    public void testFixTies() throws Exception {
        this.checkFixTies(new double[]{0.0, 1.0, 1.0, 4.0, 0.0}, new double[]{0.0, 5.0, 0.5, 0.55, 7.0});
        this.checkFixTies(new double[]{1.0, 1.0, 1.0, 1.0, 1.0}, new double[]{1.0, 1.0});
        this.checkFixTies(new double[]{1.0, 2.0, 3.0}, new double[]{1.0});
        this.checkFixTies(new double[]{1.0, 1.0, 0.0, 1.0, 0.0}, new double[0]);
    }

    private void checkFixTies(double[] x, double[] y) throws Exception {
        double[] origCombined = MathArrays.concatenate((double[][])new double[][]{x, y});
        KolmogorovSmirnovTestTest.fixTies(x, y);
        Assert.assertFalse((boolean)KolmogorovSmirnovTestTest.hasTies(x, y));
        double[] combined = MathArrays.concatenate((double[][])new double[][]{x, y});
        for (int i = 0; i < combined.length; ++i) {
            for (int j = 0; j < i; ++j) {
                Assert.assertTrue((combined[i] != combined[j] ? 1 : 0) != 0);
                if (!(combined[i] < combined[j])) continue;
                Assert.assertTrue((origCombined[i] < origCombined[j] || origCombined[i] == origCombined[j] ? 1 : 0) != 0);
            }
        }
    }

    private void checkExactTable(int n, int m, double criticalValue, double alpha) {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        Assert.assertTrue((test.exactP(criticalValue, n, m, true) < alpha ? 1 : 0) != 0);
        Assert.assertTrue((test.exactP(criticalValue, n, m, false) > alpha ? 1 : 0) != 0);
    }

    private void checkApproximateTable(int n, int m, double criticalValue, double alpha, double epsilon) {
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        Assert.assertEquals((double)alpha, (double)test.approximateP(criticalValue, n, m), (double)epsilon);
    }

    private static void fixTies(double[] x, double[] y) throws Exception {
        Method method = KolmogorovSmirnovTest.class.getDeclaredMethod("fixTies", double[].class, double[].class);
        method.setAccessible(true);
        method.invoke(KolmogorovSmirnovTest.class, x, y);
    }

    private static boolean hasTies(double[] x, double[] y) throws Exception {
        Method method = KolmogorovSmirnovTest.class.getDeclaredMethod("hasTies", double[].class, double[].class);
        method.setAccessible(true);
        return (Boolean)method.invoke(KolmogorovSmirnovTest.class, x, y);
    }
}

