/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.rank;

import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.UnivariateStatisticAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.rank.Median;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.rank.Percentile;
import com.hazelcast.shaded.org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MedianTest
extends UnivariateStatisticAbstractTest {
    protected Median stat;
    protected Percentile.EstimationType estimationType = Percentile.EstimationType.LEGACY;

    public UnivariateStatistic getUnivariateStatistic() {
        return new Median();
    }

    private Median getTestMedian(Percentile.EstimationType type) {
        NaNStrategy strategy = type == Percentile.EstimationType.LEGACY ? NaNStrategy.FIXED : NaNStrategy.REMOVED;
        return new Median().withEstimationType(type).withNaNStrategy(strategy);
    }

    public double expectedValue() {
        return this.median;
    }

    @Before
    public void before() {
        this.estimationType = Percentile.EstimationType.LEGACY;
    }

    @Test
    public void testAllTechniquesSingleton() {
        double[] singletonArray = new double[]{1.0};
        for (Percentile.EstimationType e : Percentile.EstimationType.values()) {
            Median percentile = this.getTestMedian(e);
            Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray), (double)0.0);
            Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray, 0, 1), (double)0.0);
            Assert.assertEquals((double)1.0, (double)new Median().evaluate(singletonArray, 0, 1, 5.0), (double)0.0);
            Assert.assertEquals((double)1.0, (double)new Median().evaluate(singletonArray, 0, 1, 100.0), (double)0.0);
            Assert.assertTrue((boolean)Double.isNaN(percentile.evaluate(singletonArray, 0, 0)));
        }
    }

    @Test
    public void testAllTechniquesMedian() {
        double[] d = new double[]{1.0, 3.0, 2.0, 4.0};
        this.testAssertMappedValues(d, new Object[][]{{Percentile.EstimationType.LEGACY, 2.5}, {Percentile.EstimationType.R_1, 2.0}, {Percentile.EstimationType.R_2, 2.5}, {Percentile.EstimationType.R_3, 2.0}, {Percentile.EstimationType.R_4, 2.0}, {Percentile.EstimationType.R_5, 2.5}, {Percentile.EstimationType.R_6, 2.5}, {Percentile.EstimationType.R_7, 2.5}, {Percentile.EstimationType.R_8, 2.5}, {Percentile.EstimationType.R_9, 2.5}}, 1.0E-5);
    }

    protected void testAssertMappedValues(double[] d, Object[][] map, Double tolerance) {
        for (Object[] o : map) {
            Percentile.EstimationType e = (Percentile.EstimationType)o[0];
            double expected = (Double)o[1];
            double result = this.getTestMedian(e).evaluate(d);
            Assert.assertEquals((String)("expected[" + e + "] = " + expected + " but was = " + result), (double)expected, (double)result, (double)tolerance);
        }
    }
}

