/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment;

import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.FirstMoment;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.FourthMoment;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.Kurtosis;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.Mean;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.SecondMoment;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.Skewness;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.ThirdMoment;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.junit.Assert;
import org.junit.Test;

public class InteractionTest {
    protected double mean = 12.4045454545455;
    protected double var = 10.0023593073593;
    protected double skew = 1.43742372919619;
    protected double kurt = 2.3771912648047;
    protected double tolerance = 1.0E-11;
    protected double[] testArray = new double[]{12.5, 12.0, 11.8, 14.2, 14.9, 14.5, 21.0, 8.2, 10.3, 11.3, 14.1, 9.9, 12.2, 12.0, 12.1, 11.0, 19.8, 11.0, 10.0, 8.8, 9.0, 12.3};

    @Test
    public void testInteraction() {
        FourthMoment m4 = new FourthMoment();
        Mean m = new Mean((FirstMoment)m4);
        Variance v = new Variance((SecondMoment)m4);
        Skewness s = new Skewness((ThirdMoment)m4);
        Kurtosis k = new Kurtosis(m4);
        for (int i = 0; i < this.testArray.length; ++i) {
            m4.increment(this.testArray[i]);
        }
        Assert.assertEquals((double)this.mean, (double)m.getResult(), (double)this.tolerance);
        Assert.assertEquals((double)this.var, (double)v.getResult(), (double)this.tolerance);
        Assert.assertEquals((double)this.skew, (double)s.getResult(), (double)this.tolerance);
        Assert.assertEquals((double)this.kurt, (double)k.getResult(), (double)this.tolerance);
    }
}

