/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.StatisticalSummaryValues;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public final class StatisticalSummaryValuesTest {
    @Test
    public void testSerialization() {
        StatisticalSummaryValues u = new StatisticalSummaryValues(1.0, 2.0, 3L, 4.0, 5.0, 6.0);
        TestUtils.checkSerializedEquality(u);
        StatisticalSummaryValues t = (StatisticalSummaryValues)TestUtils.serializeAndRecover(u);
        this.verifyEquality(u, t);
    }

    @Test
    public void testEqualsAndHashCode() {
        StatisticalSummaryValues u = new StatisticalSummaryValues(1.0, 2.0, 3L, 4.0, 5.0, 6.0);
        StatisticalSummaryValues t = null;
        Assert.assertTrue((String)"reflexive", (boolean)u.equals((Object)u));
        Assert.assertFalse((String)"non-null compared to null", (boolean)u.equals(t));
        Assert.assertFalse((String)"wrong type", (boolean)u.equals((Object)0.0));
        t = new StatisticalSummaryValues(1.0, 2.0, 3L, 4.0, 5.0, 6.0);
        Assert.assertTrue((String)"instances with same data should be equal", (boolean)t.equals((Object)u));
        Assert.assertEquals((String)"hash code", (long)u.hashCode(), (long)t.hashCode());
        u = new StatisticalSummaryValues(Double.NaN, 2.0, 3L, 4.0, 5.0, 6.0);
        t = new StatisticalSummaryValues(1.0, Double.NaN, 3L, 4.0, 5.0, 6.0);
        Assert.assertFalse((String)"instances based on different data should be different", (u.equals((Object)t) || t.equals((Object)u) ? 1 : 0) != 0);
    }

    private void verifyEquality(StatisticalSummaryValues s, StatisticalSummaryValues u) {
        Assert.assertEquals((String)"N", (long)s.getN(), (long)u.getN());
        TestUtils.assertEquals("sum", s.getSum(), u.getSum(), 0.0);
        TestUtils.assertEquals("var", s.getVariance(), u.getVariance(), 0.0);
        TestUtils.assertEquals("std", s.getStandardDeviation(), u.getStandardDeviation(), 0.0);
        TestUtils.assertEquals("mean", s.getMean(), u.getMean(), 0.0);
        TestUtils.assertEquals("min", s.getMin(), u.getMin(), 0.0);
        TestUtils.assertEquals("max", s.getMax(), u.getMax(), 0.0);
    }

    @Test
    public void testToString() {
        StatisticalSummaryValues u = new StatisticalSummaryValues(4.5, 16.0, 10L, 5.0, 4.0, 45.0);
        Locale d = Locale.getDefault();
        Locale.setDefault(Locale.US);
        Assert.assertEquals((Object)"StatisticalSummaryValues:\nn: 10\nmin: 4.0\nmax: 5.0\nmean: 4.5\nstd dev: 4.0\nvariance: 16.0\nsum: 45.0\n", (Object)u.toString());
        Locale.setDefault(d);
    }
}

