/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optimization.fitting;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.HarmonicOscillator;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalStateException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.DifferentiableMultivariateVectorOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.fitting.HarmonicFitter;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.fitting.WeightedObservedPoint;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.general.LevenbergMarquardtOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathUtils;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class HarmonicFitterTest {
    @Test(expected=NumberIsTooSmallException.class)
    public void testPreconditions1() {
        HarmonicFitter fitter = new HarmonicFitter((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
        fitter.fit();
    }

    @Test
    public void testNoError() {
        double a = 0.2;
        double w = 3.4;
        double p = 4.1;
        HarmonicOscillator f = new HarmonicOscillator(0.2, 3.4, 4.1);
        HarmonicFitter fitter = new HarmonicFitter((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
        for (double x = 0.0; x < 1.3; x += 0.01) {
            fitter.addObservedPoint(1.0, x, f.value(x));
        }
        double[] fitted = fitter.fit();
        Assert.assertEquals((double)0.2, (double)fitted[0], (double)1.0E-13);
        Assert.assertEquals((double)3.4, (double)fitted[1], (double)1.0E-13);
        Assert.assertEquals((double)4.1, (double)MathUtils.normalizeAngle((double)fitted[2], (double)4.1), (double)1.0E-13);
        HarmonicOscillator ff = new HarmonicOscillator(fitted[0], fitted[1], fitted[2]);
        for (double x = -1.0; x < 1.0; x += 0.01) {
            Assert.assertTrue((FastMath.abs((double)(f.value(x) - ff.value(x))) < 1.0E-13 ? 1 : 0) != 0);
        }
    }

    @Test
    public void test1PercentError() {
        Random randomizer = new Random(64925784252L);
        double a = 0.2;
        double w = 3.4;
        double p = 4.1;
        HarmonicOscillator f = new HarmonicOscillator(0.2, 3.4, 4.1);
        HarmonicFitter fitter = new HarmonicFitter((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
        for (double x = 0.0; x < 10.0; x += 0.1) {
            fitter.addObservedPoint(1.0, x, f.value(x) + 0.01 * randomizer.nextGaussian());
        }
        double[] fitted = fitter.fit();
        Assert.assertEquals((double)0.2, (double)fitted[0], (double)7.6E-4);
        Assert.assertEquals((double)3.4, (double)fitted[1], (double)0.0027);
        Assert.assertEquals((double)4.1, (double)MathUtils.normalizeAngle((double)fitted[2], (double)4.1), (double)0.013);
    }

    @Test
    public void testTinyVariationsData() {
        Random randomizer = new Random(64925784252L);
        HarmonicFitter fitter = new HarmonicFitter((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
        for (double x = 0.0; x < 10.0; x += 0.1) {
            fitter.addObservedPoint(1.0, x, 1.0E-7 * randomizer.nextGaussian());
        }
        fitter.fit();
    }

    @Test
    public void testInitialGuess() {
        Random randomizer = new Random(45314242L);
        double a = 0.2;
        double w = 3.4;
        double p = 4.1;
        HarmonicOscillator f = new HarmonicOscillator(0.2, 3.4, 4.1);
        HarmonicFitter fitter = new HarmonicFitter((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
        for (double x = 0.0; x < 10.0; x += 0.1) {
            fitter.addObservedPoint(1.0, x, f.value(x) + 0.01 * randomizer.nextGaussian());
        }
        double[] fitted = fitter.fit(new double[]{0.15, 3.6, 4.5});
        Assert.assertEquals((double)0.2, (double)fitted[0], (double)0.0012);
        Assert.assertEquals((double)3.4, (double)fitted[1], (double)0.0033);
        Assert.assertEquals((double)4.1, (double)MathUtils.normalizeAngle((double)fitted[2], (double)4.1), (double)0.017);
    }

    @Test
    public void testUnsorted() {
        int i;
        Random randomizer = new Random(64925784252L);
        double a = 0.2;
        double w = 3.4;
        double p = 4.1;
        HarmonicOscillator f = new HarmonicOscillator(0.2, 3.4, 4.1);
        HarmonicFitter fitter = new HarmonicFitter((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
        int size = 100;
        double[] xTab = new double[size];
        double[] yTab = new double[size];
        for (i = 0; i < size; ++i) {
            xTab[i] = 0.1 * (double)i;
            yTab[i] = f.value(xTab[i]) + 0.01 * randomizer.nextGaussian();
        }
        for (i = 0; i < size; ++i) {
            int i1 = randomizer.nextInt(size);
            int i2 = randomizer.nextInt(size);
            double xTmp = xTab[i1];
            double yTmp = yTab[i1];
            xTab[i1] = xTab[i2];
            yTab[i1] = yTab[i2];
            xTab[i2] = xTmp;
            yTab[i2] = yTmp;
        }
        for (i = 0; i < size; ++i) {
            fitter.addObservedPoint(1.0, xTab[i], yTab[i]);
        }
        double[] fitted = fitter.fit();
        Assert.assertEquals((double)0.2, (double)fitted[0], (double)7.6E-4);
        Assert.assertEquals((double)3.4, (double)fitted[1], (double)0.0035);
        Assert.assertEquals((double)4.1, (double)MathUtils.normalizeAngle((double)fitted[2], (double)4.1), (double)0.015);
    }

    @Test(expected=MathIllegalStateException.class)
    public void testMath844() {
        double[] y = new double[]{0.0, 1.0, 2.0, 3.0, 2.0, 1.0, 0.0, -1.0, -2.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 2.0, 1.0, 0.0, -1.0, -2.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 2.0, 1.0, 0.0};
        int len = y.length;
        WeightedObservedPoint[] points = new WeightedObservedPoint[len];
        for (int i = 0; i < len; ++i) {
            points[i] = new WeightedObservedPoint(1.0, (double)i, y[i]);
        }
        new HarmonicFitter.ParameterGuesser(points);
    }
}

