/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff;

import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.ODEIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem1;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem2;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem3;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem4;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem5;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem6;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblemAbstract;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblemHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.EventHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.EulerIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class EulerIntegratorTest {
    @Test(expected=DimensionMismatchException.class)
    public void testDimensionCheck() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        new EulerIntegrator(0.01).integrate((FirstOrderDifferentialEquations)pb, 0.0, new double[pb.getDimension() + 10], 1.0, new double[pb.getDimension() + 10]);
        Assert.fail((String)"an exception should have been thrown");
    }

    @Test
    public void testDecreasingSteps() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        for (TestProblemAbstract pb : new TestProblemAbstract[]{new TestProblem1(), new TestProblem2(), new TestProblem3(), new TestProblem4(), new TestProblem5(), new TestProblem6()}) {
            double previousValueError = Double.NaN;
            double previousTimeError = Double.NaN;
            for (int i = 4; i < 8; ++i) {
                double step = (pb.getFinalTime() - pb.getInitialTime()) * FastMath.pow((double)2.0, (int)(-i));
                EulerIntegrator integ = new EulerIntegrator(step);
                TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
                integ.addStepHandler((StepHandler)handler);
                EventHandler[] functions = pb.getEventsHandlers();
                for (int l = 0; l < functions.length; ++l) {
                    integ.addEventHandler(functions[l], Double.POSITIVE_INFINITY, 1.0E-6 * step, 1000);
                }
                double stopTime = integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
                if (functions.length == 0) {
                    Assert.assertEquals((double)pb.getFinalTime(), (double)stopTime, (double)1.0E-10);
                }
                double valueError = handler.getMaximalValueError();
                if (i > 4) {
                    Assert.assertTrue((valueError < FastMath.abs((double)previousValueError) ? 1 : 0) != 0);
                }
                previousValueError = valueError;
                double timeError = handler.getMaximalTimeError();
                if (i > 4) {
                    Assert.assertTrue((timeError <= FastMath.abs((double)previousTimeError) ? 1 : 0) != 0);
                }
                previousTimeError = timeError;
            }
        }
    }

    @Test
    public void testSmallStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        double step = (pb.getFinalTime() - pb.getInitialTime()) * 0.001;
        EulerIntegrator integ = new EulerIntegrator(step);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getLastError() < 2.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError() < 0.001 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
        Assert.assertEquals((Object)"Euler", (Object)integ.getName());
    }

    @Test
    public void testBigStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        double step = (pb.getFinalTime() - pb.getInitialTime()) * 0.2;
        EulerIntegrator integ = new EulerIntegrator(step);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getLastError() > 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError() > 0.2 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
    }

    @Test
    public void testBackward() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem5 pb = new TestProblem5();
        double step = FastMath.abs((double)(pb.getFinalTime() - pb.getInitialTime())) * 0.001;
        EulerIntegrator integ = new EulerIntegrator(step);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getLastError() < 0.45 ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError() < 0.45 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
        Assert.assertEquals((Object)"Euler", (Object)integ.getName());
    }

    @Test
    public void testStepSize() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double step = 1.23456;
        EulerIntegrator integ = new EulerIntegrator(1.23456);
        integ.addStepHandler(new StepHandler(){

            public void handleStep(StepInterpolator interpolator, boolean isLast) {
                if (!isLast) {
                    Assert.assertEquals((double)1.23456, (double)(interpolator.getCurrentTime() - interpolator.getPreviousTime()), (double)1.0E-12);
                }
            }

            public void init(double t0, double[] y0, double t) {
            }
        });
        integ.integrate(new FirstOrderDifferentialEquations(){

            public void computeDerivatives(double t, double[] y, double[] dot) {
                dot[0] = 1.0;
            }

            public int getDimension() {
                return 1;
            }
        }, 0.0, new double[]{0.0}, 5.0, new double[1]);
    }
}

