/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.RealFieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FieldODEState;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderFieldDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.FieldEventHandler;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathArrays;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestFieldProblemAbstract<T extends RealFieldElement<T>>
implements FirstOrderFieldDifferentialEquations<T> {
    private Field<T> field;
    private int n;
    private int calls;
    private T t0;
    private T[] y0;
    private T t1;
    private T[] errorScale;

    protected TestFieldProblemAbstract(Field<T> field) {
        this.field = field;
        this.n = 0;
        this.calls = 0;
        this.t0 = (RealFieldElement)field.getZero();
        this.y0 = null;
        this.t1 = (RealFieldElement)field.getZero();
        this.errorScale = null;
    }

    protected void setInitialConditions(T t0, T[] y0) {
        this.calls = 0;
        this.n = y0.length;
        this.t0 = t0;
        this.y0 = (RealFieldElement[])y0.clone();
    }

    protected void setFinalConditions(T t1) {
        this.t1 = t1;
    }

    protected void setErrorScale(T[] errorScale) {
        this.errorScale = (RealFieldElement[])errorScale.clone();
    }

    public Field<T> getField() {
        return this.field;
    }

    public int getDimension() {
        return this.n;
    }

    public FieldODEState<T> getInitialState() {
        return new FieldODEState(this.t0, this.y0);
    }

    public T getFinalTime() {
        return this.t1;
    }

    public T[] getErrorScale() {
        return this.errorScale;
    }

    public FieldEventHandler<T>[] getEventsHandlers() {
        FieldEventHandler[] empty = (FieldEventHandler[])Array.newInstance(FieldEventHandler.class, 0);
        return empty;
    }

    public T[] getTheoreticalEventsTimes() {
        return (RealFieldElement[])MathArrays.buildArray(this.field, (int)0);
    }

    public int getCalls() {
        return this.calls;
    }

    public void init(T t0, T[] y0, T t) {
    }

    public T[] computeDerivatives(T t, T[] y) {
        ++this.calls;
        return this.doComputeDerivatives((RealFieldElement)t, (RealFieldElement[])y);
    }

    public abstract T[] doComputeDerivatives(T var1, T[] var2);

    public abstract T[] computeTheoreticalState(T var1);

    protected T convert(double d) {
        return (T)((RealFieldElement)((RealFieldElement)this.field.getZero()).add(d));
    }

    protected T[] convert(double ... elements) {
        RealFieldElement[] array = (RealFieldElement[])MathArrays.buildArray(this.field, (int)elements.length);
        for (int i = 0; i < elements.length; ++i) {
            array[i] = this.convert(elements[i]);
        }
        return array;
    }
}

