/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.RealFieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestFieldProblemAbstract;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFieldProblem2<T extends RealFieldElement<T>>
extends TestFieldProblemAbstract<T> {
    public TestFieldProblem2(Field<T> field) {
        super(field);
        this.setInitialConditions((RealFieldElement)this.convert(0.0), this.convert(new double[]{0.0}));
        this.setFinalConditions(this.convert(1.0));
        this.setErrorScale(this.convert(new double[]{1.0}));
    }

    @Override
    public T[] doComputeDerivatives(T t, T[] y) {
        RealFieldElement[] yDot = (RealFieldElement[])MathArrays.buildArray(this.getField(), (int)this.getDimension());
        for (int i = 0; i < this.getDimension(); ++i) {
            yDot[i] = (RealFieldElement)t.multiply(((RealFieldElement)t.multiply(t)).subtract(y[i]));
        }
        return yDot;
    }

    @Override
    public T[] computeTheoreticalState(T t) {
        RealFieldElement[] y = (RealFieldElement[])MathArrays.buildArray(this.getField(), (int)this.getDimension());
        RealFieldElement t2 = (RealFieldElement)t.multiply(t);
        RealFieldElement c = (RealFieldElement)t2.add(((RealFieldElement)((RealFieldElement)((RealFieldElement)t2.multiply(-0.5)).exp()).subtract(1.0)).multiply(2));
        for (int i = 0; i < this.getDimension(); ++i) {
            y[i] = c;
        }
        return y;
    }
}

