/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.FunctionUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Constant;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.HarmonicOscillator;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathUnsupportedOperationException;
import com.hazelcast.shaded.org.apache.commons.math3.ml.distance.DistanceMeasure;
import com.hazelcast.shaded.org.apache.commons.math3.ml.distance.EuclideanDistance;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.FeatureInitializer;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.FeatureInitializerFactory;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.Network;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.Neuron;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.oned.NeuronString;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.City;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.KohonenTrainingTask;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.KohonenUpdateAction;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.LearningFactorFunction;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.LearningFactorFunctionFactory;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.NeighbourhoodSizeFunction;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.NeighbourhoodSizeFunctionFactory;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well44497b;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TravellingSalesmanSolver {
    private static final long FIRST_NEURON_ID = 0L;
    private final RandomGenerator random;
    private final Set<City> cities = new HashSet<City>();
    private final Network net;
    private final DistanceMeasure distance = new EuclideanDistance();
    private final int numberOfNeurons;

    public TravellingSalesmanSolver(City[] cityList, double numNeuronsPerCity) {
        this(cityList, numNeuronsPerCity, new Well44497b().nextLong());
    }

    public TravellingSalesmanSolver(City[] cityList, double numNeuronsPerCity, long seed) {
        this.random = new Well44497b(seed);
        for (City city : cityList) {
            this.cities.add(city);
        }
        this.numberOfNeurons = (int)numNeuronsPerCity * this.cities.size();
        this.net = new NeuronString(this.numberOfNeurons, true, this.makeInitializers()).getNetwork();
    }

    public Runnable[] createParallelTasks(int numTasks, long numSamplesPerTask) {
        Runnable[] tasks = new Runnable[numTasks];
        LearningFactorFunction learning = LearningFactorFunctionFactory.exponentialDecay((double)0.2, (double)0.05, (long)(numSamplesPerTask / 2L));
        NeighbourhoodSizeFunction neighbourhood = NeighbourhoodSizeFunctionFactory.exponentialDecay((double)(0.5 * (double)this.numberOfNeurons), (double)(0.1 * (double)this.numberOfNeurons), (long)(numSamplesPerTask / 2L));
        for (int i = 0; i < numTasks; ++i) {
            KohonenUpdateAction action = new KohonenUpdateAction(this.distance, learning, neighbourhood);
            tasks[i] = new KohonenTrainingTask(this.net, this.createRandomIterator(numSamplesPerTask), action);
        }
        return tasks;
    }

    public Runnable createSequentialTask(long numSamples) {
        return this.createParallelTasks(1, numSamples)[0];
    }

    public double getUpdateRatio() {
        return TravellingSalesmanSolver.computeUpdateRatio(this.net);
    }

    private static double computeUpdateRatio(Network net) {
        long numAttempts = 0L;
        long numSuccesses = 0L;
        for (Neuron n : net) {
            numAttempts += n.getNumberOfAttemptedUpdates();
            numSuccesses += n.getNumberOfSuccessfulUpdates();
        }
        return (double)numSuccesses / (double)numAttempts;
    }

    private Iterator<double[]> createRandomIterator(final long numSamples) {
        final ArrayList<City> cityList = new ArrayList<City>();
        cityList.addAll(this.cities);
        return new Iterator<double[]>(){
            private long n = 0L;

            @Override
            public boolean hasNext() {
                return this.n < numSamples;
            }

            @Override
            public double[] next() {
                ++this.n;
                return ((City)cityList.get(TravellingSalesmanSolver.this.random.nextInt(cityList.size()))).getCoordinates();
            }

            @Override
            public void remove() {
                throw new MathUnsupportedOperationException();
            }
        };
    }

    private List<Neuron> getNeuronList() {
        ArrayList<Neuron> list = new ArrayList<Neuron>();
        Neuron current = this.net.getNeuron(0L);
        while (true) {
            list.add(current);
            Collection neighbours = this.net.getNeighbours(current, list);
            Iterator iter = neighbours.iterator();
            if (!iter.hasNext()) break;
            current = (Neuron)iter.next();
        }
        return list;
    }

    public List<double[]> getCoordinatesList() {
        ArrayList<double[]> coordinatesList = new ArrayList<double[]>();
        for (Neuron n : this.getNeuronList()) {
            coordinatesList.add(n.getFeatures());
        }
        return coordinatesList;
    }

    public City[] getCityList() {
        List<double[]> coord = this.getCoordinatesList();
        City[] cityList = new City[coord.size()];
        for (int i = 0; i < cityList.length; ++i) {
            double[] c = coord.get(i);
            cityList[i] = this.getClosestCity(c[0], c[1]);
        }
        return cityList;
    }

    public City getClosestCity(double x, double y) {
        City closest = null;
        double min = Double.POSITIVE_INFINITY;
        for (City c : this.cities) {
            double d = c.distance(x, y);
            if (!(d < min)) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    private static double[] barycentre(Set<City> cities) {
        double xB = 0.0;
        double yB = 0.0;
        int count = 0;
        for (City c : cities) {
            double[] coord = c.getCoordinates();
            xB += coord[0];
            yB += coord[1];
            ++count;
        }
        return new double[]{xB / (double)count, yB / (double)count};
    }

    private static double largestDistance(double x, double y, Set<City> cities) {
        double maxDist = 0.0;
        for (City c : cities) {
            double dist = c.distance(x, y);
            if (!(dist > maxDist)) continue;
            maxDist = dist;
        }
        return maxDist;
    }

    private FeatureInitializer[] makeInitializers() {
        double[] centre = TravellingSalesmanSolver.barycentre(this.cities);
        double radius = 0.5 * TravellingSalesmanSolver.largestDistance(centre[0], centre[1], this.cities);
        double omega = Math.PI * 2 / (double)this.numberOfNeurons;
        HarmonicOscillator h1 = new HarmonicOscillator(radius, omega, 0.0);
        HarmonicOscillator h2 = new HarmonicOscillator(radius, omega, 1.5707963267948966);
        UnivariateFunction f1 = FunctionUtils.add((UnivariateFunction[])new UnivariateFunction[]{h1, new Constant(centre[0])});
        UnivariateFunction f2 = FunctionUtils.add((UnivariateFunction[])new UnivariateFunction[]{h2, new Constant(centre[1])});
        UniformRealDistribution u = new UniformRealDistribution(this.random, -0.05 * radius, 0.05 * radius);
        return new FeatureInitializer[]{FeatureInitializerFactory.randomize((RealDistribution)u, (FeatureInitializer)FeatureInitializerFactory.function((UnivariateFunction)f1, (double)0.0, (double)1.0)), FeatureInitializerFactory.randomize((RealDistribution)u, (FeatureInitializer)FeatureInitializerFactory.function((UnivariateFunction)f2, (double)0.0, (double)1.0))};
    }
}

