/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm;

import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.LearningFactorFunction;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.LearningFactorFunctionFactory;
import org.junit.Assert;
import org.junit.Test;

public class LearningFactorFunctionFactoryTest {
    @Test(expected=OutOfRangeException.class)
    public void testExponentialDecayPrecondition0() {
        LearningFactorFunctionFactory.exponentialDecay((double)0.0, (double)0.0, (long)2L);
    }

    @Test(expected=OutOfRangeException.class)
    public void testExponentialDecayPrecondition1() {
        LearningFactorFunctionFactory.exponentialDecay((double)1.0000000001, (double)0.0, (long)2L);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testExponentialDecayPrecondition2() {
        LearningFactorFunctionFactory.exponentialDecay((double)1.0, (double)0.0, (long)2L);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testExponentialDecayPrecondition3() {
        LearningFactorFunctionFactory.exponentialDecay((double)1.0, (double)1.0, (long)100L);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testExponentialDecayPrecondition4() {
        LearningFactorFunctionFactory.exponentialDecay((double)1.0, (double)0.2, (long)0L);
    }

    @Test
    public void testExponentialDecayTrivial() {
        int n = 65;
        double init = 0.5;
        double valueAtN = 0.1;
        LearningFactorFunction f = LearningFactorFunctionFactory.exponentialDecay((double)0.5, (double)0.1, (long)65L);
        Assert.assertEquals((double)0.5, (double)f.value(0L), (double)0.0);
        Assert.assertEquals((double)0.1, (double)f.value(65L), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(Long.MAX_VALUE), (double)0.0);
    }

    @Test(expected=OutOfRangeException.class)
    public void testQuasiSigmoidDecayPrecondition0() {
        LearningFactorFunctionFactory.quasiSigmoidDecay((double)0.0, (double)-1.0, (long)2L);
    }

    @Test(expected=OutOfRangeException.class)
    public void testQuasiSigmoidDecayPrecondition1() {
        LearningFactorFunctionFactory.quasiSigmoidDecay((double)1.0000000001, (double)-1.0, (long)2L);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testQuasiSigmoidDecayPrecondition3() {
        LearningFactorFunctionFactory.quasiSigmoidDecay((double)1.0, (double)0.0, (long)100L);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testQuasiSigmoidDecayPrecondition4() {
        LearningFactorFunctionFactory.quasiSigmoidDecay((double)1.0, (double)-1.0, (long)0L);
    }

    @Test
    public void testQuasiSigmoidDecayTrivial() {
        int n = 65;
        double init = 0.5;
        double slope = -0.1;
        LearningFactorFunction f = LearningFactorFunctionFactory.quasiSigmoidDecay((double)0.5, (double)-0.1, (long)65L);
        Assert.assertEquals((double)0.5, (double)f.value(0L), (double)0.0);
        Assert.assertEquals((double)-0.1, (double)(f.value(65L) - f.value(64L)), (double)0.01);
        Assert.assertEquals((double)0.0, (double)f.value(Long.MAX_VALUE), (double)0.0);
    }
}

