/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ml.clustering.evaluation;

import com.hazelcast.shaded.org.apache.commons.math3.ml.clustering.Cluster;
import com.hazelcast.shaded.org.apache.commons.math3.ml.clustering.Clusterable;
import com.hazelcast.shaded.org.apache.commons.math3.ml.clustering.DoublePoint;
import com.hazelcast.shaded.org.apache.commons.math3.ml.clustering.evaluation.ClusterEvaluator;
import com.hazelcast.shaded.org.apache.commons.math3.ml.clustering.evaluation.SumOfClusterVariances;
import com.hazelcast.shaded.org.apache.commons.math3.ml.distance.DistanceMeasure;
import com.hazelcast.shaded.org.apache.commons.math3.ml.distance.EuclideanDistance;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SumOfClusterVariancesTest {
    private ClusterEvaluator<DoublePoint> evaluator;

    @Before
    public void setUp() {
        this.evaluator = new SumOfClusterVariances((DistanceMeasure)new EuclideanDistance());
    }

    @Test
    public void testScore() {
        DoublePoint[] points1 = new DoublePoint[]{new DoublePoint(new double[]{1.0}), new DoublePoint(new double[]{2.0}), new DoublePoint(new double[]{3.0})};
        DoublePoint[] points2 = new DoublePoint[]{new DoublePoint(new double[]{1.0}), new DoublePoint(new double[]{5.0}), new DoublePoint(new double[]{10.0})};
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        Cluster cluster1 = new Cluster();
        for (DoublePoint p : points1) {
            cluster1.addPoint((Clusterable)p);
        }
        clusters.add(cluster1);
        Assert.assertEquals((double)0.3333333333333333, (double)this.evaluator.score(clusters), (double)1.0E-6);
        Cluster cluster2 = new Cluster();
        for (DoublePoint p : points2) {
            cluster2.addPoint((Clusterable)p);
        }
        clusters.add(cluster2);
        Assert.assertEquals((double)6.148148148, (double)this.evaluator.score(clusters), (double)1.0E-6);
    }

    @Test
    public void testOrdering() {
        Assert.assertTrue((boolean)this.evaluator.isBetterScore(10.0, 20.0));
        Assert.assertFalse((boolean)this.evaluator.isBetterScore(20.0, 1.0));
    }
}

