/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.FieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.Fraction;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.FractionConversionException;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.FractionField;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayFieldVectorTest;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldVectorChangingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldVectorPreservingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.SparseFieldVector;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFieldVectorTest {
    protected Fraction[][] ma1 = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(4), new Fraction(5), new Fraction(6)}, {new Fraction(7), new Fraction(8), new Fraction(9)}};
    protected Fraction[] vec1 = new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(3)};
    protected Fraction[] vec2 = new Fraction[]{new Fraction(4), new Fraction(5), new Fraction(6)};
    protected Fraction[] vec3 = new Fraction[]{new Fraction(7), new Fraction(8), new Fraction(9)};
    protected Fraction[] vec4 = new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4), new Fraction(5), new Fraction(6), new Fraction(7), new Fraction(8), new Fraction(9)};
    protected Fraction[] vec_null = new Fraction[]{new Fraction(0), new Fraction(0), new Fraction(0)};
    protected Fraction[] dvec1 = new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4), new Fraction(5), new Fraction(6), new Fraction(7), new Fraction(8), new Fraction(9)};
    protected Fraction[][] mat1 = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(4), new Fraction(5), new Fraction(6)}, {new Fraction(7), new Fraction(8), new Fraction(9)}};
    protected double entryTolerance = 1.0E-15;
    protected double normTolerance = 1.0E-13;
    protected FractionField field = FractionField.getInstance();

    @Test
    public void testMapFunctions() throws FractionConversionException {
        SparseFieldVector v1 = new SparseFieldVector((Field)this.field, (FieldElement[])this.vec1);
        FieldVector v_mapAdd = v1.mapAdd((FieldElement)new Fraction(2));
        Object[] result_mapAdd = new Fraction[]{new Fraction(3), new Fraction(4), new Fraction(5)};
        Assert.assertArrayEquals((String)"compare vectors", (Object[])result_mapAdd, (Object[])v_mapAdd.toArray());
        FieldVector v_mapAddToSelf = v1.copy();
        v_mapAddToSelf.mapAddToSelf((FieldElement)new Fraction(2));
        Object[] result_mapAddToSelf = new Fraction[]{new Fraction(3), new Fraction(4), new Fraction(5)};
        Assert.assertArrayEquals((String)"compare vectors", (Object[])result_mapAddToSelf, (Object[])v_mapAddToSelf.toArray());
        FieldVector v_mapSubtract = v1.mapSubtract((FieldElement)new Fraction(2));
        Object[] result_mapSubtract = new Fraction[]{new Fraction(-1), new Fraction(0), new Fraction(1)};
        Assert.assertArrayEquals((String)"compare vectors", (Object[])result_mapSubtract, (Object[])v_mapSubtract.toArray());
        FieldVector v_mapSubtractToSelf = v1.copy();
        v_mapSubtractToSelf.mapSubtractToSelf((FieldElement)new Fraction(2));
        Object[] result_mapSubtractToSelf = new Fraction[]{new Fraction(-1), new Fraction(0), new Fraction(1)};
        Assert.assertArrayEquals((String)"compare vectors", (Object[])result_mapSubtractToSelf, (Object[])v_mapSubtractToSelf.toArray());
        FieldVector v_mapMultiply = v1.mapMultiply((FieldElement)new Fraction(2));
        Object[] result_mapMultiply = new Fraction[]{new Fraction(2), new Fraction(4), new Fraction(6)};
        Assert.assertArrayEquals((String)"compare vectors", (Object[])result_mapMultiply, (Object[])v_mapMultiply.toArray());
        FieldVector v_mapMultiplyToSelf = v1.copy();
        v_mapMultiplyToSelf.mapMultiplyToSelf((FieldElement)new Fraction(2));
        Object[] result_mapMultiplyToSelf = new Fraction[]{new Fraction(2), new Fraction(4), new Fraction(6)};
        Assert.assertArrayEquals((String)"compare vectors", (Object[])result_mapMultiplyToSelf, (Object[])v_mapMultiplyToSelf.toArray());
        FieldVector v_mapDivide = v1.mapDivide((FieldElement)new Fraction(2));
        Object[] result_mapDivide = new Fraction[]{new Fraction(0.5), new Fraction(1), new Fraction(1.5)};
        Assert.assertArrayEquals((String)"compare vectors", (Object[])result_mapDivide, (Object[])v_mapDivide.toArray());
        FieldVector v_mapDivideToSelf = v1.copy();
        v_mapDivideToSelf.mapDivideToSelf((FieldElement)new Fraction(2));
        Object[] result_mapDivideToSelf = new Fraction[]{new Fraction(0.5), new Fraction(1), new Fraction(1.5)};
        Assert.assertArrayEquals((String)"compare vectors", (Object[])result_mapDivideToSelf, (Object[])v_mapDivideToSelf.toArray());
        FieldVector v_mapInv = v1.mapInv();
        Object[] result_mapInv = new Fraction[]{new Fraction(1), new Fraction(0.5), new Fraction(0.3333333333333333)};
        Assert.assertArrayEquals((String)"compare vectors", (Object[])result_mapInv, (Object[])v_mapInv.toArray());
        FieldVector v_mapInvToSelf = v1.copy();
        v_mapInvToSelf.mapInvToSelf();
        Object[] result_mapInvToSelf = new Fraction[]{new Fraction(1), new Fraction(0.5), new Fraction(0.3333333333333333)};
        Assert.assertArrayEquals((String)"compare vectors", (Object[])result_mapInvToSelf, (Object[])v_mapInvToSelf.toArray());
    }

    @Test
    public void testBasicFunctions() throws FractionConversionException {
        SparseFieldVector v1 = new SparseFieldVector((Field)this.field, (FieldElement[])this.vec1);
        SparseFieldVector v2 = new SparseFieldVector((Field)this.field, (FieldElement[])this.vec2);
        ArrayFieldVectorTest.FieldVectorTestImpl v2_t = new ArrayFieldVectorTest.FieldVectorTestImpl((FieldElement[])this.vec2);
        FieldVector v_add = v1.add(v2);
        Object[] result_add = new Fraction[]{new Fraction(5), new Fraction(7), new Fraction(9)};
        Assert.assertArrayEquals((String)"compare vect", (Object[])v_add.toArray(), (Object[])result_add);
        ArrayFieldVectorTest.FieldVectorTestImpl vt2 = new ArrayFieldVectorTest.FieldVectorTestImpl((FieldElement[])this.vec2);
        FieldVector v_add_i = v1.add((FieldVector)vt2);
        Object[] result_add_i = new Fraction[]{new Fraction(5), new Fraction(7), new Fraction(9)};
        Assert.assertArrayEquals((String)"compare vect", (Object[])v_add_i.toArray(), (Object[])result_add_i);
        SparseFieldVector v_subtract = v1.subtract(v2);
        Fraction[] result_subtract = new Fraction[]{new Fraction(-3), new Fraction(-3), new Fraction(-3)};
        this.assertClose("compare vect", (Fraction[])v_subtract.toArray(), result_subtract, this.normTolerance);
        FieldVector v_subtract_i = v1.subtract((FieldVector)vt2);
        Fraction[] result_subtract_i = new Fraction[]{new Fraction(-3), new Fraction(-3), new Fraction(-3)};
        this.assertClose("compare vect", (Fraction[])v_subtract_i.toArray(), result_subtract_i, this.normTolerance);
        FieldVector v_ebeMultiply = v1.ebeMultiply((FieldVector)v2);
        Fraction[] result_ebeMultiply = new Fraction[]{new Fraction(4), new Fraction(10), new Fraction(18)};
        this.assertClose("compare vect", (Fraction[])v_ebeMultiply.toArray(), result_ebeMultiply, this.normTolerance);
        FieldVector v_ebeMultiply_2 = v1.ebeMultiply((FieldVector)v2_t);
        Fraction[] result_ebeMultiply_2 = new Fraction[]{new Fraction(4), new Fraction(10), new Fraction(18)};
        this.assertClose("compare vect", (Fraction[])v_ebeMultiply_2.toArray(), result_ebeMultiply_2, this.normTolerance);
        FieldVector v_ebeDivide = v1.ebeDivide((FieldVector)v2);
        Fraction[] result_ebeDivide = new Fraction[]{new Fraction(0.25), new Fraction(0.4), new Fraction(0.5)};
        this.assertClose("compare vect", (Fraction[])v_ebeDivide.toArray(), result_ebeDivide, this.normTolerance);
        FieldVector v_ebeDivide_2 = v1.ebeDivide((FieldVector)v2_t);
        Fraction[] result_ebeDivide_2 = new Fraction[]{new Fraction(0.25), new Fraction(0.4), new Fraction(0.5)};
        this.assertClose("compare vect", (Fraction[])v_ebeDivide_2.toArray(), result_ebeDivide_2, this.normTolerance);
        Fraction dot = (Fraction)v1.dotProduct((FieldVector)v2);
        Assert.assertEquals((String)"compare val ", (Object)new Fraction(32), (Object)dot);
        Fraction dot_2 = (Fraction)v1.dotProduct((FieldVector)v2_t);
        Assert.assertEquals((String)"compare val ", (Object)new Fraction(32), (Object)dot_2);
        FieldMatrix m_outerProduct = v1.outerProduct(v2);
        Assert.assertEquals((String)"compare val ", (Object)new Fraction(4), (Object)m_outerProduct.getEntry(0, 0));
        FieldMatrix m_outerProduct_2 = v1.outerProduct((FieldVector)v2_t);
        Assert.assertEquals((String)"compare val ", (Object)new Fraction(4), (Object)m_outerProduct_2.getEntry(0, 0));
    }

    @Test
    public void testOuterProduct() {
        SparseFieldVector u = new SparseFieldVector((Field)FractionField.getInstance(), (FieldElement[])new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(-3)});
        SparseFieldVector v = new SparseFieldVector((Field)FractionField.getInstance(), (FieldElement[])new Fraction[]{new Fraction(4), new Fraction(-2)});
        FieldMatrix uv = u.outerProduct(v);
        double tol = Math.ulp(1.0);
        Assert.assertEquals((double)new Fraction(4).doubleValue(), (double)((Fraction)uv.getEntry(0, 0)).doubleValue(), (double)tol);
        Assert.assertEquals((double)new Fraction(-2).doubleValue(), (double)((Fraction)uv.getEntry(0, 1)).doubleValue(), (double)tol);
        Assert.assertEquals((double)new Fraction(8).doubleValue(), (double)((Fraction)uv.getEntry(1, 0)).doubleValue(), (double)tol);
        Assert.assertEquals((double)new Fraction(-4).doubleValue(), (double)((Fraction)uv.getEntry(1, 1)).doubleValue(), (double)tol);
        Assert.assertEquals((double)new Fraction(-12).doubleValue(), (double)((Fraction)uv.getEntry(2, 0)).doubleValue(), (double)tol);
        Assert.assertEquals((double)new Fraction(6).doubleValue(), (double)((Fraction)uv.getEntry(2, 1)).doubleValue(), (double)tol);
    }

    @Test
    public void testMisc() {
        SparseFieldVector v1 = new SparseFieldVector((Field)this.field, (FieldElement[])this.vec1);
        String out1 = v1.toString();
        Assert.assertTrue((String)"some output ", (out1.length() != 0 ? 1 : 0) != 0);
        try {
            v1.checkVectorDimensions(2);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPredicates() {
        SparseFieldVector v = new SparseFieldVector((Field)this.field, (FieldElement[])new Fraction[]{new Fraction(0), new Fraction(1), new Fraction(2)});
        v.setEntry(0, (FieldElement)this.field.getZero());
        Assert.assertEquals((Object)v, (Object)new SparseFieldVector((Field)this.field, (FieldElement[])new Fraction[]{new Fraction(0), new Fraction(1), new Fraction(2)}));
        Assert.assertNotSame((Object)v, (Object)new SparseFieldVector((Field)this.field, (FieldElement[])new Fraction[]{new Fraction(0), new Fraction(1), new Fraction(2), new Fraction(3)}));
    }

    protected void assertEquals(String msg, Fraction[] m, Fraction[] n) {
        if (m.length != n.length) {
            Assert.fail((String)"vectors have different lengths");
        }
        for (int i = 0; i < m.length; ++i) {
            Assert.assertEquals((String)(msg + " " + i + " elements differ"), (Object)m[i], (Object)n[i]);
        }
    }

    protected void assertClose(String msg, Fraction[] m, Fraction[] n, double tolerance) {
        if (m.length != n.length) {
            Assert.fail((String)"vectors have different lengths");
        }
        for (int i = 0; i < m.length; ++i) {
            Assert.assertEquals((String)(msg + " " + i + " elements differ"), (double)m[i].doubleValue(), (double)n[i].doubleValue(), (double)tolerance);
        }
    }

    @Test
    public void testWalkInDefaultOrderPreservingVisitor1() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        SparseFieldVector v = new SparseFieldVector((Field)this.field, (FieldElement[])data);
        FieldVectorPreservingVisitor<Fraction> visitor = new FieldVectorPreservingVisitor<Fraction>(){
            private int expectedIndex;

            public void visit(int actualIndex, Fraction actualValue) {
                Assert.assertEquals((long)this.expectedIndex, (long)actualIndex);
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                ++this.expectedIndex;
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)0L, (long)actualStart);
                Assert.assertEquals((long)(data.length - 1), (long)actualEnd);
                this.expectedIndex = 0;
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor);
    }

    @Test
    public void testWalkInDefaultOrderPreservingVisitor2() {
        SparseFieldVector<Fraction> v = this.create(5);
        FieldVectorPreservingVisitor<Fraction> visitor = new FieldVectorPreservingVisitor<Fraction>(){

            public void visit(int index, Fraction value) {
            }

            public void start(int dimension, int start, int end) {
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        try {
            v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor, -1, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor, 5, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor, 0, -1);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor, 0, 5);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor, 4, 0);
            Assert.fail();
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testWalkInDefaultOrderPreservingVisitor3() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        SparseFieldVector v = new SparseFieldVector((Field)this.field, (FieldElement[])data);
        int expectedStart = 2;
        int expectedEnd = 7;
        FieldVectorPreservingVisitor<Fraction> visitor = new FieldVectorPreservingVisitor<Fraction>(){
            private int expectedIndex;

            public void visit(int actualIndex, Fraction actualValue) {
                Assert.assertEquals((long)this.expectedIndex, (long)actualIndex);
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                ++this.expectedIndex;
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)2L, (long)actualStart);
                Assert.assertEquals((long)7L, (long)actualEnd);
                this.expectedIndex = 2;
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor, 2, 7);
    }

    @Test
    public void testWalkInOptimizedOrderPreservingVisitor1() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        SparseFieldVector v = new SparseFieldVector((Field)this.field, (FieldElement[])data);
        FieldVectorPreservingVisitor<Fraction> visitor = new FieldVectorPreservingVisitor<Fraction>(){
            private final boolean[] visited;
            {
                this.visited = new boolean[data.length];
            }

            public void visit(int actualIndex, Fraction actualValue) {
                this.visited[actualIndex] = true;
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)0L, (long)actualStart);
                Assert.assertEquals((long)(data.length - 1), (long)actualEnd);
                Arrays.fill(this.visited, false);
            }

            public Fraction end() {
                for (int i = 0; i < data.length; ++i) {
                    Assert.assertTrue((String)("entry " + i + "has not been visited"), (boolean)this.visited[i]);
                }
                return Fraction.ZERO;
            }
        };
        v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor);
    }

    @Test
    public void testWalkInOptimizedOrderPreservingVisitor2() {
        SparseFieldVector<Fraction> v = this.create(5);
        FieldVectorPreservingVisitor<Fraction> visitor = new FieldVectorPreservingVisitor<Fraction>(){

            public void visit(int index, Fraction value) {
            }

            public void start(int dimension, int start, int end) {
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        try {
            v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor, -1, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor, 5, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor, 0, -1);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor, 0, 5);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor, 4, 0);
            Assert.fail();
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testWalkInOptimizedOrderPreservingVisitor3() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        SparseFieldVector v = new SparseFieldVector((Field)this.field, (FieldElement[])data);
        int expectedStart = 2;
        int expectedEnd = 7;
        FieldVectorPreservingVisitor<Fraction> visitor = new FieldVectorPreservingVisitor<Fraction>(){
            private final boolean[] visited;
            {
                this.visited = new boolean[data.length];
            }

            public void visit(int actualIndex, Fraction actualValue) {
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                this.visited[actualIndex] = true;
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)2L, (long)actualStart);
                Assert.assertEquals((long)7L, (long)actualEnd);
                Arrays.fill(this.visited, true);
            }

            public Fraction end() {
                for (int i = 2; i <= 7; ++i) {
                    Assert.assertTrue((String)("entry " + i + "has not been visited"), (boolean)this.visited[i]);
                }
                return Fraction.ZERO;
            }
        };
        v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor, 2, 7);
    }

    @Test
    public void testWalkInDefaultOrderChangingVisitor1() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        SparseFieldVector v = new SparseFieldVector((Field)this.field, (FieldElement[])data);
        FieldVectorChangingVisitor<Fraction> visitor = new FieldVectorChangingVisitor<Fraction>(){
            private int expectedIndex;

            public Fraction visit(int actualIndex, Fraction actualValue) {
                Assert.assertEquals((long)this.expectedIndex, (long)actualIndex);
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                ++this.expectedIndex;
                return actualValue.add(actualIndex);
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)0L, (long)actualStart);
                Assert.assertEquals((long)(data.length - 1), (long)actualEnd);
                this.expectedIndex = 0;
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor);
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((String)("entry " + i), (Object)data[i].add(i), (Object)v.getEntry(i));
        }
    }

    @Test
    public void testWalkInDefaultOrderChangingVisitor2() {
        SparseFieldVector<Fraction> v = this.create(5);
        FieldVectorChangingVisitor<Fraction> visitor = new FieldVectorChangingVisitor<Fraction>(){

            public Fraction visit(int index, Fraction value) {
                return Fraction.ZERO;
            }

            public void start(int dimension, int start, int end) {
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        try {
            v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor, -1, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor, 5, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor, 0, -1);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor, 0, 5);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor, 4, 0);
            Assert.fail();
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testWalkInDefaultOrderChangingVisitor3() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        SparseFieldVector v = new SparseFieldVector((Field)this.field, (FieldElement[])data);
        int expectedStart = 2;
        int expectedEnd = 7;
        FieldVectorChangingVisitor<Fraction> visitor = new FieldVectorChangingVisitor<Fraction>(){
            private int expectedIndex;

            public Fraction visit(int actualIndex, Fraction actualValue) {
                Assert.assertEquals((long)this.expectedIndex, (long)actualIndex);
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                ++this.expectedIndex;
                return actualValue.add(actualIndex);
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)2L, (long)actualStart);
                Assert.assertEquals((long)7L, (long)actualEnd);
                this.expectedIndex = 2;
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor, 2, 7);
        for (int i = 2; i <= 7; ++i) {
            Assert.assertEquals((String)("entry " + i), (Object)data[i].add(i), (Object)v.getEntry(i));
        }
    }

    @Test
    public void testWalkInOptimizedOrderChangingVisitor1() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        SparseFieldVector v = new SparseFieldVector((Field)this.field, (FieldElement[])data);
        FieldVectorChangingVisitor<Fraction> visitor = new FieldVectorChangingVisitor<Fraction>(){
            private final boolean[] visited;
            {
                this.visited = new boolean[data.length];
            }

            public Fraction visit(int actualIndex, Fraction actualValue) {
                this.visited[actualIndex] = true;
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                return actualValue.add(actualIndex);
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)0L, (long)actualStart);
                Assert.assertEquals((long)(data.length - 1), (long)actualEnd);
                Arrays.fill(this.visited, false);
            }

            public Fraction end() {
                for (int i = 0; i < data.length; ++i) {
                    Assert.assertTrue((String)("entry " + i + "has not been visited"), (boolean)this.visited[i]);
                }
                return Fraction.ZERO;
            }
        };
        v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor);
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((String)("entry " + i), (Object)data[i].add(i), (Object)v.getEntry(i));
        }
    }

    @Test
    public void testWalkInOptimizedOrderChangingVisitor2() {
        SparseFieldVector<Fraction> v = this.create(5);
        FieldVectorChangingVisitor<Fraction> visitor = new FieldVectorChangingVisitor<Fraction>(){

            public Fraction visit(int index, Fraction value) {
                return Fraction.ZERO;
            }

            public void start(int dimension, int start, int end) {
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        try {
            v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor, -1, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor, 5, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor, 0, -1);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor, 0, 5);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor, 4, 0);
            Assert.fail();
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testWalkInOptimizedOrderChangingVisitor3() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        SparseFieldVector v = new SparseFieldVector((Field)this.field, (FieldElement[])data);
        int expectedStart = 2;
        int expectedEnd = 7;
        FieldVectorChangingVisitor<Fraction> visitor = new FieldVectorChangingVisitor<Fraction>(){
            private final boolean[] visited;
            {
                this.visited = new boolean[data.length];
            }

            public Fraction visit(int actualIndex, Fraction actualValue) {
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                this.visited[actualIndex] = true;
                return actualValue.add(actualIndex);
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)2L, (long)actualStart);
                Assert.assertEquals((long)7L, (long)actualEnd);
                Arrays.fill(this.visited, true);
            }

            public Fraction end() {
                for (int i = 2; i <= 7; ++i) {
                    Assert.assertTrue((String)("entry " + i + "has not been visited"), (boolean)this.visited[i]);
                }
                return Fraction.ZERO;
            }
        };
        v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor, 2, 7);
        for (int i = 2; i <= 7; ++i) {
            Assert.assertEquals((String)("entry " + i), (Object)data[i].add(i), (Object)v.getEntry(i));
        }
    }

    private SparseFieldVector<Fraction> create(int n) {
        Fraction[] t = new Fraction[n];
        for (int i = 0; i < n; ++i) {
            t[i] = Fraction.ZERO;
        }
        return new SparseFieldVector((Field)this.field, (FieldElement[])t);
    }
}

