/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.Array2DRowRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.DecompositionSolver;
import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixUtils;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVectorAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.linear.SingularValueDecomposition;
import org.junit.Assert;
import org.junit.Test;

public class SingularValueSolverTest {
    private double[][] testSquare = new double[][]{{0.96, 1.72}, {2.28, 0.96}};
    private double[][] bigSingular = new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 5.0, 3.0, 4.0}, {7.0, 3.0, 256.0, 1930.0}, {3.0, 7.0, 6.0, 8.0}};
    private static final double normTolerance = 1.0E-13;

    @Test
    public void testSolveDimensionErrors() {
        DecompositionSolver solver = new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.testSquare)).getSolver();
        RealMatrix b = MatrixUtils.createRealMatrix((double[][])new double[3][2]);
        try {
            solver.solve(b);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            solver.solve(b.getColumnVector(0));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            solver.solve((RealVector)new RealVectorAbstractTest.RealVectorTestImpl(b.getColumn(0)));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLeastSquareSolve() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 0.0}, {0.0, 0.0}});
        DecompositionSolver solver = new SingularValueDecomposition(m).getSolver();
        RealMatrix b = MatrixUtils.createRealMatrix((double[][])new double[][]{{11.0, 12.0}, {21.0, 22.0}});
        RealMatrix xMatrix = solver.solve(b);
        Assert.assertEquals((double)11.0, (double)xMatrix.getEntry(0, 0), (double)1.0E-15);
        Assert.assertEquals((double)12.0, (double)xMatrix.getEntry(0, 1), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)xMatrix.getEntry(1, 0), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)xMatrix.getEntry(1, 1), (double)1.0E-15);
        RealVector xColVec = solver.solve(b.getColumnVector(0));
        Assert.assertEquals((double)11.0, (double)xColVec.getEntry(0), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)xColVec.getEntry(1), (double)1.0E-15);
        RealVector xColOtherVec = solver.solve((RealVector)new RealVectorAbstractTest.RealVectorTestImpl(b.getColumn(0)));
        Assert.assertEquals((double)11.0, (double)xColOtherVec.getEntry(0), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)xColOtherVec.getEntry(1), (double)1.0E-15);
    }

    @Test
    public void testSolve() {
        int i;
        DecompositionSolver solver = new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.testSquare)).getSolver();
        RealMatrix b = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 2.0, 3.0}, {0.0, -5.0, 1.0}});
        RealMatrix xRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{-0.32, -3.506666666666667, -0.38666666666666666}, {0.76, 3.12, 1.96}});
        Assert.assertEquals((double)0.0, (double)solver.solve(b).subtract(xRef).getNorm(), (double)1.0E-13);
        for (i = 0; i < b.getColumnDimension(); ++i) {
            Assert.assertEquals((double)0.0, (double)solver.solve(b.getColumnVector(i)).subtract(xRef.getColumnVector(i)).getNorm(), (double)1.0E-13);
        }
        for (i = 0; i < b.getColumnDimension(); ++i) {
            RealVectorAbstractTest.RealVectorTestImpl v = new RealVectorAbstractTest.RealVectorTestImpl(b.getColumn(i));
            Assert.assertEquals((double)0.0, (double)solver.solve((RealVector)v).subtract(xRef.getColumnVector(i)).getNorm(), (double)1.0E-13);
        }
    }

    @Test
    public void testConditionNumber() {
        SingularValueDecomposition svd = new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.testSquare));
        Assert.assertEquals((double)3.0, (double)svd.getConditionNumber(), (double)1.5E-15);
    }

    @Test
    public void testMath320B() {
        Array2DRowRealMatrix rm = new Array2DRowRealMatrix((double[][])new double[][]{{1.0, 2.0}, {1.0, 2.0}});
        SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)rm);
        RealMatrix recomposed = svd.getU().multiply(svd.getS()).multiply(svd.getVT());
        Assert.assertEquals((double)0.0, (double)recomposed.subtract((RealMatrix)rm).getNorm(), (double)2.0E-15);
    }

    @Test
    public void testSingular() {
        SingularValueDecomposition svd = new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.bigSingular));
        RealMatrix pseudoInverse = svd.getSolver().getInverse();
        Array2DRowRealMatrix expected = new Array2DRowRealMatrix((double[][])new double[][]{{-0.0355022687, 0.0512742236, -1.045523E-4, 0.0157719549}, {-0.3214992438, 0.3162419255, 3.48508E-5, -0.0052573183}, {0.5437098346, -0.4107754586, -8.256918E-4, 0.132934376}, {-0.0714905202, 0.053808742, 6.279816E-4, -0.0176817782}});
        Assert.assertEquals((double)0.0, (double)expected.subtract(pseudoInverse).getNorm(), (double)1.0E-9);
    }
}

