/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathParseException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVectorFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public abstract class RealVectorFormatAbstractTest {
    RealVectorFormat realVectorFormat = RealVectorFormat.getInstance((Locale)this.getLocale());
    RealVectorFormat realVectorFormatSquare = null;

    protected abstract Locale getLocale();

    protected abstract char getDecimalCharacter();

    public RealVectorFormatAbstractTest() {
        NumberFormat nf = NumberFormat.getInstance(this.getLocale());
        nf.setMaximumFractionDigits(2);
        this.realVectorFormatSquare = new RealVectorFormat("[", "]", " : ", nf);
    }

    @Test
    public void testSimpleNoDecimals() {
        ArrayRealVector c = new ArrayRealVector(new double[]{1.0, 1.0, 1.0});
        String expected = "{1; 1; 1}";
        String actual = this.realVectorFormat.format((RealVector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleWithDecimals() {
        ArrayRealVector c = new ArrayRealVector(new double[]{1.23, 1.43, 1.63});
        String expected = "{1" + this.getDecimalCharacter() + "23; 1" + this.getDecimalCharacter() + "43; 1" + this.getDecimalCharacter() + "63}";
        String actual = this.realVectorFormat.format((RealVector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleWithDecimalsTrunc() {
        ArrayRealVector c = new ArrayRealVector(new double[]{1.232323232323, 1.43434343434343, 1.633333333333});
        String expected = "{1" + this.getDecimalCharacter() + "2323232323; 1" + this.getDecimalCharacter() + "4343434343; 1" + this.getDecimalCharacter() + "6333333333}";
        String actual = this.realVectorFormat.format((RealVector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeX() {
        ArrayRealVector c = new ArrayRealVector(new double[]{-1.232323232323, 1.43, 1.63});
        String expected = "{-1" + this.getDecimalCharacter() + "2323232323; 1" + this.getDecimalCharacter() + "43; 1" + this.getDecimalCharacter() + "63}";
        String actual = this.realVectorFormat.format((RealVector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeY() {
        ArrayRealVector c = new ArrayRealVector(new double[]{1.23, -1.434343434343, 1.63});
        String expected = "{1" + this.getDecimalCharacter() + "23; -1" + this.getDecimalCharacter() + "4343434343; 1" + this.getDecimalCharacter() + "63}";
        String actual = this.realVectorFormat.format((RealVector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeZ() {
        ArrayRealVector c = new ArrayRealVector(new double[]{1.23, 1.43, -1.633333333333});
        String expected = "{1" + this.getDecimalCharacter() + "23; 1" + this.getDecimalCharacter() + "43; -1" + this.getDecimalCharacter() + "6333333333}";
        String actual = this.realVectorFormat.format((RealVector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNonDefaultSetting() {
        ArrayRealVector c = new ArrayRealVector(new double[]{1.0, 1.0, 1.0});
        String expected = "[1 : 1 : 1]";
        String actual = this.realVectorFormatSquare.format((RealVector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDefaultFormatRealVectorImpl() {
        Locale defaultLocal = Locale.getDefault();
        Locale.setDefault(this.getLocale());
        ArrayRealVector c = new ArrayRealVector(new double[]{232.22222222222, -342.3333333333, 432.44444444444});
        String expected = "{232" + this.getDecimalCharacter() + "2222222222; -342" + this.getDecimalCharacter() + "3333333333; 432" + this.getDecimalCharacter() + "4444444444}";
        String actual = new RealVectorFormat().format((RealVector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        Locale.setDefault(defaultLocal);
    }

    @Test
    public void testNan() {
        ArrayRealVector c = new ArrayRealVector(new double[]{Double.NaN, Double.NaN, Double.NaN});
        String expected = "{(NaN); (NaN); (NaN)}";
        String actual = this.realVectorFormat.format((RealVector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testPositiveInfinity() {
        ArrayRealVector c = new ArrayRealVector(new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY});
        String expected = "{(Infinity); (Infinity); (Infinity)}";
        String actual = this.realVectorFormat.format((RealVector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void tesNegativeInfinity() {
        ArrayRealVector c = new ArrayRealVector(new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY});
        String expected = "{(-Infinity); (-Infinity); (-Infinity)}";
        String actual = this.realVectorFormat.format((RealVector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseSimpleNoDecimals() {
        String source = "{1; 1; 1}";
        ArrayRealVector expected = new ArrayRealVector(new double[]{1.0, 1.0, 1.0});
        ArrayRealVector actual = this.realVectorFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseIgnoredWhitespace() {
        ArrayRealVector expected = new ArrayRealVector(new double[]{1.0, 1.0, 1.0});
        ParsePosition pos1 = new ParsePosition(0);
        String source1 = "{1;1;1}";
        Assert.assertEquals((Object)expected, (Object)this.realVectorFormat.parse(source1, pos1));
        Assert.assertEquals((long)source1.length(), (long)pos1.getIndex());
        ParsePosition pos2 = new ParsePosition(0);
        String source2 = " { 1 ; 1 ; 1 } ";
        Assert.assertEquals((Object)expected, (Object)this.realVectorFormat.parse(source2, pos2));
        Assert.assertEquals((long)(source2.length() - 1), (long)pos2.getIndex());
    }

    @Test
    public void testParseSimpleWithDecimals() {
        String source = "{1" + this.getDecimalCharacter() + "23; 1" + this.getDecimalCharacter() + "43; 1" + this.getDecimalCharacter() + "63}";
        ArrayRealVector expected = new ArrayRealVector(new double[]{1.23, 1.43, 1.63});
        ArrayRealVector actual = this.realVectorFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseSimpleWithDecimalsTrunc() {
        String source = "{1" + this.getDecimalCharacter() + "2323; 1" + this.getDecimalCharacter() + "4343; 1" + this.getDecimalCharacter() + "6333}";
        ArrayRealVector expected = new ArrayRealVector(new double[]{1.2323, 1.4343, 1.6333});
        ArrayRealVector actual = this.realVectorFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeX() {
        String source = "{-1" + this.getDecimalCharacter() + "2323; 1" + this.getDecimalCharacter() + "4343; 1" + this.getDecimalCharacter() + "6333}";
        ArrayRealVector expected = new ArrayRealVector(new double[]{-1.2323, 1.4343, 1.6333});
        ArrayRealVector actual = this.realVectorFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeY() {
        String source = "{1" + this.getDecimalCharacter() + "2323; -1" + this.getDecimalCharacter() + "4343; 1" + this.getDecimalCharacter() + "6333}";
        ArrayRealVector expected = new ArrayRealVector(new double[]{1.2323, -1.4343, 1.6333});
        ArrayRealVector actual = this.realVectorFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeZ() {
        String source = "{1" + this.getDecimalCharacter() + "2323; 1" + this.getDecimalCharacter() + "4343; -1" + this.getDecimalCharacter() + "6333}";
        ArrayRealVector expected = new ArrayRealVector(new double[]{1.2323, 1.4343, -1.6333});
        ArrayRealVector actual = this.realVectorFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeAll() {
        String source = "{-1" + this.getDecimalCharacter() + "2323; -1" + this.getDecimalCharacter() + "4343; -1" + this.getDecimalCharacter() + "6333}";
        ArrayRealVector expected = new ArrayRealVector(new double[]{-1.2323, -1.4343, -1.6333});
        ArrayRealVector actual = this.realVectorFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseZeroX() {
        String source = "{0" + this.getDecimalCharacter() + "0; -1" + this.getDecimalCharacter() + "4343; 1" + this.getDecimalCharacter() + "6333}";
        ArrayRealVector expected = new ArrayRealVector(new double[]{0.0, -1.4343, 1.6333});
        ArrayRealVector actual = this.realVectorFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNonDefaultSetting() {
        String source = "[1" + this.getDecimalCharacter() + "2323 : 1" + this.getDecimalCharacter() + "4343 : 1" + this.getDecimalCharacter() + "6333]";
        ArrayRealVector expected = new ArrayRealVector(new double[]{1.2323, 1.4343, 1.6333});
        ArrayRealVector actual = this.realVectorFormatSquare.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNan() {
        String source = "{(NaN); (NaN); (NaN)}";
        ArrayRealVector actual = this.realVectorFormat.parse(source);
        Assert.assertEquals((Object)new ArrayRealVector(new double[]{Double.NaN, Double.NaN, Double.NaN}), (Object)actual);
    }

    @Test
    public void testParsePositiveInfinity() {
        String source = "{(Infinity); (Infinity); (Infinity)}";
        ArrayRealVector actual = this.realVectorFormat.parse(source);
        Assert.assertEquals((Object)new ArrayRealVector(new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}), (Object)actual);
    }

    @Test
    public void testParseNegativeInfinity() {
        String source = "{(-Infinity); (-Infinity); (-Infinity)}";
        ArrayRealVector actual = this.realVectorFormat.parse(source);
        Assert.assertEquals((Object)new ArrayRealVector(new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY}), (Object)actual);
    }

    @Test
    public void testParseNoComponents() {
        try {
            this.realVectorFormat.parse("{ }");
            Assert.fail((String)"Expecting MathParseException");
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
    }

    @Test
    public void testParseManyComponents() {
        ArrayRealVector parsed = this.realVectorFormat.parse("{0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0}");
        Assert.assertEquals((long)24L, (long)parsed.getDimension());
    }

    @Test
    public void testConstructorSingleFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        RealVectorFormat cf = new RealVectorFormat(nf);
        Assert.assertNotNull((Object)cf);
        Assert.assertEquals((Object)nf, (Object)cf.getFormat());
    }

    @Test
    public void testForgottenPrefix() {
        ParsePosition pos = new ParsePosition(0);
        String source = "1; 1; 1}";
        Assert.assertNull((String)"Should not parse <1; 1; 1}>", (Object)new RealVectorFormat().parse("1; 1; 1}", pos));
        Assert.assertEquals((long)0L, (long)pos.getErrorIndex());
    }

    @Test
    public void testForgottenSeparator() {
        ParsePosition pos = new ParsePosition(0);
        String source = "{1; 1 1}";
        Assert.assertNull((String)"Should not parse <{1; 1 1}>", (Object)new RealVectorFormat().parse("{1; 1 1}", pos));
        Assert.assertEquals((long)6L, (long)pos.getErrorIndex());
    }

    @Test
    public void testForgottenSuffix() {
        ParsePosition pos = new ParsePosition(0);
        String source = "{1; 1; 1 ";
        Assert.assertNull((String)"Should not parse <{1; 1; 1 >", (Object)new RealVectorFormat().parse("{1; 1; 1 ", pos));
        Assert.assertEquals((long)8L, (long)pos.getErrorIndex());
    }
}

