/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.FieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.BigFraction;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.Fraction;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.FractionConversionException;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.FractionField;
import com.hazelcast.shaded.org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.Array2DRowRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.BlockRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.DiagonalMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixUtils;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonSquareMatrixException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonSymmetricMatrixException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.SingularMatrixException;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatrixUtilsTest {
    protected double[][] testData = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 3.0}, {1.0, 0.0, 8.0}};
    protected double[][] testData3x3Singular = new double[][]{{1.0, 4.0, 7.0}, {2.0, 5.0, 8.0}, {3.0, 6.0, 9.0}};
    protected double[][] testData3x4 = new double[][]{{12.0, -51.0, 4.0, 1.0}, {6.0, 167.0, -68.0, 2.0}, {-4.0, 24.0, -41.0, 3.0}};
    protected double[][] nullMatrix = null;
    protected double[] row = new double[]{1.0, 2.0, 3.0};
    protected BigDecimal[] bigRow = new BigDecimal[]{new BigDecimal(1), new BigDecimal(2), new BigDecimal(3)};
    protected String[] stringRow = new String[]{"1", "2", "3"};
    protected Fraction[] fractionRow = new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(3)};
    protected double[][] rowMatrix = new double[][]{{1.0, 2.0, 3.0}};
    protected BigDecimal[][] bigRowMatrix = new BigDecimal[][]{{new BigDecimal(1), new BigDecimal(2), new BigDecimal(3)}};
    protected String[][] stringRowMatrix = new String[][]{{"1", "2", "3"}};
    protected Fraction[][] fractionRowMatrix = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}};
    protected double[] col = new double[]{0.0, 4.0, 6.0};
    protected BigDecimal[] bigCol = new BigDecimal[]{new BigDecimal(0), new BigDecimal(4), new BigDecimal(6)};
    protected String[] stringCol = new String[]{"0", "4", "6"};
    protected Fraction[] fractionCol = new Fraction[]{new Fraction(0), new Fraction(4), new Fraction(6)};
    protected double[] nullDoubleArray = null;
    protected double[][] colMatrix = new double[][]{{0.0}, {4.0}, {6.0}};
    protected BigDecimal[][] bigColMatrix = new BigDecimal[][]{{new BigDecimal(0)}, {new BigDecimal(4)}, {new BigDecimal(6)}};
    protected String[][] stringColMatrix = new String[][]{{"0"}, {"4"}, {"6"}};
    protected Fraction[][] fractionColMatrix = new Fraction[][]{{new Fraction(0)}, {new Fraction(4)}, {new Fraction(6)}};

    @Test
    public void testCreateRealMatrix() {
        Assert.assertEquals((Object)new BlockRealMatrix(this.testData), (Object)MatrixUtils.createRealMatrix((double[][])this.testData));
        try {
            MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0}, {1.0, 2.0}});
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MatrixUtils.createRealMatrix((double[][])new double[][]{new double[0], new double[0]});
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MatrixUtils.createRealMatrix((double[][])null);
            Assert.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testcreateFieldMatrix() {
        Assert.assertEquals((Object)new Array2DRowFieldMatrix((FieldElement[][])MatrixUtilsTest.asFraction(this.testData)), (Object)MatrixUtils.createFieldMatrix((FieldElement[][])MatrixUtilsTest.asFraction(this.testData)));
        Assert.assertEquals((Object)new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.fractionColMatrix), (Object)MatrixUtils.createFieldMatrix((FieldElement[][])this.fractionColMatrix));
        try {
            MatrixUtils.createFieldMatrix((FieldElement[][])MatrixUtilsTest.asFraction(new double[][]{{1.0}, {1.0, 2.0}}));
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MatrixUtils.createFieldMatrix((FieldElement[][])MatrixUtilsTest.asFraction(new double[][]{new double[0], new double[0]}));
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MatrixUtils.createFieldMatrix((FieldElement[][])((Fraction[][])null));
            Assert.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateRowRealMatrix() {
        Assert.assertEquals((Object)MatrixUtils.createRowRealMatrix((double[])this.row), (Object)new BlockRealMatrix(this.rowMatrix));
        try {
            MatrixUtils.createRowRealMatrix((double[])new double[0]);
            Assert.fail((String)"Expecting NotStrictlyPositiveException");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
        try {
            MatrixUtils.createRowRealMatrix(null);
            Assert.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateRowFieldMatrix() {
        Assert.assertEquals((Object)MatrixUtils.createRowFieldMatrix((FieldElement[])MatrixUtilsTest.asFraction(this.row)), (Object)new Array2DRowFieldMatrix((FieldElement[][])MatrixUtilsTest.asFraction(this.rowMatrix)));
        Assert.assertEquals((Object)MatrixUtils.createRowFieldMatrix((FieldElement[])this.fractionRow), (Object)new Array2DRowFieldMatrix((FieldElement[][])this.fractionRowMatrix));
        try {
            MatrixUtils.createRowFieldMatrix((FieldElement[])new Fraction[0]);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MatrixUtils.createRowFieldMatrix((FieldElement[])((Fraction[])null));
            Assert.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateColumnRealMatrix() {
        Assert.assertEquals((Object)MatrixUtils.createColumnRealMatrix((double[])this.col), (Object)new BlockRealMatrix(this.colMatrix));
        try {
            MatrixUtils.createColumnRealMatrix((double[])new double[0]);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MatrixUtils.createColumnRealMatrix(null);
            Assert.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateColumnFieldMatrix() {
        Assert.assertEquals((Object)MatrixUtils.createColumnFieldMatrix((FieldElement[])MatrixUtilsTest.asFraction(this.col)), (Object)new Array2DRowFieldMatrix((FieldElement[][])MatrixUtilsTest.asFraction(this.colMatrix)));
        Assert.assertEquals((Object)MatrixUtils.createColumnFieldMatrix((FieldElement[])this.fractionCol), (Object)new Array2DRowFieldMatrix((FieldElement[][])this.fractionColMatrix));
        try {
            MatrixUtils.createColumnFieldMatrix((FieldElement[])new Fraction[0]);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MatrixUtils.createColumnFieldMatrix((FieldElement[])((Fraction[])null));
            Assert.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    protected void checkIdentityMatrix(RealMatrix m) {
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                if (i == j) {
                    Assert.assertEquals((double)m.getEntry(i, j), (double)1.0, (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)m.getEntry(i, j), (double)0.0, (double)0.0);
            }
        }
    }

    @Test
    public void testCreateIdentityMatrix() {
        this.checkIdentityMatrix(MatrixUtils.createRealIdentityMatrix((int)3));
        this.checkIdentityMatrix(MatrixUtils.createRealIdentityMatrix((int)2));
        this.checkIdentityMatrix(MatrixUtils.createRealIdentityMatrix((int)1));
        try {
            MatrixUtils.createRealIdentityMatrix((int)0);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    protected void checkIdentityFieldMatrix(FieldMatrix<Fraction> m) {
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                if (i == j) {
                    Assert.assertEquals((Object)m.getEntry(i, j), (Object)Fraction.ONE);
                    continue;
                }
                Assert.assertEquals((Object)m.getEntry(i, j), (Object)Fraction.ZERO);
            }
        }
    }

    @Test
    public void testcreateFieldIdentityMatrix() {
        this.checkIdentityFieldMatrix((FieldMatrix<Fraction>)MatrixUtils.createFieldIdentityMatrix((Field)FractionField.getInstance(), (int)3));
        this.checkIdentityFieldMatrix((FieldMatrix<Fraction>)MatrixUtils.createFieldIdentityMatrix((Field)FractionField.getInstance(), (int)2));
        this.checkIdentityFieldMatrix((FieldMatrix<Fraction>)MatrixUtils.createFieldIdentityMatrix((Field)FractionField.getInstance(), (int)1));
        try {
            MatrixUtils.createRealIdentityMatrix((int)0);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBigFractionConverter() {
        BigFraction[][] bfData = new BigFraction[][]{{new BigFraction(1), new BigFraction(2), new BigFraction(3)}, {new BigFraction(2), new BigFraction(5), new BigFraction(3)}, {new BigFraction(1), new BigFraction(0), new BigFraction(8)}};
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])bfData, false);
        Array2DRowRealMatrix converted = MatrixUtils.bigFractionMatrixToRealMatrix((FieldMatrix)m);
        Array2DRowRealMatrix reference = new Array2DRowRealMatrix(this.testData, false);
        Assert.assertEquals((double)0.0, (double)converted.subtract((RealMatrix)reference).getNorm(), (double)0.0);
    }

    @Test
    public void testFractionConverter() {
        Fraction[][] fData = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(2), new Fraction(5), new Fraction(3)}, {new Fraction(1), new Fraction(0), new Fraction(8)}};
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])fData, false);
        Array2DRowRealMatrix converted = MatrixUtils.fractionMatrixToRealMatrix((FieldMatrix)m);
        Array2DRowRealMatrix reference = new Array2DRowRealMatrix(this.testData, false);
        Assert.assertEquals((double)0.0, (double)converted.subtract((RealMatrix)reference).getNorm(), (double)0.0);
    }

    public static final Fraction[][] asFraction(double[][] data) {
        Fraction[][] d = new Fraction[data.length][];
        try {
            for (int i = 0; i < data.length; ++i) {
                double[] dataI = data[i];
                Fraction[] dI = new Fraction[dataI.length];
                for (int j = 0; j < dataI.length; ++j) {
                    dI[j] = new Fraction(dataI[j]);
                }
                d[i] = dI;
            }
        }
        catch (FractionConversionException fce) {
            Assert.fail((String)fce.getMessage());
        }
        return d;
    }

    public static final Fraction[] asFraction(double[] data) {
        Fraction[] d = new Fraction[data.length];
        try {
            for (int i = 0; i < data.length; ++i) {
                d[i] = new Fraction(data[i]);
            }
        }
        catch (FractionConversionException fce) {
            Assert.fail((String)fce.getMessage());
        }
        return d;
    }

    @Test
    public void testSolveLowerTriangularSystem() {
        Array2DRowRealMatrix rm = new Array2DRowRealMatrix((double[][])new double[][]{{2.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 0.0}, {3.0, 3.0, 3.0, 0.0}, {3.0, 3.0, 3.0, 4.0}}, false);
        ArrayRealVector b = new ArrayRealVector(new double[]{2.0, 3.0, 4.0, 8.0}, false);
        MatrixUtils.solveLowerTriangularSystem((RealMatrix)rm, (RealVector)b);
        TestUtils.assertEquals(new double[]{1.0, 2.0, -1.66666666666667, 1.0}, b.toArray(), 1.0E-12);
    }

    @Test
    public void testSolveUpperTriangularSystem() {
        Array2DRowRealMatrix rm = new Array2DRowRealMatrix((double[][])new double[][]{{1.0, 2.0, 3.0}, {0.0, 1.0, 1.0}, {0.0, 0.0, 2.0}}, false);
        ArrayRealVector b = new ArrayRealVector(new double[]{8.0, 4.0, 2.0}, false);
        MatrixUtils.solveUpperTriangularSystem((RealMatrix)rm, (RealVector)b);
        TestUtils.assertEquals(new double[]{-1.0, 3.0, 1.0}, b.toArray(), 1.0E-12);
    }

    @Test
    public void testBlockInverse() {
        double[][] data = new double[][]{{-1.0, 0.0, 123.0, 4.0}, {-56.0, 78.9, -0.1, -23.4}, {5.67, 8.0, -9.0, 1011.0}, {12.0, 345.0, -67.8, 9.0}};
        Array2DRowRealMatrix m = new Array2DRowRealMatrix((double[][])data);
        int len = data.length;
        double tol = 1.0E-14;
        for (int splitIndex = 0; splitIndex < 3; ++splitIndex) {
            RealMatrix mInv = MatrixUtils.blockInverse((RealMatrix)m, (int)splitIndex);
            RealMatrix id = m.multiply(mInv);
            for (int i = 0; i < len; ++i) {
                for (int j = 0; j < len; ++j) {
                    double entry = id.getEntry(i, j);
                    if (i == j) {
                        Assert.assertEquals((String)("[" + i + "][" + j + "]"), (double)1.0, (double)entry, (double)1.0E-14);
                        continue;
                    }
                    Assert.assertEquals((String)("[" + i + "][" + j + "]"), (double)0.0, (double)entry, (double)1.0E-14);
                }
            }
        }
    }

    @Test(expected=SingularMatrixException.class)
    public void testBlockInverseNonInvertible() {
        double[][] data = new double[][]{{-1.0, 0.0, 123.0, 4.0}, {-56.0, 78.9, -0.1, -23.4}, {5.67, 8.0, -9.0, 1011.0}, {5.67, 8.0, -9.0, 1011.0}};
        MatrixUtils.blockInverse((RealMatrix)new Array2DRowRealMatrix((double[][])data), (int)2);
    }

    @Test
    public void testIsSymmetric() {
        double eps = Math.ulp(1.0);
        double[][] dataSym = new double[][]{{1.0, 2.0, 3.0}, {2.0, 2.0, 5.0}, {3.0, 5.0, 6.0}};
        Assert.assertTrue((boolean)MatrixUtils.isSymmetric((RealMatrix)MatrixUtils.createRealMatrix((double[][])dataSym), (double)eps));
        double[][] dataNonSym = new double[][]{{1.0, 2.0, -3.0}, {2.0, 2.0, 5.0}, {3.0, 5.0, 6.0}};
        Assert.assertFalse((boolean)MatrixUtils.isSymmetric((RealMatrix)MatrixUtils.createRealMatrix((double[][])dataNonSym), (double)eps));
    }

    @Test
    public void testIsSymmetricTolerance() {
        double eps = 1.0E-4;
        double[][] dataSym1 = new double[][]{{1.0, 1.0, 1.00009}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}};
        Assert.assertTrue((boolean)MatrixUtils.isSymmetric((RealMatrix)MatrixUtils.createRealMatrix((double[][])dataSym1), (double)1.0E-4));
        double[][] dataSym2 = new double[][]{{1.0, 1.0, 0.9999}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}};
        Assert.assertTrue((boolean)MatrixUtils.isSymmetric((RealMatrix)MatrixUtils.createRealMatrix((double[][])dataSym2), (double)1.0E-4));
        double[][] dataNonSym1 = new double[][]{{1.0, 1.0, 1.00011}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}};
        Assert.assertFalse((boolean)MatrixUtils.isSymmetric((RealMatrix)MatrixUtils.createRealMatrix((double[][])dataNonSym1), (double)1.0E-4));
        double[][] dataNonSym2 = new double[][]{{1.0, 1.0, 0.99989}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}};
        Assert.assertFalse((boolean)MatrixUtils.isSymmetric((RealMatrix)MatrixUtils.createRealMatrix((double[][])dataNonSym2), (double)1.0E-4));
    }

    @Test
    public void testCheckSymmetric1() {
        double[][] dataSym = new double[][]{{1.0, 2.0, 3.0}, {2.0, 2.0, 5.0}, {3.0, 5.0, 6.0}};
        MatrixUtils.checkSymmetric((RealMatrix)MatrixUtils.createRealMatrix((double[][])dataSym), (double)Math.ulp(1.0));
    }

    @Test(expected=NonSymmetricMatrixException.class)
    public void testCheckSymmetric2() {
        double[][] dataNonSym = new double[][]{{1.0, 2.0, -3.0}, {2.0, 2.0, 5.0}, {3.0, 5.0, 6.0}};
        MatrixUtils.checkSymmetric((RealMatrix)MatrixUtils.createRealMatrix((double[][])dataNonSym), (double)Math.ulp(1.0));
    }

    @Test(expected=SingularMatrixException.class)
    public void testInverseSingular() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])this.testData3x3Singular);
        MatrixUtils.inverse((RealMatrix)m);
    }

    @Test(expected=NonSquareMatrixException.class)
    public void testInverseNonSquare() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])this.testData3x4);
        MatrixUtils.inverse((RealMatrix)m);
    }

    @Test
    public void testInverseDiagonalMatrix() {
        double[] data = new double[]{1.0, 2.0, 3.0};
        DiagonalMatrix m = new DiagonalMatrix(data);
        RealMatrix inverse = MatrixUtils.inverse((RealMatrix)m);
        RealMatrix result = m.multiply(inverse);
        TestUtils.assertEquals("MatrixUtils.inverse() returns wrong result", MatrixUtils.createRealIdentityMatrix((int)data.length), result, Math.ulp(1.0));
    }

    @Test
    public void testInverseRealMatrix() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])this.testData);
        RealMatrix inverse = MatrixUtils.inverse((RealMatrix)m);
        RealMatrix result = m.multiply(inverse);
        TestUtils.assertEquals("MatrixUtils.inverse() returns wrong result", MatrixUtils.createRealIdentityMatrix((int)this.testData.length), result, 1.0E-12);
    }
}

