/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVectorAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class ArrayRealVectorTest
extends RealVectorAbstractTest {
    public RealVector create(double[] data) {
        return new ArrayRealVector(data, true);
    }

    @Test
    public void testConstructors() {
        double[] vec1 = new double[]{1.0, 2.0, 3.0};
        double[] vec3 = new double[]{7.0, 8.0, 9.0};
        double[] vec4 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        Double[] dvec1 = new Double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        ArrayRealVector v0 = new ArrayRealVector();
        Assert.assertEquals((String)"testData len", (long)0L, (long)v0.getDimension());
        ArrayRealVector v1 = new ArrayRealVector(7);
        Assert.assertEquals((String)"testData len", (long)7L, (long)v1.getDimension());
        Assert.assertEquals((String)"testData is 0.0 ", (double)0.0, (double)v1.getEntry(6), (double)0.0);
        ArrayRealVector v2 = new ArrayRealVector(5, 1.23);
        Assert.assertEquals((String)"testData len", (long)5L, (long)v2.getDimension());
        Assert.assertEquals((String)"testData is 1.23 ", (double)1.23, (double)v2.getEntry(4), (double)0.0);
        ArrayRealVector v3 = new ArrayRealVector(vec1);
        Assert.assertEquals((String)"testData len", (long)3L, (long)v3.getDimension());
        Assert.assertEquals((String)"testData is 2.0 ", (double)2.0, (double)v3.getEntry(1), (double)0.0);
        ArrayRealVector v3_bis = new ArrayRealVector(vec1, true);
        Assert.assertEquals((String)"testData len", (long)3L, (long)v3_bis.getDimension());
        Assert.assertEquals((String)"testData is 2.0 ", (double)2.0, (double)v3_bis.getEntry(1), (double)0.0);
        Assert.assertNotSame((Object)v3_bis.getDataRef(), (Object)vec1);
        Assert.assertNotSame((Object)v3_bis.toArray(), (Object)vec1);
        ArrayRealVector v3_ter = new ArrayRealVector(vec1, false);
        Assert.assertEquals((String)"testData len", (long)3L, (long)v3_ter.getDimension());
        Assert.assertEquals((String)"testData is 2.0 ", (double)2.0, (double)v3_ter.getEntry(1), (double)0.0);
        Assert.assertSame((Object)v3_ter.getDataRef(), (Object)vec1);
        Assert.assertNotSame((Object)v3_ter.toArray(), (Object)vec1);
        ArrayRealVector v4 = new ArrayRealVector(vec4, 3, 2);
        Assert.assertEquals((String)"testData len", (long)2L, (long)v4.getDimension());
        Assert.assertEquals((String)"testData is 4.0 ", (double)4.0, (double)v4.getEntry(0), (double)0.0);
        try {
            new ArrayRealVector(vec4, 8, 3);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        ArrayRealVector v5_i = new ArrayRealVector(dvec1);
        Assert.assertEquals((String)"testData len", (long)9L, (long)v5_i.getDimension());
        Assert.assertEquals((String)"testData is 9.0 ", (double)9.0, (double)v5_i.getEntry(8), (double)0.0);
        ArrayRealVector v5 = new ArrayRealVector(dvec1);
        Assert.assertEquals((String)"testData len", (long)9L, (long)v5.getDimension());
        Assert.assertEquals((String)"testData is 9.0 ", (double)9.0, (double)v5.getEntry(8), (double)0.0);
        ArrayRealVector v6 = new ArrayRealVector(dvec1, 3, 2);
        Assert.assertEquals((String)"testData len", (long)2L, (long)v6.getDimension());
        Assert.assertEquals((String)"testData is 4.0 ", (double)4.0, (double)v6.getEntry(0), (double)0.0);
        try {
            new ArrayRealVector(dvec1, 8, 3);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        ArrayRealVector v7 = new ArrayRealVector(v1);
        Assert.assertEquals((String)"testData len", (long)7L, (long)v7.getDimension());
        Assert.assertEquals((String)"testData is 0.0 ", (double)0.0, (double)v7.getEntry(6), (double)0.0);
        RealVectorAbstractTest.RealVectorTestImpl v7_i = new RealVectorAbstractTest.RealVectorTestImpl(vec1);
        ArrayRealVector v7_2 = new ArrayRealVector((RealVector)v7_i);
        Assert.assertEquals((String)"testData len", (long)3L, (long)v7_2.getDimension());
        Assert.assertEquals((String)"testData is 0.0 ", (double)2.0, (double)v7_2.getEntry(1), (double)0.0);
        ArrayRealVector v8 = new ArrayRealVector(v1, true);
        Assert.assertEquals((String)"testData len", (long)7L, (long)v8.getDimension());
        Assert.assertEquals((String)"testData is 0.0 ", (double)0.0, (double)v8.getEntry(6), (double)0.0);
        Assert.assertNotSame((String)"testData not same object ", (Object)v1.getDataRef(), (Object)v8.getDataRef());
        ArrayRealVector v8_2 = new ArrayRealVector(v1, false);
        Assert.assertEquals((String)"testData len", (long)7L, (long)v8_2.getDimension());
        Assert.assertEquals((String)"testData is 0.0 ", (double)0.0, (double)v8_2.getEntry(6), (double)0.0);
        Assert.assertEquals((String)"testData same object ", (Object)v1.getDataRef(), (Object)v8_2.getDataRef());
        ArrayRealVector v9 = new ArrayRealVector(v1, v3);
        Assert.assertEquals((String)"testData len", (long)10L, (long)v9.getDimension());
        Assert.assertEquals((String)"testData is 1.0 ", (double)1.0, (double)v9.getEntry(7), (double)0.0);
        ArrayRealVector v10 = new ArrayRealVector(v2, (RealVector)new RealVectorAbstractTest.RealVectorTestImpl(vec3));
        Assert.assertEquals((String)"testData len", (long)8L, (long)v10.getDimension());
        Assert.assertEquals((String)"testData is 1.23 ", (double)1.23, (double)v10.getEntry(4), (double)0.0);
        Assert.assertEquals((String)"testData is 7.0 ", (double)7.0, (double)v10.getEntry(5), (double)0.0);
        ArrayRealVector v11 = new ArrayRealVector((RealVector)new RealVectorAbstractTest.RealVectorTestImpl(vec3), v2);
        Assert.assertEquals((String)"testData len", (long)8L, (long)v11.getDimension());
        Assert.assertEquals((String)"testData is 9.0 ", (double)9.0, (double)v11.getEntry(2), (double)0.0);
        Assert.assertEquals((String)"testData is 1.23 ", (double)1.23, (double)v11.getEntry(3), (double)0.0);
        ArrayRealVector v12 = new ArrayRealVector(v2, vec3);
        Assert.assertEquals((String)"testData len", (long)8L, (long)v12.getDimension());
        Assert.assertEquals((String)"testData is 1.23 ", (double)1.23, (double)v12.getEntry(4), (double)0.0);
        Assert.assertEquals((String)"testData is 7.0 ", (double)7.0, (double)v12.getEntry(5), (double)0.0);
        ArrayRealVector v13 = new ArrayRealVector(vec3, v2);
        Assert.assertEquals((String)"testData len", (long)8L, (long)v13.getDimension());
        Assert.assertEquals((String)"testData is 9.0 ", (double)9.0, (double)v13.getEntry(2), (double)0.0);
        Assert.assertEquals((String)"testData is 1.23 ", (double)1.23, (double)v13.getEntry(3), (double)0.0);
        ArrayRealVector v14 = new ArrayRealVector(vec3, vec4);
        Assert.assertEquals((String)"testData len", (long)12L, (long)v14.getDimension());
        Assert.assertEquals((String)"testData is 9.0 ", (double)9.0, (double)v14.getEntry(2), (double)0.0);
        Assert.assertEquals((String)"testData is 1.0 ", (double)1.0, (double)v14.getEntry(3), (double)0.0);
    }

    @Test
    public void testGetDataRef() {
        double[] data = new double[]{1.0, 2.0, 3.0, 4.0};
        ArrayRealVector v = new ArrayRealVector(data);
        v.getDataRef()[0] = 0.0;
        Assert.assertEquals((String)"", (double)0.0, (double)v.getEntry(0), (double)0.0);
    }

    @Test
    public void testPredicates() {
        Assert.assertEquals((long)this.create(new double[]{Double.NaN, 1.0, 2.0}).hashCode(), (long)this.create(new double[]{0.0, Double.NaN, 2.0}).hashCode());
        Assert.assertTrue((this.create(new double[]{Double.NaN, 1.0, 2.0}).hashCode() != this.create(new double[]{0.0, 1.0, 2.0}).hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testZeroVectors() {
        Assert.assertEquals((long)0L, (long)new ArrayRealVector(new double[0]).getDimension());
        Assert.assertEquals((long)0L, (long)new ArrayRealVector(new double[0], true).getDimension());
        Assert.assertEquals((long)0L, (long)new ArrayRealVector(new double[0], false).getDimension());
    }
}

