/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathArithmeticException;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.Space;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.Vector;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well1024a;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class Vector3DTest {
    @Test
    public void testConstructors() throws DimensionMismatchException {
        double r = FastMath.sqrt((double)2.0) / 2.0;
        this.checkVector(new Vector3D(2.0, new Vector3D(1.0471975511965976, -0.7853981633974483)), r, r * FastMath.sqrt((double)3.0), -2.0 * r);
        this.checkVector(new Vector3D(2.0, Vector3D.PLUS_I, -3.0, Vector3D.MINUS_K), 2.0, 0.0, 3.0);
        this.checkVector(new Vector3D(2.0, Vector3D.PLUS_I, 5.0, Vector3D.PLUS_J, -3.0, Vector3D.MINUS_K), 2.0, 5.0, 3.0);
        this.checkVector(new Vector3D(2.0, Vector3D.PLUS_I, 5.0, Vector3D.PLUS_J, 5.0, Vector3D.MINUS_J, -3.0, Vector3D.MINUS_K), 2.0, 0.0, 3.0);
        this.checkVector(new Vector3D(new double[]{2.0, 5.0, -3.0}), 2.0, 5.0, -3.0);
    }

    @Test
    public void testSpace() {
        Space space = new Vector3D(1.0, 2.0, 2.0).getSpace();
        Assert.assertEquals((long)3L, (long)space.getDimension());
        Assert.assertEquals((long)2L, (long)space.getSubSpace().getDimension());
        Space deserialized = (Space)TestUtils.serializeAndRecover(space);
        Assert.assertTrue((space == deserialized ? 1 : 0) != 0);
    }

    @Test
    public void testZero() {
        Assert.assertEquals((double)0.0, (double)new Vector3D(1.0, 2.0, 2.0).getZero().getNorm(), (double)1.0E-15);
    }

    @Test
    public void testEquals() {
        Vector3D u1 = new Vector3D(1.0, 2.0, 3.0);
        Vector3D u2 = new Vector3D(1.0, 2.0, 3.0);
        Assert.assertTrue((boolean)u1.equals((Object)u1));
        Assert.assertTrue((boolean)u1.equals((Object)u2));
        Assert.assertFalse((boolean)u1.equals((Object)new Rotation(1.0, 0.0, 0.0, 0.0, false)));
        Assert.assertFalse((boolean)u1.equals((Object)new Vector3D(1.0, 2.0, 3.0 + 10.0 * Precision.EPSILON)));
        Assert.assertFalse((boolean)u1.equals((Object)new Vector3D(1.0, 2.0 + 10.0 * Precision.EPSILON, 3.0)));
        Assert.assertFalse((boolean)u1.equals((Object)new Vector3D(1.0 + 10.0 * Precision.EPSILON, 2.0, 3.0)));
        Assert.assertTrue((boolean)new Vector3D(0.0, Double.NaN, 0.0).equals((Object)new Vector3D(0.0, 0.0, Double.NaN)));
    }

    @Test
    public void testHash() {
        Assert.assertEquals((long)new Vector3D(0.0, Double.NaN, 0.0).hashCode(), (long)new Vector3D(0.0, 0.0, Double.NaN).hashCode());
        Vector3D u = new Vector3D(1.0, 2.0, 3.0);
        Vector3D v = new Vector3D(1.0, 2.0, 3.0 + 10.0 * Precision.EPSILON);
        Assert.assertTrue((u.hashCode() != v.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testInfinite() {
        Assert.assertTrue((boolean)new Vector3D(1.0, 1.0, Double.NEGATIVE_INFINITY).isInfinite());
        Assert.assertTrue((boolean)new Vector3D(1.0, Double.NEGATIVE_INFINITY, 1.0).isInfinite());
        Assert.assertTrue((boolean)new Vector3D(Double.NEGATIVE_INFINITY, 1.0, 1.0).isInfinite());
        Assert.assertFalse((boolean)new Vector3D(1.0, 1.0, 2.0).isInfinite());
        Assert.assertFalse((boolean)new Vector3D(1.0, Double.NaN, Double.NEGATIVE_INFINITY).isInfinite());
    }

    @Test
    public void testNaN() {
        Assert.assertTrue((boolean)new Vector3D(1.0, 1.0, Double.NaN).isNaN());
        Assert.assertTrue((boolean)new Vector3D(1.0, Double.NaN, 1.0).isNaN());
        Assert.assertTrue((boolean)new Vector3D(Double.NaN, 1.0, 1.0).isNaN());
        Assert.assertFalse((boolean)new Vector3D(1.0, 1.0, 2.0).isNaN());
        Assert.assertFalse((boolean)new Vector3D(1.0, 1.0, Double.NEGATIVE_INFINITY).isNaN());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"{3; 2; 1}", (Object)new Vector3D(3.0, 2.0, 1.0).toString());
        DecimalFormat format = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
        Assert.assertEquals((Object)"{3.000; 2.000; 1.000}", (Object)new Vector3D(3.0, 2.0, 1.0).toString((NumberFormat)format));
    }

    @Test(expected=DimensionMismatchException.class)
    public void testWrongDimension() throws DimensionMismatchException {
        new Vector3D(new double[]{2.0, 5.0});
    }

    @Test
    public void testCoordinates() {
        Vector3D v = new Vector3D(1.0, 2.0, 3.0);
        Assert.assertTrue((FastMath.abs((double)(v.getX() - 1.0)) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(v.getY() - 2.0)) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(v.getZ() - 3.0)) < 1.0E-12 ? 1 : 0) != 0);
        double[] coordinates = v.toArray();
        Assert.assertTrue((FastMath.abs((double)(coordinates[0] - 1.0)) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(coordinates[1] - 2.0)) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(coordinates[2] - 3.0)) < 1.0E-12 ? 1 : 0) != 0);
    }

    @Test
    public void testNorm1() {
        Assert.assertEquals((double)0.0, (double)Vector3D.ZERO.getNorm1(), (double)0.0);
        Assert.assertEquals((double)6.0, (double)new Vector3D(1.0, -2.0, 3.0).getNorm1(), (double)0.0);
    }

    @Test
    public void testNorm() {
        Assert.assertEquals((double)0.0, (double)Vector3D.ZERO.getNorm(), (double)0.0);
        Assert.assertEquals((double)FastMath.sqrt((double)14.0), (double)new Vector3D(1.0, 2.0, 3.0).getNorm(), (double)1.0E-12);
    }

    @Test
    public void testNormSq() {
        Assert.assertEquals((double)0.0, (double)new Vector3D(0.0, 0.0, 0.0).getNormSq(), (double)0.0);
        Assert.assertEquals((double)14.0, (double)new Vector3D(1.0, 2.0, 3.0).getNormSq(), (double)1.0E-12);
    }

    @Test
    public void testNormInf() {
        Assert.assertEquals((double)0.0, (double)Vector3D.ZERO.getNormInf(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)new Vector3D(1.0, -2.0, 3.0).getNormInf(), (double)0.0);
    }

    @Test
    public void testDistance1() {
        Vector3D v1 = new Vector3D(1.0, -2.0, 3.0);
        Vector3D v2 = new Vector3D(-4.0, 2.0, 0.0);
        Assert.assertEquals((double)0.0, (double)Vector3D.distance1((Vector3D)Vector3D.MINUS_I, (Vector3D)Vector3D.MINUS_I), (double)0.0);
        Assert.assertEquals((double)12.0, (double)Vector3D.distance1((Vector3D)v1, (Vector3D)v2), (double)1.0E-12);
        Assert.assertEquals((double)v1.subtract((Vector)v2).getNorm1(), (double)Vector3D.distance1((Vector3D)v1, (Vector3D)v2), (double)1.0E-12);
    }

    @Test
    public void testDistance() {
        Vector3D v1 = new Vector3D(1.0, -2.0, 3.0);
        Vector3D v2 = new Vector3D(-4.0, 2.0, 0.0);
        Assert.assertEquals((double)0.0, (double)Vector3D.distance((Vector3D)Vector3D.MINUS_I, (Vector3D)Vector3D.MINUS_I), (double)0.0);
        Assert.assertEquals((double)FastMath.sqrt((double)50.0), (double)Vector3D.distance((Vector3D)v1, (Vector3D)v2), (double)1.0E-12);
        Assert.assertEquals((double)v1.subtract((Vector)v2).getNorm(), (double)Vector3D.distance((Vector3D)v1, (Vector3D)v2), (double)1.0E-12);
    }

    @Test
    public void testDistanceSq() {
        Vector3D v1 = new Vector3D(1.0, -2.0, 3.0);
        Vector3D v2 = new Vector3D(-4.0, 2.0, 0.0);
        Assert.assertEquals((double)0.0, (double)Vector3D.distanceSq((Vector3D)Vector3D.MINUS_I, (Vector3D)Vector3D.MINUS_I), (double)0.0);
        Assert.assertEquals((double)50.0, (double)Vector3D.distanceSq((Vector3D)v1, (Vector3D)v2), (double)1.0E-12);
        Assert.assertEquals((double)(Vector3D.distance((Vector3D)v1, (Vector3D)v2) * Vector3D.distance((Vector3D)v1, (Vector3D)v2)), (double)Vector3D.distanceSq((Vector3D)v1, (Vector3D)v2), (double)1.0E-12);
    }

    @Test
    public void testDistanceInf() {
        Vector3D v1 = new Vector3D(1.0, -2.0, 3.0);
        Vector3D v2 = new Vector3D(-4.0, 2.0, 0.0);
        Assert.assertEquals((double)0.0, (double)Vector3D.distanceInf((Vector3D)Vector3D.MINUS_I, (Vector3D)Vector3D.MINUS_I), (double)0.0);
        Assert.assertEquals((double)5.0, (double)Vector3D.distanceInf((Vector3D)v1, (Vector3D)v2), (double)1.0E-12);
        Assert.assertEquals((double)v1.subtract((Vector)v2).getNormInf(), (double)Vector3D.distanceInf((Vector3D)v1, (Vector3D)v2), (double)1.0E-12);
    }

    @Test
    public void testSubtract() {
        Vector3D v1 = new Vector3D(1.0, 2.0, 3.0);
        Vector3D v2 = new Vector3D(-3.0, -2.0, -1.0);
        v1 = v1.subtract((Vector)v2);
        this.checkVector(v1, 4.0, 4.0, 4.0);
        this.checkVector(v2.subtract((Vector)v1), -7.0, -6.0, -5.0);
        this.checkVector(v2.subtract(3.0, (Vector)v1), -15.0, -14.0, -13.0);
    }

    @Test
    public void testAdd() {
        Vector3D v1 = new Vector3D(1.0, 2.0, 3.0);
        Vector3D v2 = new Vector3D(-3.0, -2.0, -1.0);
        v1 = v1.add((Vector)v2);
        this.checkVector(v1, -2.0, 0.0, 2.0);
        this.checkVector(v2.add((Vector)v1), -5.0, -2.0, 1.0);
        this.checkVector(v2.add(3.0, (Vector)v1), -9.0, -2.0, 5.0);
    }

    @Test
    public void testScalarProduct() {
        Vector3D v = new Vector3D(1.0, 2.0, 3.0);
        v = v.scalarMultiply(3.0);
        this.checkVector(v, 3.0, 6.0, 9.0);
        this.checkVector(v.scalarMultiply(0.5), 1.5, 3.0, 4.5);
    }

    @Test
    public void testVectorialProducts() {
        Vector3D v1 = new Vector3D(2.0, 1.0, -4.0);
        Vector3D v2 = new Vector3D(3.0, 1.0, -1.0);
        Assert.assertTrue((FastMath.abs((double)(Vector3D.dotProduct((Vector3D)v1, (Vector3D)v2) - 11.0)) < 1.0E-12 ? 1 : 0) != 0);
        Vector3D v3 = Vector3D.crossProduct((Vector3D)v1, (Vector3D)v2);
        this.checkVector(v3, 3.0, -10.0, -1.0);
        Assert.assertTrue((FastMath.abs((double)Vector3D.dotProduct((Vector3D)v1, (Vector3D)v3)) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)Vector3D.dotProduct((Vector3D)v2, (Vector3D)v3)) < 1.0E-12 ? 1 : 0) != 0);
    }

    @Test
    public void testCrossProductCancellation() {
        Vector3D v1 = new Vector3D(9.070467121E9, 4.53523356E9, 1.0);
        Vector3D v2 = new Vector3D(9.070467123E9, 4.535233561E9, 1.0);
        this.checkVector(Vector3D.crossProduct((Vector3D)v1, (Vector3D)v2), -1.0, 2.0, 1.0);
        double scale = FastMath.scalb((double)1.0, (int)100);
        Vector3D big1 = new Vector3D(scale, v1);
        Vector3D small2 = new Vector3D(1.0 / scale, v2);
        this.checkVector(Vector3D.crossProduct((Vector3D)big1, (Vector3D)small2), -1.0, 2.0, 1.0);
    }

    @Test
    public void testAngular() {
        Assert.assertEquals((double)0.0, (double)Vector3D.PLUS_I.getAlpha(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)Vector3D.PLUS_I.getDelta(), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)Vector3D.PLUS_J.getAlpha(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)Vector3D.PLUS_J.getDelta(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)Vector3D.PLUS_K.getAlpha(), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)Vector3D.PLUS_K.getDelta(), (double)1.0E-10);
        Vector3D u = new Vector3D(-1.0, 1.0, -1.0);
        Assert.assertEquals((double)2.356194490192345, (double)u.getAlpha(), (double)1.0E-10);
        Assert.assertEquals((double)(-1.0 / FastMath.sqrt((double)3.0)), (double)FastMath.sin((double)u.getDelta()), (double)1.0E-10);
    }

    @Test
    public void testAngularSeparation() throws MathArithmeticException {
        Vector3D v1 = new Vector3D(2.0, -1.0, 4.0);
        Vector3D k = v1.normalize();
        Vector3D i = k.orthogonal();
        Vector3D v2 = k.scalarMultiply(FastMath.cos((double)1.2)).add((Vector)i.scalarMultiply(FastMath.sin((double)1.2)));
        Assert.assertTrue((FastMath.abs((double)(Vector3D.angle((Vector3D)v1, (Vector3D)v2) - 1.2)) < 1.0E-12 ? 1 : 0) != 0);
    }

    @Test
    public void testNormalize() throws MathArithmeticException {
        Assert.assertEquals((double)1.0, (double)new Vector3D(5.0, -4.0, 2.0).normalize().getNorm(), (double)1.0E-12);
        try {
            Vector3D.ZERO.normalize();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testNegate() {
        this.checkVector(new Vector3D(0.1, 2.5, 1.3).negate(), -0.1, -2.5, -1.3);
    }

    @Test
    public void testOrthogonal() throws MathArithmeticException {
        Vector3D v1 = new Vector3D(0.1, 2.5, 1.3);
        Assert.assertEquals((double)0.0, (double)Vector3D.dotProduct((Vector3D)v1, (Vector3D)v1.orthogonal()), (double)1.0E-12);
        Vector3D v2 = new Vector3D(2.3, -0.003, 7.6);
        Assert.assertEquals((double)0.0, (double)Vector3D.dotProduct((Vector3D)v2, (Vector3D)v2.orthogonal()), (double)1.0E-12);
        Vector3D v3 = new Vector3D(-1.7, 1.4, 0.2);
        Assert.assertEquals((double)0.0, (double)Vector3D.dotProduct((Vector3D)v3, (Vector3D)v3.orthogonal()), (double)1.0E-12);
        Vector3D v4 = new Vector3D(4.2, 0.1, -1.8);
        Assert.assertEquals((double)0.0, (double)Vector3D.dotProduct((Vector3D)v4, (Vector3D)v4.orthogonal()), (double)1.0E-12);
        try {
            new Vector3D(0.0, 0.0, 0.0).orthogonal();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testAngle() throws MathArithmeticException {
        Assert.assertEquals((double)0.22572612855273394, (double)Vector3D.angle((Vector3D)new Vector3D(1.0, 2.0, 3.0), (Vector3D)new Vector3D(4.0, 5.0, 6.0)), (double)1.0E-12);
        Assert.assertEquals((double)7.985956206861066E-8, (double)Vector3D.angle((Vector3D)new Vector3D(1.0, 2.0, 3.0), (Vector3D)new Vector3D(2.0, 4.0, 6.000001)), (double)1.0E-12);
        Assert.assertEquals((double)3.141592573730231, (double)Vector3D.angle((Vector3D)new Vector3D(1.0, 2.0, 3.0), (Vector3D)new Vector3D(-2.0, -4.0, -6.000001)), (double)1.0E-12);
        try {
            Vector3D.angle((Vector3D)Vector3D.ZERO, (Vector3D)Vector3D.PLUS_I);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testAccurateDotProduct() {
        Vector3D u1 = new Vector3D(-4921140.837095533, -2.1512094250440013E7, -890093.2794263769);
        Vector3D u2 = new Vector3D(-2.7238580938724895E9, -2.1696649213418756E9, 6.7496887088853004E10);
        double sNaive = u1.getX() * u2.getX() + u1.getY() * u2.getY() + u1.getZ() * u2.getZ();
        double sAccurate = u1.dotProduct((Vector)u2);
        Assert.assertEquals((double)0.0, (double)sNaive, (double)1.0E-30);
        Assert.assertEquals((double)-1.8551294182586249, (double)sAccurate, (double)1.0E-15);
    }

    @Test
    public void testDotProduct() {
        Well1024a random = new Well1024a(553267312521321234L);
        for (int i = 0; i < 10000; ++i) {
            double ux = 10000.0 * random.nextDouble();
            double uy = 10000.0 * random.nextDouble();
            double uz = 10000.0 * random.nextDouble();
            double vx = 10000.0 * random.nextDouble();
            double vy = 10000.0 * random.nextDouble();
            double vz = 10000.0 * random.nextDouble();
            double sNaive = ux * vx + uy * vy + uz * vz;
            double sAccurate = new Vector3D(ux, uy, uz).dotProduct((Vector)new Vector3D(vx, vy, vz));
            Assert.assertEquals((double)sNaive, (double)sAccurate, (double)(2.5E-16 * sAccurate));
        }
    }

    @Test
    public void testAccurateCrossProduct() {
        Vector3D u1 = new Vector3D(-4921140.837095533, -2.1512094250440013E7, -890093.2794263769);
        Vector3D u2 = new Vector3D(836593.9423062406, 3657056.0225748024, 151315.85750248405);
        Vector3D u3 = new Vector3D(6.913547321211624E-4, -1.2542955621103424E-4, -7.90930104102975E-4);
        Vector3D cNaive = new Vector3D(u1.getY() * u2.getZ() - u1.getZ() * u2.getY(), u1.getZ() * u2.getX() - u1.getX() * u2.getZ(), u1.getX() * u2.getY() - u1.getY() * u2.getX());
        Vector3D cAccurate = u1.crossProduct((Vector)u2);
        Assert.assertTrue((u3.distance((Vector)cNaive) > 2.9 * u3.getNorm() ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)u3.distance((Vector)cAccurate), (double)(1.0E-30 * cAccurate.getNorm()));
    }

    @Test
    public void testCrossProduct() {
        Well1024a random = new Well1024a(885362227452043214L);
        for (int i = 0; i < 10000; ++i) {
            double ux = 10000.0 * random.nextDouble();
            double uy = 10000.0 * random.nextDouble();
            double uz = 10000.0 * random.nextDouble();
            double vx = 10000.0 * random.nextDouble();
            double vy = 10000.0 * random.nextDouble();
            double vz = 10000.0 * random.nextDouble();
            Vector3D cNaive = new Vector3D(uy * vz - uz * vy, uz * vx - ux * vz, ux * vy - uy * vx);
            Vector3D cAccurate = new Vector3D(ux, uy, uz).crossProduct((Vector)new Vector3D(vx, vy, vz));
            Assert.assertEquals((double)0.0, (double)cAccurate.distance((Vector)cNaive), (double)(6.0E-15 * cAccurate.getNorm()));
        }
    }

    private void checkVector(Vector3D v, double x, double y, double z) {
        Assert.assertEquals((double)x, (double)v.getX(), (double)1.0E-12);
        Assert.assertEquals((double)y, (double)v.getY(), (double)1.0E-12);
        Assert.assertEquals((double)z, (double)v.getZ(), (double)1.0E-12);
    }
}

