/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathArithmeticException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.Vector;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.CardanEulerSingularityException;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.NotARotationMatrixException;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.RotationOrder;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathUtils;
import org.junit.Assert;
import org.junit.Test;

public class RotationTest {
    @Test
    public void testIdentity() {
        Rotation r = Rotation.IDENTITY;
        this.checkVector(r.applyTo(Vector3D.PLUS_I), Vector3D.PLUS_I);
        this.checkVector(r.applyTo(Vector3D.PLUS_J), Vector3D.PLUS_J);
        this.checkVector(r.applyTo(Vector3D.PLUS_K), Vector3D.PLUS_K);
        this.checkAngle(r.getAngle(), 0.0);
        r = new Rotation(-1.0, 0.0, 0.0, 0.0, false);
        this.checkVector(r.applyTo(Vector3D.PLUS_I), Vector3D.PLUS_I);
        this.checkVector(r.applyTo(Vector3D.PLUS_J), Vector3D.PLUS_J);
        this.checkVector(r.applyTo(Vector3D.PLUS_K), Vector3D.PLUS_K);
        this.checkAngle(r.getAngle(), 0.0);
        r = new Rotation(42.0, 0.0, 0.0, 0.0, true);
        this.checkVector(r.applyTo(Vector3D.PLUS_I), Vector3D.PLUS_I);
        this.checkVector(r.applyTo(Vector3D.PLUS_J), Vector3D.PLUS_J);
        this.checkVector(r.applyTo(Vector3D.PLUS_K), Vector3D.PLUS_K);
        this.checkAngle(r.getAngle(), 0.0);
    }

    @Test
    @Deprecated
    public void testAxisAngleDeprecated() throws MathIllegalArgumentException {
        Rotation r = new Rotation(new Vector3D(10.0, 10.0, 10.0), 2.0943951023931953);
        this.checkVector(r.applyTo(Vector3D.PLUS_I), Vector3D.PLUS_J);
        this.checkVector(r.applyTo(Vector3D.PLUS_J), Vector3D.PLUS_K);
        this.checkVector(r.applyTo(Vector3D.PLUS_K), Vector3D.PLUS_I);
        double s = 1.0 / FastMath.sqrt((double)3.0);
        this.checkVector(r.getAxis(), new Vector3D(s, s, s));
        this.checkAngle(r.getAngle(), 2.0943951023931953);
        try {
            new Rotation(new Vector3D(0.0, 0.0, 0.0), 2.0943951023931953);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        r = new Rotation(Vector3D.PLUS_K, 4.71238898038469);
        this.checkVector(r.getAxis(), new Vector3D(0.0, 0.0, -1.0));
        this.checkAngle(r.getAngle(), 1.5707963267948966);
        r = new Rotation(Vector3D.PLUS_J, Math.PI);
        this.checkVector(r.getAxis(), Vector3D.PLUS_J);
        this.checkAngle(r.getAngle(), Math.PI);
        this.checkVector(Rotation.IDENTITY.getAxis(), Vector3D.PLUS_I);
    }

    @Test
    public void testAxisAngleVectorOperator() throws MathIllegalArgumentException {
        Rotation r = new Rotation(new Vector3D(10.0, 10.0, 10.0), 2.0943951023931953, RotationConvention.VECTOR_OPERATOR);
        this.checkVector(r.applyTo(Vector3D.PLUS_I), Vector3D.PLUS_J);
        this.checkVector(r.applyTo(Vector3D.PLUS_J), Vector3D.PLUS_K);
        this.checkVector(r.applyTo(Vector3D.PLUS_K), Vector3D.PLUS_I);
        double s = 1.0 / FastMath.sqrt((double)3.0);
        this.checkVector(r.getAxis(RotationConvention.VECTOR_OPERATOR), new Vector3D(s, s, s));
        this.checkVector(r.getAxis(RotationConvention.FRAME_TRANSFORM), new Vector3D(-s, -s, -s));
        this.checkAngle(r.getAngle(), 2.0943951023931953);
        try {
            new Rotation(new Vector3D(0.0, 0.0, 0.0), 2.0943951023931953, RotationConvention.VECTOR_OPERATOR);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        r = new Rotation(Vector3D.PLUS_K, 4.71238898038469, RotationConvention.VECTOR_OPERATOR);
        this.checkVector(r.getAxis(RotationConvention.VECTOR_OPERATOR), new Vector3D(0.0, 0.0, -1.0));
        this.checkVector(r.getAxis(RotationConvention.FRAME_TRANSFORM), new Vector3D(0.0, 0.0, 1.0));
        this.checkAngle(r.getAngle(), 1.5707963267948966);
        r = new Rotation(Vector3D.PLUS_J, Math.PI, RotationConvention.VECTOR_OPERATOR);
        this.checkVector(r.getAxis(RotationConvention.VECTOR_OPERATOR), Vector3D.PLUS_J);
        this.checkVector(r.getAxis(RotationConvention.FRAME_TRANSFORM), Vector3D.MINUS_J);
        this.checkAngle(r.getAngle(), Math.PI);
        this.checkVector(Rotation.IDENTITY.getAxis(RotationConvention.VECTOR_OPERATOR), Vector3D.PLUS_I);
        this.checkVector(Rotation.IDENTITY.getAxis(RotationConvention.FRAME_TRANSFORM), Vector3D.MINUS_I);
    }

    @Test
    public void testAxisAngleFrameTransform() throws MathIllegalArgumentException {
        Rotation r = new Rotation(new Vector3D(10.0, 10.0, 10.0), 2.0943951023931953, RotationConvention.FRAME_TRANSFORM);
        this.checkVector(r.applyTo(Vector3D.PLUS_I), Vector3D.PLUS_K);
        this.checkVector(r.applyTo(Vector3D.PLUS_J), Vector3D.PLUS_I);
        this.checkVector(r.applyTo(Vector3D.PLUS_K), Vector3D.PLUS_J);
        double s = 1.0 / FastMath.sqrt((double)3.0);
        this.checkVector(r.getAxis(RotationConvention.FRAME_TRANSFORM), new Vector3D(s, s, s));
        this.checkVector(r.getAxis(RotationConvention.VECTOR_OPERATOR), new Vector3D(-s, -s, -s));
        this.checkAngle(r.getAngle(), 2.0943951023931953);
        try {
            new Rotation(new Vector3D(0.0, 0.0, 0.0), 2.0943951023931953, RotationConvention.FRAME_TRANSFORM);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        r = new Rotation(Vector3D.PLUS_K, 4.71238898038469, RotationConvention.FRAME_TRANSFORM);
        this.checkVector(r.getAxis(RotationConvention.FRAME_TRANSFORM), new Vector3D(0.0, 0.0, -1.0));
        this.checkVector(r.getAxis(RotationConvention.VECTOR_OPERATOR), new Vector3D(0.0, 0.0, 1.0));
        this.checkAngle(r.getAngle(), 1.5707963267948966);
        r = new Rotation(Vector3D.PLUS_J, Math.PI, RotationConvention.FRAME_TRANSFORM);
        this.checkVector(r.getAxis(RotationConvention.FRAME_TRANSFORM), Vector3D.PLUS_J);
        this.checkVector(r.getAxis(RotationConvention.VECTOR_OPERATOR), Vector3D.MINUS_J);
        this.checkAngle(r.getAngle(), Math.PI);
        this.checkVector(Rotation.IDENTITY.getAxis(RotationConvention.FRAME_TRANSFORM), Vector3D.MINUS_I);
        this.checkVector(Rotation.IDENTITY.getAxis(RotationConvention.VECTOR_OPERATOR), Vector3D.PLUS_I);
    }

    @Test
    public void testRevertDeprecated() {
        Rotation r = new Rotation(0.001, 0.36, 0.48, 0.8, true);
        Rotation reverted = r.revert();
        this.checkRotation(r.applyTo(reverted), 1.0, 0.0, 0.0, 0.0);
        this.checkRotation(reverted.applyTo(r), 1.0, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)r.getAngle(), (double)reverted.getAngle(), (double)1.0E-12);
        Assert.assertEquals((double)-1.0, (double)Vector3D.dotProduct((Vector3D)r.getAxis(RotationConvention.VECTOR_OPERATOR), (Vector3D)reverted.getAxis(RotationConvention.VECTOR_OPERATOR)), (double)1.0E-12);
    }

    @Test
    public void testRevertVectorOperator() {
        Rotation r = new Rotation(0.001, 0.36, 0.48, 0.8, true);
        Rotation reverted = r.revert();
        this.checkRotation(r.compose(reverted, RotationConvention.VECTOR_OPERATOR), 1.0, 0.0, 0.0, 0.0);
        this.checkRotation(reverted.compose(r, RotationConvention.VECTOR_OPERATOR), 1.0, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)r.getAngle(), (double)reverted.getAngle(), (double)1.0E-12);
        Assert.assertEquals((double)-1.0, (double)Vector3D.dotProduct((Vector3D)r.getAxis(RotationConvention.VECTOR_OPERATOR), (Vector3D)reverted.getAxis(RotationConvention.VECTOR_OPERATOR)), (double)1.0E-12);
    }

    @Test
    public void testRevertFrameTransform() {
        Rotation r = new Rotation(0.001, 0.36, 0.48, 0.8, true);
        Rotation reverted = r.revert();
        this.checkRotation(r.compose(reverted, RotationConvention.FRAME_TRANSFORM), 1.0, 0.0, 0.0, 0.0);
        this.checkRotation(reverted.compose(r, RotationConvention.FRAME_TRANSFORM), 1.0, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)r.getAngle(), (double)reverted.getAngle(), (double)1.0E-12);
        Assert.assertEquals((double)-1.0, (double)Vector3D.dotProduct((Vector3D)r.getAxis(RotationConvention.FRAME_TRANSFORM), (Vector3D)reverted.getAxis(RotationConvention.FRAME_TRANSFORM)), (double)1.0E-12);
    }

    @Test
    public void testVectorOnePair() throws MathArithmeticException {
        Vector3D u = new Vector3D(3.0, 2.0, 1.0);
        Vector3D v = new Vector3D(-4.0, 2.0, 2.0);
        Rotation r = new Rotation(u, v);
        this.checkVector(r.applyTo(u.scalarMultiply(v.getNorm())), v.scalarMultiply(u.getNorm()));
        this.checkAngle(new Rotation(u, u.negate()).getAngle(), Math.PI);
        try {
            new Rotation(u, Vector3D.ZERO);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testVectorTwoPairs() throws MathArithmeticException {
        Vector3D u1 = new Vector3D(3.0, 0.0, 0.0);
        Vector3D u2 = new Vector3D(0.0, 5.0, 0.0);
        Vector3D v1 = new Vector3D(0.0, 0.0, 2.0);
        Vector3D v2 = new Vector3D(-2.0, 0.0, 2.0);
        Rotation r = new Rotation(u1, u2, v1, v2);
        this.checkVector(r.applyTo(Vector3D.PLUS_I), Vector3D.PLUS_K);
        this.checkVector(r.applyTo(Vector3D.PLUS_J), Vector3D.MINUS_I);
        r = new Rotation(u1, u2, u1.negate(), u2.negate());
        Vector3D axis = r.getAxis(RotationConvention.VECTOR_OPERATOR);
        if (Vector3D.dotProduct((Vector3D)axis, (Vector3D)Vector3D.PLUS_K) > 0.0) {
            this.checkVector(axis, Vector3D.PLUS_K);
        } else {
            this.checkVector(axis, Vector3D.MINUS_K);
        }
        this.checkAngle(r.getAngle(), Math.PI);
        double sqrt = FastMath.sqrt((double)2.0) / 2.0;
        r = new Rotation(Vector3D.PLUS_I, Vector3D.PLUS_J, new Vector3D(0.5, 0.5, sqrt), new Vector3D(0.5, 0.5, -sqrt));
        this.checkRotation(r, sqrt, 0.5, 0.5, 0.0);
        r = new Rotation(u1, u2, u1, Vector3D.crossProduct((Vector3D)u1, (Vector3D)u2));
        this.checkRotation(r, sqrt, -sqrt, 0.0, 0.0);
        this.checkRotation(new Rotation(u1, u2, u1, u2), 1.0, 0.0, 0.0, 0.0);
        try {
            new Rotation(u1, u2, Vector3D.ZERO, v2);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testMatrix() throws NotARotationMatrixException {
        try {
            new Rotation((double[][])new double[][]{{0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}}, 1.0E-7);
            Assert.fail((String)"Expecting NotARotationMatrixException");
        }
        catch (NotARotationMatrixException notARotationMatrixException) {
            // empty catch block
        }
        try {
            new Rotation((double[][])new double[][]{{0.445888, 0.797184, -0.40704}, {0.82176, -0.18432, 0.5392}, {-0.354816, 0.574912, 0.73728}}, 1.0E-7);
            Assert.fail((String)"Expecting NotARotationMatrixException");
        }
        catch (NotARotationMatrixException notARotationMatrixException) {
            // empty catch block
        }
        try {
            new Rotation((double[][])new double[][]{{0.4, 0.8, -0.4}, {-0.4, 0.6, 0.7}, {0.8, -0.2, 0.5}}, 1.0E-15);
            Assert.fail((String)"Expecting NotARotationMatrixException");
        }
        catch (NotARotationMatrixException notARotationMatrixException) {
            // empty catch block
        }
        this.checkRotation(new Rotation((double[][])new double[][]{{0.445888, 0.797184, -0.40704}, {-0.354816, 0.574912, 0.73728}, {0.82176, -0.18432, 0.5392}}, 1.0E-10), 0.8, 0.288, 0.384, 0.36);
        this.checkRotation(new Rotation((double[][])new double[][]{{0.5392, 0.73728, 0.40704}, {0.18432, -0.574912, 0.797184}, {0.82176, -0.354816, -0.445888}}, 1.0E-10), 0.36, 0.8, 0.288, 0.384);
        this.checkRotation(new Rotation((double[][])new double[][]{{-0.445888, 0.797184, -0.40704}, {0.354816, 0.574912, 0.73728}, {0.82176, 0.18432, -0.5392}}, 1.0E-10), 0.384, 0.36, 0.8, 0.288);
        this.checkRotation(new Rotation((double[][])new double[][]{{-0.5392, 0.73728, 0.40704}, {-0.18432, -0.574912, 0.797184}, {0.82176, 0.354816, 0.445888}}, 1.0E-10), 0.288, 0.384, 0.36, 0.8);
        double[][] m1 = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}};
        Rotation r = new Rotation((double[][])m1, 1.0E-7);
        this.checkVector(r.applyTo(Vector3D.PLUS_I), Vector3D.PLUS_K);
        this.checkVector(r.applyTo(Vector3D.PLUS_J), Vector3D.PLUS_I);
        this.checkVector(r.applyTo(Vector3D.PLUS_K), Vector3D.PLUS_J);
        double[][] m2 = new double[][]{{0.83203, -0.55012, -0.07139}, {0.48293, 0.78164, -0.39474}, {0.27296, 0.29396, 0.91602}};
        r = new Rotation((double[][])m2, 1.0E-12);
        double[][] m3 = r.getMatrix();
        double d00 = m2[0][0] - m3[0][0];
        double d01 = m2[0][1] - m3[0][1];
        double d02 = m2[0][2] - m3[0][2];
        double d10 = m2[1][0] - m3[1][0];
        double d11 = m2[1][1] - m3[1][1];
        double d12 = m2[1][2] - m3[1][2];
        double d20 = m2[2][0] - m3[2][0];
        double d21 = m2[2][1] - m3[2][1];
        double d22 = m2[2][2] - m3[2][2];
        Assert.assertTrue((FastMath.abs((double)d00) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d01) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d02) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d10) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d11) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d12) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d20) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d21) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d22) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d00) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d01) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d02) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d10) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d11) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d12) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d20) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d21) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d22) > 4.0E-7 ? 1 : 0) != 0);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double m3tm3 = m3[i][0] * m3[j][0] + m3[i][1] * m3[j][1] + m3[i][2] * m3[j][2];
                if (i == j) {
                    Assert.assertTrue((FastMath.abs((double)(m3tm3 - 1.0)) < 1.0E-10 ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((FastMath.abs((double)m3tm3) < 1.0E-10 ? 1 : 0) != 0);
            }
        }
        this.checkVector(r.applyTo(Vector3D.PLUS_I), new Vector3D(m3[0][0], m3[1][0], m3[2][0]));
        this.checkVector(r.applyTo(Vector3D.PLUS_J), new Vector3D(m3[0][1], m3[1][1], m3[2][1]));
        this.checkVector(r.applyTo(Vector3D.PLUS_K), new Vector3D(m3[0][2], m3[1][2], m3[2][2]));
        double[][] m4 = new double[][]{{1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, -1.0}};
        r = new Rotation((double[][])m4, 1.0E-7);
        this.checkAngle(r.getAngle(), Math.PI);
        try {
            double[][] m5 = new double[][]{{0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}};
            r = new Rotation((double[][])m5, 1.0E-7);
            Assert.fail((String)("got " + r + ", should have caught an exception"));
        }
        catch (NotARotationMatrixException notARotationMatrixException) {
            // empty catch block
        }
    }

    @Test
    @Deprecated
    public void testAnglesDeprecated() throws CardanEulerSingularityException {
        RotationOrder[] CardanOrders = new RotationOrder[]{RotationOrder.XYZ, RotationOrder.XZY, RotationOrder.YXZ, RotationOrder.YZX, RotationOrder.ZXY, RotationOrder.ZYX};
        for (int i = 0; i < CardanOrders.length; ++i) {
            for (double alpha1 = 0.1; alpha1 < 6.2; alpha1 += 0.3) {
                for (double alpha2 = -1.55; alpha2 < 1.55; alpha2 += 0.3) {
                    for (double alpha3 = 0.1; alpha3 < 6.2; alpha3 += 0.3) {
                        Rotation r = new Rotation(CardanOrders[i], alpha1, alpha2, alpha3);
                        double[] angles = r.getAngles(CardanOrders[i]);
                        this.checkAngle(angles[0], alpha1);
                        this.checkAngle(angles[1], alpha2);
                        this.checkAngle(angles[2], alpha3);
                    }
                }
            }
        }
        RotationOrder[] EulerOrders = new RotationOrder[]{RotationOrder.XYX, RotationOrder.XZX, RotationOrder.YXY, RotationOrder.YZY, RotationOrder.ZXZ, RotationOrder.ZYZ};
        for (int i = 0; i < EulerOrders.length; ++i) {
            for (double alpha1 = 0.1; alpha1 < 6.2; alpha1 += 0.3) {
                for (double alpha2 = 0.05; alpha2 < 3.1; alpha2 += 0.3) {
                    for (double alpha3 = 0.1; alpha3 < 6.2; alpha3 += 0.3) {
                        Rotation r = new Rotation(EulerOrders[i], alpha1, alpha2, alpha3);
                        double[] angles = r.getAngles(EulerOrders[i]);
                        this.checkAngle(angles[0], alpha1);
                        this.checkAngle(angles[1], alpha2);
                        this.checkAngle(angles[2], alpha3);
                    }
                }
            }
        }
    }

    @Test
    public void testAngles() throws CardanEulerSingularityException {
        for (RotationConvention convention : RotationConvention.values()) {
            RotationOrder[] CardanOrders = new RotationOrder[]{RotationOrder.XYZ, RotationOrder.XZY, RotationOrder.YXZ, RotationOrder.YZX, RotationOrder.ZXY, RotationOrder.ZYX};
            for (int i = 0; i < CardanOrders.length; ++i) {
                for (double alpha1 = 0.1; alpha1 < 6.2; alpha1 += 0.3) {
                    for (double alpha2 = -1.55; alpha2 < 1.55; alpha2 += 0.3) {
                        for (double alpha3 = 0.1; alpha3 < 6.2; alpha3 += 0.3) {
                            Rotation r = new Rotation(CardanOrders[i], convention, alpha1, alpha2, alpha3);
                            double[] angles = r.getAngles(CardanOrders[i], convention);
                            this.checkAngle(angles[0], alpha1);
                            this.checkAngle(angles[1], alpha2);
                            this.checkAngle(angles[2], alpha3);
                        }
                    }
                }
            }
            RotationOrder[] EulerOrders = new RotationOrder[]{RotationOrder.XYX, RotationOrder.XZX, RotationOrder.YXY, RotationOrder.YZY, RotationOrder.ZXZ, RotationOrder.ZYZ};
            for (int i = 0; i < EulerOrders.length; ++i) {
                for (double alpha1 = 0.1; alpha1 < 6.2; alpha1 += 0.3) {
                    for (double alpha2 = 0.05; alpha2 < 3.1; alpha2 += 0.3) {
                        for (double alpha3 = 0.1; alpha3 < 6.2; alpha3 += 0.3) {
                            Rotation r = new Rotation(EulerOrders[i], convention, alpha1, alpha2, alpha3);
                            double[] angles = r.getAngles(EulerOrders[i], convention);
                            this.checkAngle(angles[0], alpha1);
                            this.checkAngle(angles[1], alpha2);
                            this.checkAngle(angles[2], alpha3);
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testSingularities() {
        for (RotationConvention convention : RotationConvention.values()) {
            RotationOrder[] CardanOrders = new RotationOrder[]{RotationOrder.XYZ, RotationOrder.XZY, RotationOrder.YXZ, RotationOrder.YZX, RotationOrder.ZXY, RotationOrder.ZYX};
            double[] singularCardanAngle = new double[]{1.5707963267948966, -1.5707963267948966};
            for (int i = 0; i < CardanOrders.length; ++i) {
                for (int j = 0; j < singularCardanAngle.length; ++j) {
                    Rotation r = new Rotation(CardanOrders[i], convention, 0.1, singularCardanAngle[j], 0.3);
                    try {
                        r.getAngles(CardanOrders[i], convention);
                        Assert.fail((String)"an exception should have been caught");
                        continue;
                    }
                    catch (CardanEulerSingularityException cardanEulerSingularityException) {
                        // empty catch block
                    }
                }
            }
            RotationOrder[] EulerOrders = new RotationOrder[]{RotationOrder.XYX, RotationOrder.XZX, RotationOrder.YXY, RotationOrder.YZY, RotationOrder.ZXZ, RotationOrder.ZYZ};
            double[] singularEulerAngle = new double[]{0.0, Math.PI};
            for (int i = 0; i < EulerOrders.length; ++i) {
                for (int j = 0; j < singularEulerAngle.length; ++j) {
                    Rotation r = new Rotation(EulerOrders[i], convention, 0.1, singularEulerAngle[j], 0.3);
                    try {
                        r.getAngles(EulerOrders[i], convention);
                        Assert.fail((String)"an exception should have been caught");
                        continue;
                    }
                    catch (CardanEulerSingularityException cardanEulerSingularityException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Test
    public void testQuaternion() throws MathIllegalArgumentException {
        Rotation r1 = new Rotation(new Vector3D(2.0, -3.0, 5.0), 1.7, RotationConvention.VECTOR_OPERATOR);
        double n = 23.5;
        Rotation r2 = new Rotation(n * r1.getQ0(), n * r1.getQ1(), n * r1.getQ2(), n * r1.getQ3(), true);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    Vector3D u = new Vector3D(x, y, z);
                    this.checkVector(r2.applyTo(u), r1.applyTo(u));
                }
            }
        }
        r1 = new Rotation(0.288, 0.384, 0.36, 0.8, false);
        this.checkRotation(r1, -r1.getQ0(), -r1.getQ1(), -r1.getQ2(), -r1.getQ3());
    }

    @Test
    public void testApplyTo() throws MathIllegalArgumentException {
        Rotation r1 = new Rotation(new Vector3D(2.0, -3.0, 5.0), 1.7, RotationConvention.VECTOR_OPERATOR);
        Rotation r2 = new Rotation(new Vector3D(-1.0, 3.0, 2.0), 0.3, RotationConvention.VECTOR_OPERATOR);
        Rotation r3 = r2.applyTo(r1);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    Vector3D u = new Vector3D(x, y, z);
                    this.checkVector(r2.applyTo(r1.applyTo(u)), r3.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testComposeVectorOperator() throws MathIllegalArgumentException {
        Rotation r1 = new Rotation(new Vector3D(2.0, -3.0, 5.0), 1.7, RotationConvention.VECTOR_OPERATOR);
        Rotation r2 = new Rotation(new Vector3D(-1.0, 3.0, 2.0), 0.3, RotationConvention.VECTOR_OPERATOR);
        Rotation r3 = r2.compose(r1, RotationConvention.VECTOR_OPERATOR);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    Vector3D u = new Vector3D(x, y, z);
                    this.checkVector(r2.applyTo(r1.applyTo(u)), r3.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testComposeFrameTransform() throws MathIllegalArgumentException {
        Rotation r1 = new Rotation(new Vector3D(2.0, -3.0, 5.0), 1.7, RotationConvention.FRAME_TRANSFORM);
        Rotation r2 = new Rotation(new Vector3D(-1.0, 3.0, 2.0), 0.3, RotationConvention.FRAME_TRANSFORM);
        Rotation r3 = r2.compose(r1, RotationConvention.FRAME_TRANSFORM);
        Rotation r4 = r1.compose(r2, RotationConvention.VECTOR_OPERATOR);
        Assert.assertEquals((double)0.0, (double)Rotation.distance((Rotation)r3, (Rotation)r4), (double)1.0E-15);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    Vector3D u = new Vector3D(x, y, z);
                    this.checkVector(r1.applyTo(r2.applyTo(u)), r3.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testApplyInverseToRotation() throws MathIllegalArgumentException {
        Rotation r1 = new Rotation(new Vector3D(2.0, -3.0, 5.0), 1.7, RotationConvention.VECTOR_OPERATOR);
        Rotation r2 = new Rotation(new Vector3D(-1.0, 3.0, 2.0), 0.3, RotationConvention.VECTOR_OPERATOR);
        Rotation r3 = r2.applyInverseTo(r1);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    Vector3D u = new Vector3D(x, y, z);
                    this.checkVector(r2.applyInverseTo(r1.applyTo(u)), r3.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testComposeInverseVectorOperator() throws MathIllegalArgumentException {
        Rotation r1 = new Rotation(new Vector3D(2.0, -3.0, 5.0), 1.7, RotationConvention.VECTOR_OPERATOR);
        Rotation r2 = new Rotation(new Vector3D(-1.0, 3.0, 2.0), 0.3, RotationConvention.VECTOR_OPERATOR);
        Rotation r3 = r2.composeInverse(r1, RotationConvention.VECTOR_OPERATOR);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    Vector3D u = new Vector3D(x, y, z);
                    this.checkVector(r2.applyInverseTo(r1.applyTo(u)), r3.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testComposeInverseFrameTransform() throws MathIllegalArgumentException {
        Rotation r1 = new Rotation(new Vector3D(2.0, -3.0, 5.0), 1.7, RotationConvention.FRAME_TRANSFORM);
        Rotation r2 = new Rotation(new Vector3D(-1.0, 3.0, 2.0), 0.3, RotationConvention.FRAME_TRANSFORM);
        Rotation r3 = r2.composeInverse(r1, RotationConvention.FRAME_TRANSFORM);
        Rotation r4 = r1.revert().composeInverse(r2.revert(), RotationConvention.VECTOR_OPERATOR);
        Assert.assertEquals((double)0.0, (double)Rotation.distance((Rotation)r3, (Rotation)r4), (double)1.0E-15);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    Vector3D u = new Vector3D(x, y, z);
                    this.checkVector(r1.applyTo(r2.applyInverseTo(u)), r3.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testArray() throws MathIllegalArgumentException {
        Rotation r = new Rotation(new Vector3D(2.0, -3.0, 5.0), 1.7, RotationConvention.VECTOR_OPERATOR);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    Vector3D u = new Vector3D(x, y, z);
                    Vector3D v = r.applyTo(u);
                    double[] inOut = new double[]{x, y, z};
                    r.applyTo(inOut, inOut);
                    Assert.assertEquals((double)v.getX(), (double)inOut[0], (double)1.0E-10);
                    Assert.assertEquals((double)v.getY(), (double)inOut[1], (double)1.0E-10);
                    Assert.assertEquals((double)v.getZ(), (double)inOut[2], (double)1.0E-10);
                    r.applyInverseTo(inOut, inOut);
                    Assert.assertEquals((double)u.getX(), (double)inOut[0], (double)1.0E-10);
                    Assert.assertEquals((double)u.getY(), (double)inOut[1], (double)1.0E-10);
                    Assert.assertEquals((double)u.getZ(), (double)inOut[2], (double)1.0E-10);
                }
            }
        }
    }

    @Test
    public void testApplyInverseTo() throws MathIllegalArgumentException {
        Vector3D u;
        double phi;
        double lambda;
        Rotation r = new Rotation(new Vector3D(2.0, -3.0, 5.0), 1.7, RotationConvention.VECTOR_OPERATOR);
        for (lambda = 0.0; lambda < 6.2; lambda += 0.2) {
            for (phi = -1.55; phi < 1.55; phi += 0.2) {
                u = new Vector3D(FastMath.cos((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)phi));
                r.applyInverseTo(r.applyTo(u));
                this.checkVector(u, r.applyInverseTo(r.applyTo(u)));
                this.checkVector(u, r.applyTo(r.applyInverseTo(u)));
            }
        }
        r = Rotation.IDENTITY;
        for (lambda = 0.0; lambda < 6.2; lambda += 0.2) {
            for (phi = -1.55; phi < 1.55; phi += 0.2) {
                u = new Vector3D(FastMath.cos((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)phi));
                this.checkVector(u, r.applyInverseTo(r.applyTo(u)));
                this.checkVector(u, r.applyTo(r.applyInverseTo(u)));
            }
        }
        r = new Rotation(Vector3D.PLUS_K, Math.PI, RotationConvention.VECTOR_OPERATOR);
        for (lambda = 0.0; lambda < 6.2; lambda += 0.2) {
            for (phi = -1.55; phi < 1.55; phi += 0.2) {
                u = new Vector3D(FastMath.cos((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)phi));
                this.checkVector(u, r.applyInverseTo(r.applyTo(u)));
                this.checkVector(u, r.applyTo(r.applyInverseTo(u)));
            }
        }
    }

    @Test
    public void testIssue639() throws MathArithmeticException {
        Vector3D u1 = new Vector3D(-4921140.837095533, -2.1512094250440013E7, -890093.279426377);
        Vector3D u2 = new Vector3D(-2.7238580938724895E9, -2.169664921341876E9, 6.749688708885301E10);
        Rotation rot = new Rotation(u1, u2, Vector3D.PLUS_I, Vector3D.PLUS_K);
        Assert.assertEquals((double)0.6228370359608201, (double)rot.getQ0(), (double)1.0E-15);
        Assert.assertEquals((double)0.02577076214564988, (double)rot.getQ1(), (double)1.0E-15);
        Assert.assertEquals((double)-2.503012255839931E-10, (double)rot.getQ2(), (double)1.0E-15);
        Assert.assertEquals((double)-0.7819270390861109, (double)rot.getQ3(), (double)1.0E-15);
    }

    @Test
    public void testIssue801() throws MathArithmeticException {
        Vector3D u1 = new Vector3D(0.9999988431610581, -0.0015210774290851095, 0.0);
        Vector3D u2 = new Vector3D(0.0, 0.0, 1.0);
        Vector3D v1 = new Vector3D(0.9999999999999999, 0.0, 0.0);
        Vector3D v2 = new Vector3D(0.0, 0.0, -1.0);
        Rotation quat = new Rotation(u1, u2, v1, v2);
        double q2 = quat.getQ0() * quat.getQ0() + quat.getQ1() * quat.getQ1() + quat.getQ2() * quat.getQ2() + quat.getQ3() * quat.getQ3();
        Assert.assertEquals((double)1.0, (double)q2, (double)1.0E-14);
        Assert.assertEquals((double)0.0, (double)Vector3D.angle((Vector3D)v1, (Vector3D)quat.applyTo(u1)), (double)1.0E-14);
        Assert.assertEquals((double)0.0, (double)Vector3D.angle((Vector3D)v2, (Vector3D)quat.applyTo(u2)), (double)1.0E-14);
    }

    @Test
    public void testGithubPullRequest22A() {
        Vector3D startingVector;
        RotationOrder order = RotationOrder.ZYX;
        double xRotation = FastMath.toDegrees((double)30.0);
        double yRotation = FastMath.toDegrees((double)20.0);
        double zRotation = FastMath.toDegrees((double)10.0);
        Vector3D appliedIndividually = startingVector = Vector3D.PLUS_I;
        appliedIndividually = new Rotation(order, RotationConvention.FRAME_TRANSFORM, zRotation, 0.0, 0.0).applyTo(appliedIndividually);
        appliedIndividually = new Rotation(order, RotationConvention.FRAME_TRANSFORM, 0.0, yRotation, 0.0).applyTo(appliedIndividually);
        appliedIndividually = new Rotation(order, RotationConvention.FRAME_TRANSFORM, 0.0, 0.0, xRotation).applyTo(appliedIndividually);
        Vector3D bad = new Rotation(order, RotationConvention.FRAME_TRANSFORM, zRotation, yRotation, xRotation).applyTo(startingVector);
        Assert.assertEquals((double)bad.getX(), (double)appliedIndividually.getX(), (double)1.0E-12);
        Assert.assertEquals((double)bad.getY(), (double)appliedIndividually.getY(), (double)1.0E-12);
        Assert.assertEquals((double)bad.getZ(), (double)appliedIndividually.getZ(), (double)1.0E-12);
    }

    @Test
    public void testGithubPullRequest22B() {
        Vector3D startingVector;
        RotationOrder order = RotationOrder.ZYX;
        double xRotation = FastMath.toDegrees((double)30.0);
        double yRotation = FastMath.toDegrees((double)20.0);
        double zRotation = FastMath.toDegrees((double)10.0);
        Vector3D appliedIndividually = startingVector = Vector3D.PLUS_I;
        appliedIndividually = new Rotation(order, RotationConvention.FRAME_TRANSFORM, zRotation, 0.0, 0.0).applyTo(appliedIndividually);
        appliedIndividually = new Rotation(order, RotationConvention.FRAME_TRANSFORM, 0.0, yRotation, 0.0).applyTo(appliedIndividually);
        appliedIndividually = new Rotation(order, RotationConvention.FRAME_TRANSFORM, 0.0, 0.0, xRotation).applyTo(appliedIndividually);
        Rotation r1 = new Rotation(order.getA1(), zRotation, RotationConvention.FRAME_TRANSFORM);
        Rotation r2 = new Rotation(order.getA2(), yRotation, RotationConvention.FRAME_TRANSFORM);
        Rotation r3 = new Rotation(order.getA3(), xRotation, RotationConvention.FRAME_TRANSFORM);
        Rotation composite = r1.compose(r2.compose(r3, RotationConvention.FRAME_TRANSFORM), RotationConvention.FRAME_TRANSFORM);
        Vector3D good = composite.applyTo(startingVector);
        Assert.assertEquals((double)good.getX(), (double)appliedIndividually.getX(), (double)1.0E-12);
        Assert.assertEquals((double)good.getY(), (double)appliedIndividually.getY(), (double)1.0E-12);
        Assert.assertEquals((double)good.getZ(), (double)appliedIndividually.getZ(), (double)1.0E-12);
    }

    private void checkVector(Vector3D v1, Vector3D v2) {
        Assert.assertTrue((v1.subtract((Vector)v2).getNorm() < 1.0E-10 ? 1 : 0) != 0);
    }

    private void checkAngle(double a1, double a2) {
        Assert.assertEquals((double)a1, (double)MathUtils.normalizeAngle((double)a2, (double)a1), (double)1.0E-10);
    }

    private void checkRotation(Rotation r, double q0, double q1, double q2, double q3) {
        Assert.assertEquals((double)0.0, (double)Rotation.distance((Rotation)r, (Rotation)new Rotation(q0, q1, q2, q3, false)), (double)1.0E-12);
    }
}

