/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathArithmeticException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.Vector;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Line;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Plane;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.junit.Assert;
import org.junit.Test;

public class PlaneTest {
    @Test
    public void testContains() throws MathArithmeticException {
        Plane p = new Plane(new Vector3D(0.0, 0.0, 1.0), new Vector3D(0.0, 0.0, 1.0), 1.0E-10);
        Assert.assertTrue((boolean)p.contains(new Vector3D(0.0, 0.0, 1.0)));
        Assert.assertTrue((boolean)p.contains(new Vector3D(17.0, -32.0, 1.0)));
        Assert.assertTrue((!p.contains(new Vector3D(17.0, -32.0, 1.001)) ? 1 : 0) != 0);
    }

    @Test
    public void testOffset() throws MathArithmeticException {
        Vector3D p1 = new Vector3D(1.0, 1.0, 1.0);
        Plane p = new Plane(p1, new Vector3D(0.2, 0.0, 0.0), 1.0E-10);
        Assert.assertEquals((double)-5.0, (double)p.getOffset((Vector)new Vector3D(-4.0, 0.0, 0.0)), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)p.getOffset((Vector)new Vector3D(6.0, 10.0, -12.0)), (double)1.0E-10);
        Assert.assertEquals((double)0.3, (double)p.getOffset((Vector)new Vector3D(1.0, p1, 0.3, p.getNormal())), (double)1.0E-10);
        Assert.assertEquals((double)-0.3, (double)p.getOffset((Vector)new Vector3D(1.0, p1, -0.3, p.getNormal())), (double)1.0E-10);
    }

    @Test
    public void testPoint() throws MathArithmeticException {
        Plane p = new Plane(new Vector3D(2.0, -3.0, 1.0), new Vector3D(1.0, 4.0, 9.0), 1.0E-10);
        Assert.assertTrue((boolean)p.contains(p.getOrigin()));
    }

    @Test
    public void testThreePoints() throws MathArithmeticException {
        Vector3D p1 = new Vector3D(1.2, 3.4, -5.8);
        Vector3D p2 = new Vector3D(3.4, -5.8, 1.2);
        Vector3D p3 = new Vector3D(-2.0, 4.3, 0.7);
        Plane p = new Plane(p1, p2, p3, 1.0E-10);
        Assert.assertTrue((boolean)p.contains(p1));
        Assert.assertTrue((boolean)p.contains(p2));
        Assert.assertTrue((boolean)p.contains(p3));
    }

    @Test
    public void testRotate() throws MathArithmeticException, MathIllegalArgumentException {
        Vector3D p1 = new Vector3D(1.2, 3.4, -5.8);
        Vector3D p2 = new Vector3D(3.4, -5.8, 1.2);
        Vector3D p3 = new Vector3D(-2.0, 4.3, 0.7);
        Plane p = new Plane(p1, p2, p3, 1.0E-10);
        Vector3D oldNormal = p.getNormal();
        p = p.rotate(p2, new Rotation(p2.subtract((Vector)p1), 1.7, RotationConvention.VECTOR_OPERATOR));
        Assert.assertTrue((boolean)p.contains(p1));
        Assert.assertTrue((boolean)p.contains(p2));
        Assert.assertTrue((!p.contains(p3) ? 1 : 0) != 0);
        p = p.rotate(p2, new Rotation(oldNormal, 0.1, RotationConvention.VECTOR_OPERATOR));
        Assert.assertTrue((!p.contains(p1) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)p.contains(p2));
        Assert.assertTrue((!p.contains(p3) ? 1 : 0) != 0);
        p = p.rotate(p1, new Rotation(oldNormal, 0.1, RotationConvention.VECTOR_OPERATOR));
        Assert.assertTrue((!p.contains(p1) ? 1 : 0) != 0);
        Assert.assertTrue((!p.contains(p2) ? 1 : 0) != 0);
        Assert.assertTrue((!p.contains(p3) ? 1 : 0) != 0);
    }

    @Test
    public void testTranslate() throws MathArithmeticException {
        Vector3D p1 = new Vector3D(1.2, 3.4, -5.8);
        Vector3D p2 = new Vector3D(3.4, -5.8, 1.2);
        Vector3D p3 = new Vector3D(-2.0, 4.3, 0.7);
        Plane p = new Plane(p1, p2, p3, 1.0E-10);
        p = p.translate(new Vector3D(2.0, p.getU(), -1.5, p.getV()));
        Assert.assertTrue((boolean)p.contains(p1));
        Assert.assertTrue((boolean)p.contains(p2));
        Assert.assertTrue((boolean)p.contains(p3));
        p = p.translate(new Vector3D(-1.2, p.getNormal()));
        Assert.assertTrue((!p.contains(p1) ? 1 : 0) != 0);
        Assert.assertTrue((!p.contains(p2) ? 1 : 0) != 0);
        Assert.assertTrue((!p.contains(p3) ? 1 : 0) != 0);
        p = p.translate(new Vector3D(1.2, p.getNormal()));
        Assert.assertTrue((boolean)p.contains(p1));
        Assert.assertTrue((boolean)p.contains(p2));
        Assert.assertTrue((boolean)p.contains(p3));
    }

    @Test
    public void testIntersection() throws MathArithmeticException, MathIllegalArgumentException {
        Plane p = new Plane(new Vector3D(1.0, 2.0, 3.0), new Vector3D(-4.0, 1.0, -5.0), 1.0E-10);
        Line l = new Line(new Vector3D(0.2, -3.5, 0.7), new Vector3D(1.2, -2.5, -0.3), 1.0E-10);
        Vector3D point = p.intersection(l);
        Assert.assertTrue((boolean)p.contains(point));
        Assert.assertTrue((boolean)l.contains(point));
        Assert.assertNull((Object)p.intersection(new Line(new Vector3D(10.0, 10.0, 10.0), new Vector3D(10.0, 10.0, 10.0).add((Vector)p.getNormal().orthogonal()), 1.0E-10)));
    }

    @Test
    public void testIntersection2() throws MathArithmeticException {
        Vector3D p1 = new Vector3D(1.2, 3.4, -5.8);
        Vector3D p2 = new Vector3D(3.4, -5.8, 1.2);
        Plane pA = new Plane(p1, p2, new Vector3D(-2.0, 4.3, 0.7), 1.0E-10);
        Plane pB = new Plane(p1, new Vector3D(11.4, -3.8, 5.1), p2, 1.0E-10);
        Line l = pA.intersection(pB);
        Assert.assertTrue((boolean)l.contains(p1));
        Assert.assertTrue((boolean)l.contains(p2));
        Assert.assertNull((Object)pA.intersection(pA));
    }

    @Test
    public void testIntersection3() throws MathArithmeticException {
        Vector3D reference = new Vector3D(1.2, 3.4, -5.8);
        Plane p1 = new Plane(reference, new Vector3D(1.0, 3.0, 3.0), 1.0E-10);
        Plane p2 = new Plane(reference, new Vector3D(-2.0, 4.0, 0.0), 1.0E-10);
        Plane p3 = new Plane(reference, new Vector3D(7.0, 0.0, -4.0), 1.0E-10);
        Vector3D p = Plane.intersection((Plane)p1, (Plane)p2, (Plane)p3);
        Assert.assertEquals((double)reference.getX(), (double)p.getX(), (double)1.0E-10);
        Assert.assertEquals((double)reference.getY(), (double)p.getY(), (double)1.0E-10);
        Assert.assertEquals((double)reference.getZ(), (double)p.getZ(), (double)1.0E-10);
    }

    @Test
    public void testSimilar() throws MathArithmeticException {
        Vector3D p1 = new Vector3D(1.2, 3.4, -5.8);
        Vector3D p2 = new Vector3D(3.4, -5.8, 1.2);
        Vector3D p3 = new Vector3D(-2.0, 4.3, 0.7);
        Plane pA = new Plane(p1, p2, p3, 1.0E-10);
        Plane pB = new Plane(p1, new Vector3D(11.4, -3.8, 5.1), p2, 1.0E-10);
        Assert.assertTrue((!pA.isSimilarTo(pB) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pA.isSimilarTo(pA));
        Assert.assertTrue((boolean)pA.isSimilarTo(new Plane(p1, p3, p2, 1.0E-10)));
        Vector3D shift = new Vector3D(0.3, pA.getNormal());
        Assert.assertTrue((!pA.isSimilarTo(new Plane(p1.add((Vector)shift), p3.add((Vector)shift), p2.add((Vector)shift), 1.0E-10)) ? 1 : 0) != 0);
    }
}

