/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.oned;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathParseException;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.Vector;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.oned.Vector1DFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public abstract class Vector1DFormatAbstractTest {
    Vector1DFormat vector1DFormat = Vector1DFormat.getInstance((Locale)this.getLocale());
    Vector1DFormat vector1DFormatSquare = null;

    protected abstract Locale getLocale();

    protected abstract char getDecimalCharacter();

    protected Vector1DFormatAbstractTest() {
        NumberFormat nf = NumberFormat.getInstance(this.getLocale());
        nf.setMaximumFractionDigits(2);
        this.vector1DFormatSquare = new Vector1DFormat("[", "]", nf);
    }

    @Test
    public void testSimpleNoDecimals() {
        Vector1D c = new Vector1D(1.0);
        String expected = "{1}";
        String actual = this.vector1DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleWithDecimals() {
        Vector1D c = new Vector1D(1.23);
        String expected = "{1" + this.getDecimalCharacter() + "23}";
        String actual = this.vector1DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleWithDecimalsTrunc() {
        Vector1D c = new Vector1D(1.232323232323);
        String expected = "{1" + this.getDecimalCharacter() + "2323232323}";
        String actual = this.vector1DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeX() {
        Vector1D c = new Vector1D(-1.232323232323);
        String expected = "{-1" + this.getDecimalCharacter() + "2323232323}";
        String actual = this.vector1DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNonDefaultSetting() {
        Vector1D c = new Vector1D(1.0);
        String expected = "[1]";
        String actual = this.vector1DFormatSquare.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDefaultFormatVector1D() {
        Locale defaultLocal = Locale.getDefault();
        Locale.setDefault(this.getLocale());
        Vector1D c = new Vector1D(232.22222222222);
        String expected = "{232" + this.getDecimalCharacter() + "2222222222}";
        String actual = new Vector1DFormat().format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        Locale.setDefault(defaultLocal);
    }

    @Test
    public void testNan() {
        Vector1D c = Vector1D.NaN;
        String expected = "{(NaN)}";
        String actual = this.vector1DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testPositiveInfinity() {
        Vector1D c = Vector1D.POSITIVE_INFINITY;
        String expected = "{(Infinity)}";
        String actual = this.vector1DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void tesNegativeInfinity() {
        Vector1D c = Vector1D.NEGATIVE_INFINITY;
        String expected = "{(-Infinity)}";
        String actual = this.vector1DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseSimpleNoDecimals() throws MathParseException {
        String source = "{1}";
        Vector1D expected = new Vector1D(1.0);
        Vector1D actual = this.vector1DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseIgnoredWhitespace() {
        Vector1D expected = new Vector1D(1.0);
        ParsePosition pos1 = new ParsePosition(0);
        String source1 = "{1}";
        Assert.assertEquals((Object)expected, (Object)this.vector1DFormat.parse(source1, pos1));
        Assert.assertEquals((long)source1.length(), (long)pos1.getIndex());
        ParsePosition pos2 = new ParsePosition(0);
        String source2 = " { 1 } ";
        Assert.assertEquals((Object)expected, (Object)this.vector1DFormat.parse(source2, pos2));
        Assert.assertEquals((long)(source2.length() - 1), (long)pos2.getIndex());
    }

    @Test
    public void testParseSimpleWithDecimals() throws MathParseException {
        String source = "{1" + this.getDecimalCharacter() + "23}";
        Vector1D expected = new Vector1D(1.23);
        Vector1D actual = this.vector1DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseSimpleWithDecimalsTrunc() throws MathParseException {
        String source = "{1" + this.getDecimalCharacter() + "2323}";
        Vector1D expected = new Vector1D(1.2323);
        Vector1D actual = this.vector1DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeX() throws MathParseException {
        String source = "{-1" + this.getDecimalCharacter() + "2323}";
        Vector1D expected = new Vector1D(-1.2323);
        Vector1D actual = this.vector1DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeY() throws MathParseException {
        String source = "{1" + this.getDecimalCharacter() + "2323}";
        Vector1D expected = new Vector1D(1.2323);
        Vector1D actual = this.vector1DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeZ() throws MathParseException {
        String source = "{1" + this.getDecimalCharacter() + "2323}";
        Vector1D expected = new Vector1D(1.2323);
        Vector1D actual = this.vector1DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeAll() throws MathParseException {
        String source = "{-1" + this.getDecimalCharacter() + "2323}";
        Vector1D expected = new Vector1D(-1.2323);
        Vector1D actual = this.vector1DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseZeroX() throws MathParseException {
        String source = "{0" + this.getDecimalCharacter() + "0}";
        Vector1D expected = new Vector1D(0.0);
        Vector1D actual = this.vector1DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNonDefaultSetting() throws MathParseException {
        String source = "[1" + this.getDecimalCharacter() + "2323]";
        Vector1D expected = new Vector1D(1.2323);
        Vector1D actual = this.vector1DFormatSquare.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNan() throws MathParseException {
        String source = "{(NaN)}";
        Vector1D actual = this.vector1DFormat.parse(source);
        Assert.assertEquals((Object)Vector1D.NaN, (Object)actual);
    }

    @Test
    public void testParsePositiveInfinity() throws MathParseException {
        String source = "{(Infinity)}";
        Vector1D actual = this.vector1DFormat.parse(source);
        Assert.assertEquals((Object)Vector1D.POSITIVE_INFINITY, (Object)actual);
    }

    @Test
    public void testParseNegativeInfinity() throws MathParseException {
        String source = "{(-Infinity)}";
        Vector1D actual = this.vector1DFormat.parse(source);
        Assert.assertEquals((Object)Vector1D.NEGATIVE_INFINITY, (Object)actual);
    }

    @Test
    public void testConstructorSingleFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        Vector1DFormat cf = new Vector1DFormat(nf);
        Assert.assertNotNull((Object)cf);
        Assert.assertEquals((Object)nf, (Object)cf.getFormat());
    }

    @Test
    public void testForgottenPrefix() {
        ParsePosition pos = new ParsePosition(0);
        Assert.assertNull((Object)new Vector1DFormat().parse("1}", pos));
        Assert.assertEquals((long)0L, (long)pos.getErrorIndex());
    }

    @Test
    public void testForgottenSuffix() {
        ParsePosition pos = new ParsePosition(0);
        Assert.assertNull((Object)new Vector1DFormat().parse("{1 ", pos));
        Assert.assertEquals((long)2L, (long)pos.getErrorIndex());
    }
}

