/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.enclosing;

import com.hazelcast.shaded.org.apache.commons.math3.geometry.Point;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.enclosing.EnclosingBall;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.enclosing.SupportBallGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.enclosing.WelzlEncloser;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.DiskGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well1024a;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WelzlEncloser2DTest {
    @Test
    public void testNullList() {
        DiskGenerator generator = new DiskGenerator();
        WelzlEncloser encloser = new WelzlEncloser(1.0E-10, (SupportBallGenerator)generator);
        EnclosingBall ball = encloser.enclose(null);
        Assert.assertTrue((ball.getRadius() < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNoPoints() {
        DiskGenerator generator = new DiskGenerator();
        WelzlEncloser encloser = new WelzlEncloser(1.0E-10, (SupportBallGenerator)generator);
        EnclosingBall ball = encloser.enclose(new ArrayList());
        Assert.assertTrue((ball.getRadius() < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testRegularPoints() {
        List<Vector2D> list = this.buildList(22.0, 26.0, 30.0, 38.0, 64.0, 28.0, 8.0, 54.0, 11.0, 15.0);
        this.checkDisk(list, Arrays.asList(list.get(2), list.get(3), list.get(4)));
    }

    @Test
    public void testSolutionOnDiameter() {
        List<Vector2D> list = this.buildList(22.0, 26.0, 30.0, 38.0, 64.0, 28.0, 8.0, 54.0);
        this.checkDisk(list, Arrays.asList(list.get(2), list.get(3)));
    }

    @Test
    public void testReducingBall1() {
        List<Vector2D> list = this.buildList(0.05380958511396061, 0.573323596587, 0.9934881073112787, 0.02056421361521466, 0.01203950647796437, 0.9977967504226186, 0.00810189987706078, 0.00589246003827815, 0.00465180821202149, 0.9921997292304694);
        this.checkDisk(list, Arrays.asList(list.get(1), list.get(3), list.get(4)));
    }

    @Test
    public void testReducingBall2() {
        List<Vector2D> list = this.buildList(0.016930586154703, 0.333955448537779, 0.987189104892331, 0.969778855274507, 0.983696889599935, 0.012904580013266, 0.013114499572905, 0.034740156356895);
        this.checkDisk(list, Arrays.asList(list.get(1), list.get(2), list.get(3)));
    }

    @Test
    public void testLargeSamples() {
        Well1024a random = new Well1024a(-6726622279389667406L);
        for (int k = 0; k < 100; ++k) {
            int nbPoints = random.nextInt(10000);
            ArrayList<Vector2D> points = new ArrayList<Vector2D>();
            for (int i = 0; i < nbPoints; ++i) {
                double x = random.nextDouble();
                double y = random.nextDouble();
                points.add(new Vector2D(x, y));
            }
            this.checkDisk(points);
        }
    }

    private List<Vector2D> buildList(double ... coordinates) {
        ArrayList<Vector2D> list = new ArrayList<Vector2D>(coordinates.length / 2);
        for (int i = 0; i < coordinates.length; i += 2) {
            list.add(new Vector2D(coordinates[i], coordinates[i + 1]));
        }
        return list;
    }

    private void checkDisk(List<Vector2D> points, List<Vector2D> refSupport) {
        EnclosingBall<Euclidean2D, Vector2D> disk = this.checkDisk(points);
        DiskGenerator generator = new DiskGenerator();
        EnclosingBall expected = generator.ballOnSupport(refSupport);
        Assert.assertEquals((long)refSupport.size(), (long)disk.getSupportSize());
        Assert.assertEquals((double)expected.getRadius(), (double)disk.getRadius(), (double)1.0E-10);
        Assert.assertEquals((double)((Vector2D)expected.getCenter()).getX(), (double)((Vector2D)disk.getCenter()).getX(), (double)1.0E-10);
        Assert.assertEquals((double)((Vector2D)expected.getCenter()).getY(), (double)((Vector2D)disk.getCenter()).getY(), (double)1.0E-10);
        for (Vector2D s : (Vector2D[])disk.getSupport()) {
            boolean found = false;
            for (Vector2D rs : refSupport) {
                if (s != rs) continue;
                found = true;
            }
            Assert.assertTrue((boolean)found);
        }
        for (int i = 0; i < disk.getSupportSize(); ++i) {
            ArrayList<Vector2D> reducedSupport = new ArrayList<Vector2D>();
            int count = 0;
            for (Vector2D s : (Vector2D[])disk.getSupport()) {
                if (count++ == i) continue;
                reducedSupport.add(s);
            }
            EnclosingBall reducedDisk = generator.ballOnSupport(reducedSupport);
            boolean foundOutside = false;
            for (int j = 0; j < points.size() && !foundOutside; ++j) {
                if (reducedDisk.contains((Point)points.get(j), 1.0E-10)) continue;
                foundOutside = true;
            }
            Assert.assertTrue((boolean)foundOutside);
        }
    }

    private EnclosingBall<Euclidean2D, Vector2D> checkDisk(List<Vector2D> points) {
        WelzlEncloser encloser = new WelzlEncloser(1.0E-10, (SupportBallGenerator)new DiskGenerator());
        EnclosingBall disk = encloser.enclose(points);
        for (Vector2D v : points) {
            Assert.assertTrue((boolean)disk.contains((Point)v, 1.0E-10));
        }
        for (Vector2D v : points) {
            boolean inSupport = false;
            for (Vector2D s : (Vector2D[])disk.getSupport()) {
                if (v != s) continue;
                inSupport = true;
            }
            if (!inSupport) continue;
            Assert.assertFalse((boolean)disk.contains((Point)v, -0.001));
        }
        return disk;
    }
}

